/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.actions.ConnectUsingDriverAction;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public final class ConnectionManager {
    private static ConnectionManager DEFAULT;

    public static synchronized ConnectionManager getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ConnectionManager();
        }
        return DEFAULT;
    }

    public DatabaseConnection[] getConnections() {
        org.netbeans.modules.db.explorer.DatabaseConnection[] databaseConnectionArray = ConnectionList.getDefault().getConnections();
        DatabaseConnection[] databaseConnectionArray2 = new DatabaseConnection[databaseConnectionArray.length];
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            databaseConnectionArray2[i] = databaseConnectionArray[i].getDatabaseConnection();
        }
        return databaseConnectionArray2;
    }

    public DatabaseConnection getConnection(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        org.netbeans.modules.db.explorer.DatabaseConnection[] databaseConnectionArray = ConnectionList.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            DatabaseConnection databaseConnection = databaseConnectionArray[i].getDatabaseConnection();
            if (!string.equals(databaseConnection.getName())) continue;
            return databaseConnection;
        }
        return null;
    }

    public void addConnection(DatabaseConnection databaseConnection) throws DatabaseException {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnectionNoConnect(databaseConnection.getDelegate());
    }

    public void showAddConnectionDialog(JDBCDriver jDBCDriver) {
        this.showAddConnectionDialog(jDBCDriver, null, null, null);
    }

    public void showAddConnectionDialog(JDBCDriver jDBCDriver, String string) {
        this.showAddConnectionDialog(jDBCDriver, string, null, null);
    }

    public void showAddConnectionDialog(final JDBCDriver jDBCDriver, final String string, final String string2, final String string3) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                new ConnectUsingDriverAction.NewConnectionDialogDisplayer().showDialog(jDBCDriver, string, string2, string3);
            }
        });
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver jDBCDriver) {
        return this.showAddConnectionDialogFromEventThread(jDBCDriver, null, null, null);
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver jDBCDriver, String string) {
        return this.showAddConnectionDialogFromEventThread(jDBCDriver, string, null, null);
    }

    public DatabaseConnection showAddConnectionDialogFromEventThread(JDBCDriver jDBCDriver, String string, String string2, String string3) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("The current thread is not the event dispatching thread.");
        }
        org.netbeans.modules.db.explorer.DatabaseConnection databaseConnection = new ConnectUsingDriverAction.NewConnectionDialogDisplayer().showDialog(jDBCDriver, string, string2, string3);
        if (databaseConnection != null) {
            return databaseConnection.getDatabaseConnection();
        }
        return null;
    }

    public void showConnectionDialog(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(databaseConnection.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        databaseConnection.getDelegate().showConnectionDialog();
    }

    public void disconnect(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(databaseConnection.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        try {
            databaseConnection.getDelegate().disconnect();
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
    }

    public void selectConnectionInExplorer(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        if (!ConnectionList.getDefault().contains(databaseConnection.getDelegate())) {
            throw new IllegalStateException("This connection is not added to the ConnectionManager.");
        }
        databaseConnection.getDelegate().selectInExplorer();
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        ConnectionList.getDefault().addConnectionListener(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        ConnectionList.getDefault().removeConnectionListener(connectionListener);
    }
}

