/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import mondrian.olap.CacheControl;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;

public class Aggregation {
    private int maxConstraints;
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    private final List<SoftReference<Segment>> segmentRefs;
    private final Date creationTimestamp;
    private RolapStar.Column[] columns;

    public Aggregation(RolapStar star, BitKey constrainedColumnsBitKey) {
        this.star = star;
        this.constrainedColumnsBitKey = constrainedColumnsBitKey;
        this.segmentRefs = new ArrayList<SoftReference<Segment>>();
        this.maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        this.creationTimestamp = new Date();
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public synchronized void load(RolapStar.Column[] columns, RolapStar.Measure[] measures, StarColumnPredicate[] predicates, RolapAggregationManager.PinSet pinnedSegments) {
        this.columns = columns;
        BitKey measureBitKey = this.constrainedColumnsBitKey.emptyCopy();
        int axisCount = columns.length;
        Util.assertTrue(predicates.length == axisCount);
        Axis[] axes = new Axis[axisCount];
        for (int i = 0; i < axisCount; ++i) {
            axes[i] = new Axis(predicates[i]);
        }
        Segment[] segments = new Segment[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            Segment segment;
            RolapStar.Measure measure = measures[i];
            measureBitKey.set(measure.getBitPosition());
            List<Segment.Region> excludedRegions = Collections.emptyList();
            segments[i] = segment = new Segment(this, measure, axes, excludedRegions);
            SoftReference<Segment> ref = new SoftReference<Segment>(segment);
            this.segmentRefs.add(ref);
            ((AggregationManager.PinSetImpl)pinnedSegments).add(segment);
        }
        BitKey levelBitKey = this.constrainedColumnsBitKey;
        Segment.load(segments, levelBitKey, measureBitKey, pinnedSegments, axes);
    }

    public synchronized StarColumnPredicate[] optimizePredicates(RolapStar.Column[] columns, StarColumnPredicate[] predicates) {
        Util.assertTrue(predicates.length == columns.length);
        StarColumnPredicate[] newPredicates = (StarColumnPredicate[])predicates.clone();
        double[] bloats = new double[columns.length];
        ArrayList<RolapMember> potentialParents = new ArrayList<RolapMember>();
        for (StarColumnPredicate predicate : predicates) {
            if (!(predicate instanceof MemberColumnPredicate)) continue;
            RolapMember m = ((MemberColumnPredicate)predicate).getMember();
            potentialParents.add(m);
        }
        for (int i = 0; i < newPredicates.length; ++i) {
            int memberCount;
            SchemaReader scr;
            if (!(newPredicates[i] instanceof ListColumnPredicate)) {
                bloats[i] = 0.0;
                continue;
            }
            ListColumnPredicate newPredicate = (ListColumnPredicate)newPredicates[i];
            List<StarColumnPredicate> predicateList = newPredicate.getPredicates();
            int valueCount = predicateList.size();
            if (valueCount < 2) {
                bloats[i] = 0.0;
                continue;
            }
            if (valueCount > this.maxConstraints) {
                bloats[i] = 1.0;
                continue;
            }
            double constraintLength = valueCount;
            Member parent = null;
            Level level = null;
            for (int j = 0; j < valueCount; ++j) {
                StarColumnPredicate value = predicateList.get(j);
                if (value instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)value;
                    RolapMember m = memberColumnPredicate.getMember();
                    if (j == 0) {
                        parent = m.getParentMember();
                        level = m.getLevel();
                        continue;
                    }
                    if (parent != null && !parent.equals(m.getParentMember())) {
                        parent = null;
                    }
                    if (level == null || level.equals(m.getLevel())) continue;
                    level = null;
                    continue;
                }
                parent = null;
                level = null;
                bloats[i] = constraintLength / (double)columns[i].getCardinality();
                break;
            }
            boolean done = false;
            if (parent != null && (parent.isAll() || potentialParents.contains(parent))) {
                scr = this.star.getSchema().getSchemaReader();
                int childCount = scr.getChildrenCountFromCache(parent);
                if (childCount == -1) {
                    if (!parent.isAll()) {
                        bloats[i] = 0.0;
                        done = true;
                    }
                } else {
                    bloats[i] = constraintLength / (double)childCount;
                    done = true;
                }
            }
            if (!done && level != null && (memberCount = (scr = this.star.getSchema().getSchemaReader()).getLevelCardinality(level, true, false)) > 0) {
                bloats[i] = constraintLength / (double)memberCount;
                done = true;
            }
            if (done) continue;
            bloats[i] = constraintLength / (double)columns[i].getCardinality();
        }
        ConstraintComparator comparator = new ConstraintComparator(bloats);
        Integer[] indexes = new Integer[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, comparator);
        double abloat = 1.0;
        double aBloatLimit = 0.5;
        for (Integer j : indexes) {
            if ((abloat *= bloats[j]) <= 0.5) break;
            newPredicates[j.intValue()] = new LiteralStarPredicate(columns[j], true);
        }
        return newPredicates;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw);
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw) {
        ArrayList<Segment> segmentList = new ArrayList<Segment>();
        for (SoftReference<Segment> ref : this.segmentRefs) {
            Segment segment = ref.get();
            if (segment == null) continue;
            segmentList.add(segment);
        }
        Collections.sort(segmentList, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                return o1.id - o2.id;
            }
        });
        for (Segment segment : segmentList) {
            segment.print(pw);
        }
    }

    public void flush(CacheControl cacheControl, RolapCacheRegion cacheRegion) {
        boolean bitmapsIntersect = cacheRegion.getConstrainedColumnsBitKey().intersects(this.constrainedColumnsBitKey);
        ArrayList<SoftReference<Segment>> newSegmentRefs = new ArrayList<SoftReference<Segment>>();
        block0: for (SoftReference<Segment> segmentRef : this.segmentRefs) {
            StarColumnPredicate bestColumnPredicate;
            Axis axis;
            Comparable<?>[] axisKeys;
            RolapStar.Column column;
            Segment segment = segmentRef.get();
            if (segment == null) {
                cacheControl.trace("discarding garbage collected segment");
                continue;
            }
            if (!bitmapsIntersect) {
                cacheControl.trace("discard segment - it has no columns in common: " + segment);
                continue;
            }
            BitSet[] axisKeepBitSets = new BitSet[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                Axis axis2 = segment.axes[i];
                int keyCount = axis2.getKeys().length;
                BitSet axisKeepBitSet = axisKeepBitSets[i] = new BitSet(keyCount);
                StarColumnPredicate predicate = axis2.predicate;
                assert (predicate != null);
                column = this.columns[i];
                if (!cacheRegion.getConstrainedColumnsBitKey().get(column.getBitPosition())) {
                    axisKeepBitSet.set(0, keyCount);
                    continue;
                }
                StarColumnPredicate flushPredicate = cacheRegion.getPredicate(column.getBitPosition());
                if (flushPredicate == null) {
                    axisKeepBitSet.set(0, keyCount);
                    continue;
                }
                if (!flushPredicate.mightIntersect(predicate)) {
                    newSegmentRefs.add(segmentRef);
                    continue block0;
                }
                axisKeys = axis2.getKeys();
                for (int k = 0; k < axisKeys.length; ++k) {
                    Comparable<?> key = axisKeys[k];
                    if (flushPredicate.evaluate(key)) continue;
                    axisKeepBitSet.set(k);
                }
            }
            for (StarPredicate predicate : cacheRegion.getPredicates()) {
                ValuePruner pruner = new ValuePruner(predicate, segment.axes, segment.getData());
                pruner.go(axisKeepBitSets);
            }
            float bestRetention = 0.0f;
            int bestColumn = -1;
            for (int i = 0; i < this.columns.length; ++i) {
                RolapStar.Column column2 = this.columns[i];
                int bitPosition = column2.getBitPosition();
                if (!cacheRegion.getConstrainedColumnsBitKey().get(bitPosition)) continue;
                BitSet axisBitSet = axisKeepBitSets[i];
                axis = segment.axes[i];
                axisKeys = axis.getKeys();
                if (axisBitSet.cardinality() == 0) continue block0;
                float retention = (float)axisBitSet.cardinality() / (float)axisKeys.length;
                if (bestColumn != -1 && !(retention > bestRetention)) continue;
                bestRetention = retention;
                bestColumn = i;
            }
            ArrayList<StarColumnPredicate> regionPredicates = new ArrayList<StarColumnPredicate>();
            int cellCount = 1;
            for (int i = 0; i < this.columns.length; ++i) {
                int keysMatched;
                column = this.columns[i];
                axis = segment.axes[i];
                int pos = column.getBitPosition();
                StarColumnPredicate flushPredicate = cacheRegion.getPredicate(pos);
                if (flushPredicate == null) {
                    flushPredicate = LiteralStarPredicate.TRUE;
                    keysMatched = axis.getKeys().length;
                } else {
                    keysMatched = axis.getMatchCount(flushPredicate);
                }
                cellCount *= keysMatched;
                regionPredicates.add(flushPredicate);
            }
            for (StarPredicate p : cacheRegion.getPredicates()) {
                cellCount = (int)((double)cellCount * 0.5);
            }
            Segment.Region region = new Segment.Region(regionPredicates, new ArrayList<StarPredicate>(cacheRegion.getPredicates()), cellCount);
            int remainingCellCount = segment.getCellCount();
            if (remainingCellCount - cellCount <= 0) continue;
            ArrayList<Segment.Region> excludedRegions = new ArrayList<Segment.Region>(segment.getExcludedRegions());
            if (!excludedRegions.contains(region)) {
                excludedRegions.add(region);
            }
            if (bestColumn >= 0) {
                RolapStar.Column column3 = this.columns[bestColumn];
                int bitPosition = column3.getBitPosition();
                StarColumnPredicate flushPredicate = cacheRegion.getPredicate(bitPosition);
                Axis axis3 = segment.axes[bestColumn];
                bestColumnPredicate = axis3.predicate;
                if (flushPredicate != null) {
                    bestColumnPredicate = bestColumnPredicate.minus(flushPredicate);
                }
            } else {
                bestColumnPredicate = null;
            }
            Segment newSegment = segment.createSubSegment(axisKeepBitSets, bestColumn, bestColumnPredicate, excludedRegions);
            newSegmentRefs.add(new SoftReference<Segment>(newSegment));
        }
        this.segmentRefs.clear();
        this.segmentRefs.addAll(newSegmentRefs);
    }

    public synchronized Object getCellValue(RolapStar.Measure measure, Object[] keys, RolapAggregationManager.PinSet pinSet) {
        Iterator<SoftReference<Segment>> it = this.segmentRefs.iterator();
        while (it.hasNext()) {
            SoftReference<Segment> ref = it.next();
            Segment segment = ref.get();
            if (segment == null) {
                it.remove();
                continue;
            }
            if (segment.measure != measure) continue;
            if (segment.isReady()) {
                Object o = segment.getCellValue(keys);
                if (o == null) continue;
                if (pinSet != null) {
                    ((AggregationManager.PinSetImpl)pinSet).add(segment);
                }
                return o;
            }
            if (pinSet == null || ((AggregationManager.PinSetImpl)pinSet).contains(segment) || !segment.wouldContain(keys)) continue;
            ((AggregationManager.PinSetImpl)pinSet).add(segment);
        }
        return null;
    }

    public RolapStar.Column[] getColumns() {
        return this.columns;
    }

    public RolapStar getStar() {
        return this.star;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstraintComparator
    implements Comparator<Integer> {
        private final double[] bloats;

        ConstraintComparator(double[] bloats) {
            this.bloats = bloats;
        }

        @Override
        public int compare(Integer o0, Integer o1) {
            double bloat1;
            double bloat0 = this.bloats[o0];
            return bloat0 == (bloat1 = this.bloats[o1]) ? 0 : (bloat0 < bloat1 ? 1 : -1);
        }
    }

    private class ValuePruner {
        private final StarPredicate flushPredicate;
        private final int arity;
        private final Axis[] axes;
        private final BitSet[] keepBitSets;
        private final int[] axisInverseOrdinals;
        private final Object[] values;
        private final List<Object> valueList;
        private final int[] ordinals;
        private final SegmentDataset data;
        private final CellKey cellKey;

        ValuePruner(StarPredicate flushPredicate, Axis[] segmentAxes, SegmentDataset data) {
            this.flushPredicate = flushPredicate;
            this.arity = flushPredicate.getConstrainedColumnList().size();
            this.axes = new Axis[this.arity];
            this.keepBitSets = new BitSet[this.arity];
            this.axisInverseOrdinals = new int[segmentAxes.length];
            Arrays.fill(this.axisInverseOrdinals, -1);
            this.values = new Object[this.arity];
            this.valueList = Arrays.asList(this.values);
            this.ordinals = new int[this.arity];
            assert (data != null);
            this.data = data;
            this.cellKey = CellKey.Generator.newCellKey(segmentAxes.length);
            for (int i = 0; i < this.arity; ++i) {
                RolapStar.Column column = flushPredicate.getConstrainedColumnList().get(i);
                int axisOrdinal = this.findAxis(segmentAxes, column.getBitPosition());
                if (axisOrdinal < 0) {
                    this.axes[i] = null;
                    this.values[i] = StarPredicate.WILDCARD;
                    this.keepBitSets[i] = new BitSet(1);
                    continue;
                }
                this.axes[i] = segmentAxes[axisOrdinal];
                this.axisInverseOrdinals[axisOrdinal] = i;
                int keyCount = this.axes[i].getKeys().length;
                this.keepBitSets[i] = new BitSet(keyCount);
            }
        }

        private int findAxis(Axis[] axes, int bitPosition) {
            for (int i = 0; i < axes.length; ++i) {
                Axis axis = axes[i];
                if (axis.getPredicate().getConstrainedColumn().getBitPosition() != bitPosition) continue;
                return i;
            }
            return -1;
        }

        void go(BitSet[] axisKeepBitSets) {
            this.evaluatePredicate(0);
            for (int i = 0; i < axisKeepBitSets.length; ++i) {
                if (this.axisInverseOrdinals[i] < 0) continue;
                BitSet axisKeepBitSet = axisKeepBitSets[this.axisInverseOrdinals[i]];
                BitSet keepBitSet = this.keepBitSets[i];
                axisKeepBitSet.and(keepBitSet);
            }
        }

        private void evaluatePredicate(int axisOrdinal) {
            block5: {
                block4: {
                    if (axisOrdinal != this.arity) break block4;
                    if (this.flushPredicate.evaluate(this.valueList) || this.data.get(this.cellKey) == null) break block5;
                    for (int k = 0; k < this.arity; ++k) {
                        this.keepBitSets[k].set(this.ordinals[k]);
                    }
                    break block5;
                }
                Axis axis = this.axes[axisOrdinal];
                if (axis == null) {
                    this.evaluatePredicate(axisOrdinal + 1);
                } else {
                    for (int keyOrdinal = 0; keyOrdinal < axis.keys.length; ++keyOrdinal) {
                        Comparable key = axis.keys[keyOrdinal];
                        this.values[axisOrdinal] = key;
                        this.ordinals[axisOrdinal] = keyOrdinal;
                        this.cellKey.setAxis(this.axisInverseOrdinals[axisOrdinal], keyOrdinal);
                        this.evaluatePredicate(axisOrdinal + 1);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Axis {
        private final StarColumnPredicate predicate;
        private final Map<Comparable<?>, Integer> mapKeyToOffset = new HashMap();
        private Comparable<?>[] keys;
        private boolean hasNull;

        Axis(StarColumnPredicate predicate) {
            this.predicate = predicate;
            assert (predicate != null);
        }

        Axis(StarColumnPredicate predicate, Comparable<?>[] keys) {
            this(predicate);
            this.keys = keys;
            for (int i = 0; i < keys.length; ++i) {
                Comparable<?> key = keys[i];
                this.mapKeyToOffset.put(key, i);
                assert (i == 0 || keys[i - 1].compareTo(keys[i]) < 0);
            }
        }

        StarColumnPredicate getPredicate() {
            return this.predicate;
        }

        Comparable<?>[] getKeys() {
            return this.keys;
        }

        int loadKeys(SortedSet<Comparable<?>> valueSet, boolean hasNull) {
            this.hasNull = hasNull;
            int size = valueSet.size();
            this.keys = valueSet.toArray(new Comparable[size]);
            for (int i = 0; i < size; ++i) {
                this.mapKeyToOffset.put(this.keys[i], i);
            }
            if (hasNull) {
                this.mapKeyToOffset.put(RolapUtil.sqlNullValue, size);
                ++size;
            }
            return size;
        }

        static final Comparable wrap(Object o) {
            if (Util.PreJdk15 && o instanceof Boolean) {
                return Integer.valueOf((Boolean)o != false ? 1 : 0);
            }
            return (Comparable)o;
        }

        final int getOffset(Object o) {
            return this.getOffset(Axis.wrap(o));
        }

        final int getOffset(Comparable key) {
            Integer ordinal = this.mapKeyToOffset.get(key);
            if (ordinal == null) {
                return -1;
            }
            return ordinal;
        }

        boolean contains(Object key) {
            return this.predicate.evaluate(key);
        }

        public int getMatchCount(StarColumnPredicate predicate) {
            int matchCount = 0;
            for (Comparable<?> key : this.keys) {
                if (!predicate.evaluate(key)) continue;
                ++matchCount;
            }
            return matchCount;
        }
    }
}

