/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public final class ClassParser {
    private DataInputStream file;
    private boolean fileOwned;
    private String file_name;
    private String zip_file;
    private int class_name_index;
    private int superclass_name_index;
    private int major;
    private int minor;
    private int access_flags;
    private int[] interfaces;
    private ConstantPool constant_pool;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private boolean is_zip;
    private static final int BUFSIZE = 8192;

    public ClassParser(InputStream file, String file_name) {
        this.file_name = file_name;
        this.fileOwned = false;
        String clazz = file.getClass().getName();
        this.is_zip = clazz.startsWith("java.util.zip.") || clazz.startsWith("java.util.jar.");
        this.file = file instanceof DataInputStream ? (DataInputStream)file : new DataInputStream(new BufferedInputStream(file, 8192));
    }

    public ClassParser(String file_name) throws IOException {
        this.is_zip = false;
        this.file_name = file_name;
        this.fileOwned = true;
    }

    public ClassParser(String zip_file, String file_name) {
        this.is_zip = true;
        this.fileOwned = true;
        this.zip_file = zip_file;
        this.file_name = file_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClass parse() throws IOException, ClassFormatException {
        block8: {
            ZipFile zip = null;
            try {
                if (this.fileOwned) {
                    if (this.is_zip) {
                        zip = new ZipFile(this.zip_file);
                        ZipEntry entry = zip.getEntry(this.file_name);
                        this.file = new DataInputStream(new BufferedInputStream(zip.getInputStream(entry), 8192));
                    } else {
                        this.file = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file_name), 8192));
                    }
                }
                this.readID();
                this.readVersion();
                this.readConstantPool();
                this.readClassInfo();
                this.readInterfaces();
                this.readFields();
                this.readMethods();
                this.readAttributes();
                Object var4_3 = null;
                if (!this.fileOwned) break block8;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.fileOwned) {
                    this.file.close();
                    if (zip != null) {
                        zip.close();
                    }
                }
                throw throwable;
            }
            this.file.close();
            if (zip != null) {
                zip.close();
            }
        }
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, this.access_flags, this.constant_pool, this.interfaces, this.fields, this.methods, this.attributes, this.is_zip ? (byte)3 : 2);
    }

    private final void readAttributes() throws IOException, ClassFormatException {
        int attributes_count = this.file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(this.file, this.constant_pool);
        }
    }

    private final void readClassInfo() throws IOException, ClassFormatException {
        this.access_flags = this.file.readUnsignedShort();
        if ((this.access_flags & 0x200) != 0) {
            this.access_flags |= 0x400;
        }
        if ((this.access_flags & 0x400) != 0 && (this.access_flags & 0x10) != 0) {
            throw new ClassFormatException("Class can't be both final and abstract");
        }
        this.class_name_index = this.file.readUnsignedShort();
        this.superclass_name_index = this.file.readUnsignedShort();
    }

    private final void readConstantPool() throws IOException, ClassFormatException {
        this.constant_pool = new ConstantPool(this.file);
    }

    private final void readFields() throws IOException, ClassFormatException {
        int fields_count = this.file.readUnsignedShort();
        this.fields = new Field[fields_count];
        for (int i = 0; i < fields_count; ++i) {
            this.fields[i] = new Field(this.file, this.constant_pool);
        }
    }

    private final void readID() throws IOException, ClassFormatException {
        int magic = -889275714;
        if (this.file.readInt() != magic) {
            throw new ClassFormatException(this.file_name + " is not a Java .class file");
        }
    }

    private final void readInterfaces() throws IOException, ClassFormatException {
        int interfaces_count = this.file.readUnsignedShort();
        this.interfaces = new int[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            this.interfaces[i] = this.file.readUnsignedShort();
        }
    }

    private final void readMethods() throws IOException, ClassFormatException {
        int methods_count = this.file.readUnsignedShort();
        this.methods = new Method[methods_count];
        for (int i = 0; i < methods_count; ++i) {
            this.methods[i] = new Method(this.file, this.constant_pool);
        }
    }

    private final void readVersion() throws IOException, ClassFormatException {
        this.minor = this.file.readUnsignedShort();
        this.major = this.file.readUnsignedShort();
    }
}

