/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.ireport.designer.crosstab.wizard;

import com.jaspersoft.ireport.designer.IReportManager;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

public final class CrosstabVisualPanel1 extends JPanel {

    /** Creates new form CrosstabVisualPanel1 */
    public CrosstabVisualPanel1() {
        initComponents();
        jComboBoxDataset.setRenderer( new DatasetListCellRenderer() );
        updateDatasets();
    }

    @Override
    public String getName() {
        return "Dataset";
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelDataset = new javax.swing.JLabel();
        jComboBoxDataset = new javax.swing.JComboBox();

        org.openide.awt.Mnemonics.setLocalizedText(jLabelDataset, "Dataset");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabelDataset, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)
                    .add(jComboBoxDataset, 0, 380, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabelDataset)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jComboBoxDataset, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(247, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxDataset;
    private javax.swing.JLabel jLabelDataset;
    // End of variables declaration//GEN-END:variables

    public void updateDatasets() {
        
        DefaultComboBoxModel model = (DefaultComboBoxModel)jComboBoxDataset.getModel();
        model.removeAllElements();
        
        JasperDesign design = IReportManager.getInstance().getActiveReport();
        if (design == null) return;
        
        List datasets = design.getDatasetsList();
        model.addElement( design.getMainDataset());
        for (int i=0; i<datasets.size(); ++i)
        {
            model.addElement( datasets.get(i));
        }
        
        jComboBoxDataset.setSelectedIndex(0);
        jComboBoxDataset.updateUI();
    }
    
    
    /**
     * 
     * @return the selected dataset
     */
    public JRDesignDataset getDataset()
    {
        return (JRDesignDataset)jComboBoxDataset.getSelectedItem();
    }
}

