/*
 * GraphicElementPropertiesFactory.java
 * 
 * Created on 5-nov-2007, 19.43.44
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.sheet.properties.BooleanProperty;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
    
    
/**
 *  Class to manage the JRDesignPie3DPlot.PROPERTY_CIRCULAR property
 */
public final class Pie3DCircularProperty extends BooleanProperty {

    private final JRDesignPie3DPlot plot;

    @SuppressWarnings("unchecked")
    public Pie3DCircularProperty(JRDesignPie3DPlot plot)
    {
        super(plot);
        this.plot = plot;
    }
    @Override
    public String getName()
    {
        return JRDesignPie3DPlot.PROPERTY_CIRCULAR;
    }

    @Override
    public String getDisplayName()
    {
        return "Circular";
    }

    @Override
    public String getShortDescription()
    {
        return "Circular.";
    }

    @Override
    public Boolean getBoolean()
    {
        return plot.isCircular();
    }

    @Override
    public Boolean getOwnBoolean()
    {
        return plot.isCircular();
    }

    @Override
    public Boolean getDefaultBoolean()
    {
        return Boolean.FALSE;
    }

    @Override
    public void setBoolean(Boolean isShow)
    {
    	plot.setCircular(isShow);
    }

}
