/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystem
implements Serializable {
    private static final long serialVersionUID = -8931487924240189180L;
    public static final String PROP_VALID = "valid";
    @Deprecated
    public static final String PROP_HIDDEN = "hidden";
    @Deprecated
    public static final String PROP_SYSTEM_NAME = "systemName";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ROOT = "root";
    public static final String PROP_READ_ONLY = "readOnly";
    static final String PROP_CAPABILITIES = "capabilities";
    private static Object internLock = new Object();
    private static transient ThreadLocal<EventControl> thrLocal = new ThreadLocal();
    private static final Status STATUS_NONE = new Status(){

        @Override
        public String annotateName(String string, Set<? extends FileObject> set) {
            return string;
        }

        @Override
        public Image annotateIcon(Image image, int n, Set<? extends FileObject> set) {
            return image;
        }
    };
    private transient boolean valid = false;
    transient boolean assigned = false;
    private transient Repository repository = null;
    private transient FCLSupport fclSupport;
    @Deprecated
    private FileSystemCapability capability;
    private transient PropertyChangeListener capabilityListener;
    private boolean hidden = false;
    private String systemName = "".intern();
    private transient ListenerList<FileStatusListener> fileStatusList;
    private transient ListenerList<VetoableChangeListener> vetoableChangeList;
    private transient PropertyChangeSupport changeSupport;

    public void refresh(boolean bl) {
    }

    public final boolean isValid() {
        return this.valid;
    }

    final void setValid(boolean bl) {
        if (bl != this.valid) {
            this.valid = bl;
            this.firePropertyChange(PROP_VALID, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE, Boolean.FALSE);
        }
    }

    @Deprecated
    public final void setHidden(boolean bl) {
        if (bl != this.hidden) {
            this.hidden = bl;
            this.firePropertyChange(PROP_HIDDEN, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Deprecated
    public final boolean isHidden() {
        return this.hidden;
    }

    @Deprecated
    protected boolean isPersistent() {
        return false;
    }

    public abstract String getDisplayName();

    @Deprecated
    public final String getSystemName() {
        return this.systemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected final void setSystemName(String string) throws PropertyVetoException {
        Class<Repository> clazz = Repository.class;
        synchronized (Repository.class) {
            if (this.systemName.equals(string)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.fireVetoableChange(PROP_SYSTEM_NAME, this.systemName, string);
            String string2 = this.systemName;
            this.systemName = string.intern();
            this.firePropertyChange(PROP_SYSTEM_NAME, string2, this.systemName);
            this.firePropertyChange(PROP_DISPLAY_NAME, null, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final boolean isDefault() {
        return this == ExternalUtil.getRepository().getDefaultFileSystem();
    }

    public abstract boolean isReadOnly();

    public abstract FileObject getRoot();

    @Deprecated
    public FileObject find(String string, String string2, String string3) {
        assert (FileUtil.assertDeprecatedMethod());
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.equals("")) {
            String string4 = string.replace('.', '/');
            stringBuffer.append(string4);
            stringBuffer.append('/');
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        return this.findResource(stringBuffer.toString());
    }

    public abstract FileObject findResource(String var1);

    public abstract SystemAction[] getActions();

    public SystemAction[] getActions(Set<FileObject> set) {
        return this.getActions();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.capability != null) {
            this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
        }
    }

    public String toString() {
        return this.getSystemName() + "[" + super.toString() + "]";
    }

    @Deprecated
    public void prepareEnvironment(Environment environment) throws EnvironmentNotSupportedException {
        throw new EnvironmentNotSupportedException(this);
    }

    public Status getStatus() {
        return STATUS_NONE;
    }

    @Deprecated
    public final FileSystemCapability getCapability() {
        if (this.capability == null) {
            this.capability = new FileSystemCapability.Bean();
            this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
        }
        return this.capability;
    }

    @Deprecated
    protected final void setCapability(FileSystemCapability fileSystemCapability) {
        if (this.capability != null) {
            this.capability.removePropertyChangeListener(this.getCapabilityChangeListener());
        }
        this.capability = fileSystemCapability;
        if (this.capability != null) {
            this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
        }
    }

    public final void runAtomicAction(AtomicAction atomicAction) throws IOException {
        this.getEventControl().runAtomicAction(atomicAction);
    }

    void beginAtomicAction(AtomicAction atomicAction) {
        this.getEventControl().beginAtomicAction(atomicAction);
    }

    void beginAtomicAction() {
        this.beginAtomicAction(null);
    }

    void finishAtomicAction() {
        this.getEventControl().finishAtomicAction();
    }

    void dispatchEvent(EventDispatcher eventDispatcher) {
        this.getEventControl().dispatchEvent(eventDispatcher);
    }

    private synchronized PropertyChangeListener getCapabilityChangeListener() {
        if (this.capabilityListener == null) {
            this.capabilityListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FileSystem.this.firePropertyChange(FileSystem.PROP_CAPABILITIES, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            };
        }
        return this.capabilityListener;
    }

    private final EventControl getEventControl() {
        EventControl eventControl = thrLocal.get();
        if (eventControl == null) {
            eventControl = new EventControl();
            thrLocal.set(eventControl);
        }
        return eventControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileStatusListener(FileStatusListener fileStatusListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.getStatus() == STATUS_NONE) {
                return;
            }
            if (this.fileStatusList == null) {
                this.fileStatusList = new ListenerList();
            }
            this.fileStatusList.add(fileStatusListener);
        }
    }

    public final void removeFileStatusListener(FileStatusListener fileStatusListener) {
        if (this.fileStatusList == null) {
            return;
        }
        this.fileStatusList.remove(fileStatusListener);
    }

    protected final void fireFileStatusChanged(FileStatusEvent fileStatusEvent) {
        if (this.fileStatusList == null) {
            return;
        }
        List<FileStatusListener> list = this.fileStatusList.getAllListeners();
        this.dispatchEvent(new FileStatusDispatcher(list, fileStatusEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.vetoableChangeList == null) {
                this.vetoableChangeList = new ListenerList();
            }
            this.vetoableChangeList.add(vetoableChangeListener);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeList == null) {
            return;
        }
        this.vetoableChangeList.remove(vetoableChangeListener);
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeList == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        for (VetoableChangeListener vetoableChangeListener : this.vetoableChangeList.getAllListeners()) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            }
            vetoableChangeListener.vetoableChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2, null);
    }

    final void firePropertyChange(String string, Object object, Object object2, Object object3) {
        if (this.changeSupport == null) {
            return;
        }
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        propertyChangeEvent.setPropagationId(object3);
        this.changeSupport.firePropertyChange(propertyChangeEvent);
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    static String getString(String string) {
        return NbBundle.getBundle((String)"org.openide.filesystems.Bundle", (Locale)Locale.getDefault(), (ClassLoader)FileSystem.class.getClassLoader()).getString(string);
    }

    static String getString(String string, Object object) {
        return MessageFormat.format(FileSystem.getString(string), object);
    }

    static String getString(String string, Object object, Object object2) {
        return MessageFormat.format(FileSystem.getString(string), object, object2);
    }

    static String getString(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(FileSystem.getString(string), object, object2, object3);
    }

    final Repository getRepository() {
        return this.repository;
    }

    void setRepository(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class<FCLSupport> clazz = FCLSupport.class;
        synchronized (FCLSupport.class) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fclSupport;
        }
    }

    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().addFileChangeListener(fileChangeListener);
    }

    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().removeFileChangeListener(fileChangeListener);
    }

    public static interface AtomicAction {
        public void run() throws IOException;
    }

    @Deprecated
    public static abstract class Environment {
        public Environment() {
            assert (FileUtil.assertDeprecatedMethod());
        }

        @Deprecated
        public void addClassPath(String string) {
        }
    }

    static abstract class EventDispatcher
    implements Runnable {
        EventDispatcher() {
        }

        public final void run() {
            this.dispatch(false);
        }

        protected abstract void dispatch(boolean var1);

        protected abstract void setAtomicActionLink(EventControl.AtomicActionLink var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileStatusDispatcher
    extends EventDispatcher {
        private List<FileStatusListener> listeners;
        private FileStatusEvent fStatusEvent;

        public FileStatusDispatcher(List<FileStatusListener> list, FileStatusEvent fileStatusEvent) {
            this.listeners = list;
            this.fStatusEvent = fileStatusEvent;
        }

        @Override
        protected void dispatch(boolean bl) {
            if (bl) {
                return;
            }
            for (FileStatusListener fileStatusListener : this.listeners) {
                fileStatusListener.annotationChanged(this.fStatusEvent);
            }
        }

        @Override
        protected void setAtomicActionLink(EventControl.AtomicActionLink atomicActionLink) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HtmlStatus
    extends Status {
        public String annotateNameHtml(String var1, Set<? extends FileObject> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Status {
        public String annotateName(String var1, Set<? extends FileObject> var2);

        public Image annotateIcon(Image var1, int var2, Set<? extends FileObject> var3);
    }
}

