/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.SlideBarActionEvent;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlideOperationFactory;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class TabbedHandler
implements ChangeListener,
ActionListener {
    private final ModeView modeView;
    private final Tabbed tabbed;
    private final int kind;
    private boolean ignoreChange = false;
    private static ActivationManager activationManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabbedHandler(ModeView modeView, int n, Tabbed tabbed) {
        this.modeView = modeView;
        this.kind = n;
        Class<TabbedHandler> clazz = TabbedHandler.class;
        synchronized (TabbedHandler.class) {
            if (activationManager == null) {
                activationManager = new ActivationManager();
                Toolkit.getDefaultToolkit().addAWTEventListener(activationManager, 16L);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.tabbed = tabbed;
            this.tabbed.addChangeListener(this);
            this.tabbed.addActionListener(this);
            ((Container)this.tabbed.getComponent()).setFocusCycleRoot(true);
            return;
        }
    }

    public void requestAttention(TopComponent topComponent) {
        this.tabbed.requestAttention(topComponent);
    }

    public void cancelRequestAttention(TopComponent topComponent) {
        this.tabbed.cancelRequestAttention(topComponent);
    }

    public Component getComponent() {
        return this.tabbed.getComponent();
    }

    public void addTopComponent(TopComponent topComponent, int n) {
        this.addTCIntoTab(topComponent, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        this.ignoreChange = true;
        try {
            this.tabbed.setTopComponents(topComponentArray, topComponent);
        }
        finally {
            this.ignoreChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTCIntoTab(TopComponent topComponent, int n) {
        if (TabbedHandler.containsTC(this.tabbed, topComponent)) {
            return;
        }
        Image image = topComponent.getIcon();
        try {
            this.ignoreChange = true;
            String string = WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent);
            if (string == null) {
                string = "";
            }
            this.tabbed.addTopComponent(string, image == null ? null : new ImageIcon(image), topComponent, topComponent.getToolTipText());
        }
        finally {
            this.ignoreChange = false;
        }
    }

    private static boolean containsTC(Tabbed tabbed, TopComponent topComponent) {
        return tabbed.indexOf((Component)topComponent) != -1;
    }

    public void removeTopComponent(TopComponent topComponent) {
        this.removeTCFromTab(topComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTCFromTab(TopComponent topComponent) {
        if (this.tabbed.indexOf((Component)topComponent) != -1) {
            try {
                this.ignoreChange = true;
                this.tabbed.removeComponent((Component)topComponent);
            }
            finally {
                this.ignoreChange = false;
            }
            topComponent.getAccessibleContext().setAccessibleParent(null);
        }
    }

    public void topComponentIconChanged(TopComponent topComponent) {
        int n = this.tabbed.indexOf((Component)topComponent);
        if (n < 0) {
            return;
        }
        this.tabbed.setIconAt(n, new ImageIcon(topComponent.getIcon()));
    }

    public void topComponentNameChanged(TopComponent topComponent, int n) {
        int n2 = this.tabbed.indexOf((Component)topComponent);
        if (n2 < 0) {
            return;
        }
        String string = WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent);
        if (string == null) {
            string = "";
        }
        this.tabbed.setTitleAt(n2, string);
    }

    public void topComponentToolTipChanged(TopComponent topComponent) {
        int n = this.tabbed.indexOf((Component)topComponent);
        if (n < 0) {
            return;
        }
        this.tabbed.setToolTipTextAt(n, topComponent.getToolTipText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTopComponent(TopComponent topComponent) {
        if (topComponent == this.getSelectedTopComponent()) {
            return;
        }
        if (topComponent == null && !this.isNullSelectionAllowed()) {
            return;
        }
        if (this.tabbed.indexOf((Component)topComponent) >= 0 || this.isNullSelectionAllowed() && topComponent == null) {
            try {
                this.ignoreChange = true;
                this.tabbed.setSelectedComponent((Component)topComponent);
            }
            finally {
                this.ignoreChange = false;
            }
        }
    }

    private boolean isNullSelectionAllowed() {
        return this.kind == 2;
    }

    public TopComponent getSelectedTopComponent() {
        return this.tabbed.getSelectedTopComponent();
    }

    public TopComponent[] getTopComponents() {
        return this.tabbed.getTopComponents();
    }

    public void setActive(boolean bl) {
        this.tabbed.setActive(bl);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.ignoreChange || changeEvent.getSource() != this.tabbed) {
            return;
        }
        TopComponent topComponent = this.tabbed.getSelectedTopComponent();
        this.modeView.getController().userSelectedTab(this.modeView, topComponent);
    }

    public Shape getIndicationForLocation(Point point, TopComponent topComponent, Point point2, boolean bl) {
        return this.tabbed.getIndicationForLocation(point, topComponent, point2, bl);
    }

    public Object getConstraintForLocation(Point point, boolean bl) {
        return this.tabbed.getConstraintForLocation(point, bl);
    }

    public Rectangle getTabBounds(int n) {
        return this.tabbed.getTabBounds(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent instanceof TabActionEvent) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            String string = tabActionEvent.getActionCommand();
            if ("select".equals(string)) {
                return;
            }
            tabActionEvent.consume();
            if ("close" == string) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
                if (topComponent == null) {
                    throw new IllegalStateException("Component to be closed is null at index " + tabActionEvent.getTabIndex());
                }
                this.modeView.getController().userClosedTopComponent(this.modeView, topComponent);
            } else if ("popup" == string) {
                TabbedHandler.handlePopupMenuShowing(tabActionEvent.getMouseEvent(), tabActionEvent.getTabIndex());
            } else if ("maximize" == string) {
                TabbedHandler.handleMaximization(tabActionEvent);
            } else if ("closeAll" == string) {
                ActionUtils.closeAllDocuments();
            } else if ("closeAllButThis" == string) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
                ActionUtils.closeAllExcept(topComponent);
            } else if ("enableAutoHide".equals(string)) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
                Component component = this.tabbed.getComponent();
                String string2 = WindowManagerImpl.getInstance().guessSlideSide(topComponent);
                SlideOperation slideOperation = SlideOperationFactory.createSlideIntoEdge(component, string2, true);
                slideOperation.setStartBounds(new Rectangle(component.getLocationOnScreen(), component.getSize()));
                slideOperation.prepareEffect();
                this.modeView.getController().userEnabledAutoHide(this.modeView, topComponent);
                this.modeView.getController().userTriggeredSlideIntoEdge(this.modeView, slideOperation);
            }
        } else if (actionEvent instanceof SlideBarActionEvent) {
            SlideBarActionEvent slideBarActionEvent = (SlideBarActionEvent)actionEvent;
            String string = slideBarActionEvent.getActionCommand();
            if ("popup".equals(string)) {
                TabbedHandler.handlePopupMenuShowing(slideBarActionEvent.getMouseEvent(), slideBarActionEvent.getTabIndex());
            } else if ("slideIn".equals(string)) {
                this.modeView.getController().userTriggeredSlideIn(this.modeView, slideBarActionEvent.getSlideOperation());
            } else if ("slideResize".equals(string)) {
                this.modeView.getController().userResizedSlidingWindow(this.modeView, slideBarActionEvent.getSlideOperation());
            } else if ("slideOut".equals(string)) {
                ProxySlideOperation proxySlideOperation = new ProxySlideOperation(slideBarActionEvent.getSlideOperation(), this.ignoreChange);
                this.modeView.getController().userTriggeredSlideOut(this.modeView, proxySlideOperation);
            } else if ("disableAutoHide".equals(string)) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(slideBarActionEvent.getTabIndex());
                this.modeView.getController().userDisabledAutoHide(this.modeView, topComponent);
            } else if ("slideMaximize" == string) {
                TopComponent topComponent = this.tabbed.getTopComponentAt(slideBarActionEvent.getTabIndex());
                MaximizeWindowAction maximizeWindowAction = new MaximizeWindowAction(topComponent);
                maximizeWindowAction.actionPerformed(actionEvent);
            }
        }
    }

    public static void handlePopupMenuShowing(MouseEvent mouseEvent, int n) {
        Component component;
        for (component = (Component)mouseEvent.getSource(); component != null && !(component instanceof Tabbed.Accessor); component = component.getParent()) {
        }
        if (component == null) {
            return;
        }
        Tabbed tabbed = ((Tabbed.Accessor)((Object)component)).getTabbed();
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
        int n2 = n;
        if (n2 < 0) {
            return;
        }
        TopComponent topComponent = tabbed.getTopComponentAt(n2);
        if (topComponent == null) {
            return;
        }
        Action[] actionArray = tabbed.getPopupActions(topComponent.getActions(), n2);
        if (actionArray == null) {
            actionArray = topComponent.getActions();
        }
        TabbedHandler.showPopupMenu(Utilities.actionsToPopup((Action[])actionArray, (Lookup)topComponent.getLookup()), point, component);
    }

    private static void showPopupMenu(JPopupMenu jPopupMenu, Point point, Component component) {
        jPopupMenu.show(component, point.x, point.y);
    }

    public static void handleMaximization(TabActionEvent tabActionEvent) {
        Component component;
        for (component = (Component)tabActionEvent.getSource(); component != null && !(component instanceof Tabbed); component = component.getParent()) {
        }
        if (component == null) {
            return;
        }
        Tabbed tabbed = (Tabbed)((Object)component);
        TopComponent topComponent = tabbed.getTopComponentAt(tabActionEvent.getTabIndex());
        MaximizeWindowAction maximizeWindowAction = new MaximizeWindowAction(topComponent);
        maximizeWindowAction.actionPerformed((ActionEvent)tabActionEvent);
    }

    private static class ActivationManager
    implements AWTEventListener {
        private ActivationManager() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 501) {
                this.handleActivation((MouseEvent)aWTEvent);
            }
        }

        private void handleActivation(MouseEvent mouseEvent) {
            Object object;
            Component component;
            Object object2 = mouseEvent.getSource();
            if (!(object2 instanceof Component)) {
                return;
            }
            for (component = (Component)object2; component != null && !(component instanceof ModeComponent); component = component.getParent()) {
                if (component instanceof JComponent && Boolean.TRUE.equals(((JComponent)(object = (JComponent)component)).getClientProperty("dontActivate"))) {
                    return;
                }
                if (!(component instanceof TopComponent) || !Boolean.TRUE.equals((object = (TopComponent)component).getClientProperty((Object)"isSliding"))) continue;
                object.requestActive();
                return;
            }
            if (component instanceof ModeComponent && (object = (ModeComponent)((Object)component)).getKind() != 2) {
                ModeView modeView = object.getModeView();
                modeView.getController().userActivatedModeView(modeView);
            }
        }
    }

    private static class ProxySlideOperation
    implements SlideOperation {
        private SlideOperation original;
        private boolean disable;

        public ProxySlideOperation(SlideOperation slideOperation, boolean bl) {
            this.original = slideOperation;
            this.disable = bl;
        }

        public Component getComponent() {
            return this.original.getComponent();
        }

        public Rectangle getFinishBounds() {
            return this.original.getFinishBounds();
        }

        public String getSide() {
            return this.original.getSide();
        }

        public Rectangle getStartBounds() {
            return this.original.getStartBounds();
        }

        public int getType() {
            return this.original.getType();
        }

        public void prepareEffect() {
            this.original.prepareEffect();
        }

        public boolean requestsActivation() {
            if (this.disable) {
                return false;
            }
            return this.original.requestsActivation();
        }

        public void run(JLayeredPane jLayeredPane, Integer n) {
            this.original.run(jLayeredPane, n);
        }

        public void setFinishBounds(Rectangle rectangle) {
            this.original.setFinishBounds(rectangle);
        }

        public void setStartBounds(Rectangle rectangle) {
            this.original.setStartBounds(rectangle);
        }
    }
}

