/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.impl.ToolbarActionsProvider;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class NbEditorToolBar
extends JToolBar
implements SettingsChangeListener {
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.toolbar.sort");
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Lookup NO_ACTION_CONTEXT = Lookups.fixed((Object[])new Object[0]);
    private FileChangeListener moduleRegListener;
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Object object = mouseEvent.getSource();
            if (object instanceof AbstractButton && (abstractButton = (AbstractButton)mouseEvent.getSource()).isEnabled()) {
                abstractButton.setContentAreaFilled(true);
                abstractButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.setContentAreaFilled(false);
                abstractButton.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
        }
    };
    private Reference componentRef;
    private boolean presentersAdded;
    private boolean addListener = true;
    private static final String NOOP_ACTION_KEY = "noop-action-key";
    private static final Action NOOP_ACTION = new NoOpAction();

    public NbEditorToolBar(JTextComponent jTextComponent) {
        this.componentRef = new WeakReference<JTextComponent>(jTextComponent);
        this.setFloatable(false);
        this.addMouseListener(sharedMouseListener);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.settingsChange(null);
        this.installModulesInstallationListener();
        this.installNoOpActionMappings();
    }

    private void installNoOpActionMappings() {
        int n;
        InputMap inputMap = this.getInputMap(1);
        KeyStroke[] keyStrokeArray = this.findEditorKeys("cut-to-clipboard", KeyStroke.getKeyStroke(88, 2));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        keyStrokeArray = this.findEditorKeys("copy-to-clipboard", KeyStroke.getKeyStroke(67, 2));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        keyStrokeArray = this.findEditorKeys("delete-next", KeyStroke.getKeyStroke(127, 0));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        keyStrokeArray = this.findEditorKeys("paste-from-clipboard", KeyStroke.getKeyStroke(86, 2));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        this.getActionMap().put(NOOP_ACTION_KEY, NOOP_ACTION);
    }

    private void installModulesInstallationListener() {
        this.moduleRegListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (AllOptionsFolder.getDefault().isToolbarVisible()) {
                            NbEditorToolBar.this.checkPresentersRemoved();
                            NbEditorToolBar.this.checkPresentersAdded();
                        }
                    }
                };
                Utilities.runInEventDispatchThread((Runnable)runnable);
            }
        };
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
        if (fileObject != null) {
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.moduleRegListener, (Object)fileObject));
        }
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    public String getName() {
        return "editorToolbar";
    }

    public void setUI(ToolBarUI toolBarUI) {
        this.addListener = false;
        super.setUI(toolBarUI);
        this.addListener = true;
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.addListener) {
            super.addMouseListener(mouseListener);
        }
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.addListener) {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        final boolean bl = NbEditorToolBar.isToolBarVisible();
        final JTextComponent jTextComponent = this.getComponent();
        final boolean bl2 = settingsChangeEvent != null && "key-bindings".equals(settingsChangeEvent.getSettingName()) && jTextComponent != null && settingsChangeEvent.getKitClass() == Utilities.getKitClass((JTextComponent)jTextComponent);
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    NbEditorToolBar.this.checkPresentersAdded();
                    if (bl2) {
                        NbEditorToolBar.this.installNoOpActionMappings();
                        int n = NbEditorToolBar.this.getComponentCount();
                        String string = NbEditorUtilities.getMimeType(jTextComponent);
                        Map map = NbEditorToolBar.getKeyBindingMap(string);
                        Component[] componentArray = NbEditorToolBar.this.getComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            MultiKeyBinding multiKeyBinding;
                            int n2;
                            String string2;
                            JButton jButton;
                            Action action;
                            Component component = componentArray[i];
                            if (!(component instanceof JButton) || (action = (jButton = (JButton)component).getAction()) == null || (string2 = (String)action.getValue("Name")) == null) continue;
                            String string3 = jButton.getToolTipText();
                            if (string3 != null && (n2 = string3.indexOf("(")) > 0) {
                                string3 = string3.substring(0, n2 - 1);
                            }
                            if ((multiKeyBinding = (MultiKeyBinding)map.get(string2)) != null) {
                                jButton.setToolTipText(string3 + " (" + NbEditorToolBar.getMnemonic(multiKeyBinding) + ")");
                                continue;
                            }
                            jButton.setToolTipText(string3);
                        }
                    }
                } else {
                    NbEditorToolBar.this.checkPresentersRemoved();
                }
                NbEditorToolBar.this.setVisible(bl);
            }
        };
        Utilities.runInEventDispatchThread((Runnable)runnable);
    }

    private void checkPresentersAdded() {
        if (!this.presentersAdded) {
            this.presentersAdded = true;
            this.addPresenters();
        }
    }

    private void checkPresentersRemoved() {
        this.presentersAdded = false;
        this.removeAll();
    }

    private static boolean isToolBarVisible() {
        return AllOptionsFolder.getDefault().isToolbarVisible();
    }

    private static String getMnemonic(MultiKeyBinding multiKeyBinding) {
        StringBuffer stringBuffer = new StringBuffer();
        if (multiKeyBinding.keys != null) {
            for (int i = 0; i < multiKeyBinding.keys.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(NbEditorToolBar.getKeyMnemonic(multiKeyBinding.keys[i]));
            }
        } else {
            stringBuffer.append(NbEditorToolBar.getKeyMnemonic(multiKeyBinding.key));
        }
        return stringBuffer.toString();
    }

    private static String getKeyMnemonic(KeyStroke keyStroke) {
        int n;
        String string = org.openide.util.Utilities.keyToString((KeyStroke)keyStroke);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = keyStroke.getModifiers();
        if ((n2 & 2) != 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append("Alt+");
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append("Shift+");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("Meta+");
        }
        if ((n = string.indexOf(45)) != -1) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static Map getKeyBindingMap(String string) {
        HashMap<String, MultiKeyBinding> hashMap = new HashMap<String, MultiKeyBinding>();
        List list = NbEditorToolBar.getKeyBindingList(string);
        for (Object e : list) {
            if (!(e instanceof MultiKeyBinding)) continue;
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)e;
            hashMap.put(multiKeyBinding.actionName, multiKeyBinding);
        }
        return hashMap;
    }

    private static List getKeyBindingList(String string) {
        List list;
        Object object;
        ArrayList arrayList = new ArrayList();
        AllOptionsFolder allOptionsFolder = AllOptionsFolder.getDefault();
        if (allOptionsFolder != null && (object = allOptionsFolder.getKeyBindingList()) != null) {
            arrayList.addAll(object);
        }
        if (string != null && (object = (BaseOptions)((Object)MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(BaseOptions.class))) != null && (list = ((BaseOptions)((Object)object)).getKeyBindingList()) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.componentRef.get();
    }

    /*
     * WARNING - void declaration
     */
    private void addPresenters() {
        String string;
        JTextComponent jTextComponent = this.getComponent();
        String string2 = string = jTextComponent == null ? null : NbEditorUtilities.getMimeType(jTextComponent);
        if (string == null) {
            return;
        }
        Object object = null;
        Object object2 = null;
        ArrayList<JSeparator> arrayList = ToolbarActionsProvider.getToolbarItems(string);
        List list = ToolbarActionsProvider.getToolbarItems("text/base");
        if (list.size() > 0) {
            arrayList = new ArrayList<JSeparator>(arrayList);
            arrayList.add(new JSeparator());
            arrayList.addAll(list);
        }
        for (Object e : arrayList) {
            void object3;
            void var8_15;
            void var8_13;
            void var8_11;
            Object object4;
            Object object5;
            if (e instanceof JSeparator) {
                this.addSeparator();
                continue;
            }
            if (e instanceof String && (object5 = jTextComponent.getUI().getEditorKit(jTextComponent)) instanceof BaseKit) {
                object4 = ((BaseKit)object5).getActionByName((String)e);
                if (object4 == null) continue;
                Action action = object4;
            }
            if (var8_11 instanceof ContextAwareAction) {
                if (object2 == null) {
                    object5 = NbEditorToolBar.createActionContext(jTextComponent);
                    Object object6 = object2 = object5 == null ? NO_ACTION_CONTEXT : object5;
                }
                if (object2 != NO_ACTION_CONTEXT && ((object5 = ((ContextAwareAction)var8_11).createContextAwareInstance(object2)) instanceof Presenter.Toolbar || object5 instanceof Component)) {
                    Object object7 = object5;
                }
            }
            if (var8_13 instanceof Presenter.Toolbar && (object5 = ((Presenter.Toolbar)var8_13).getToolbarPresenter()) != null) {
                Object object8 = object5;
            }
            if (var8_15 instanceof Component) {
                this.add((Component)var8_15);
            } else {
                if (!(var8_15 instanceof Action)) continue;
                object5 = new WrapperAction(this.componentRef, (Action)var8_15);
                NbEditorToolBar.updateIcon((Action)object5);
                JButton jButton = this.add((Action)object5);
            }
            if (!(object3 instanceof AbstractButton)) continue;
            object5 = (AbstractButton)object3;
            this.processButton((AbstractButton)object5);
            if (object == null) {
                object4 = NbEditorToolBar.getKeyBindingList(string);
                object = object4 == null ? Collections.emptyList() : object4;
            }
            NbEditorToolBar.updateTooltip((AbstractButton)object5, object);
        }
    }

    private static void updateIcon(Action action) {
        Object object = action.getValue("SmallIcon");
        if (object == null) {
            Image image;
            String string = (String)action.getValue("IconResource");
            if (string == null) {
                string = "org/netbeans/modules/editor/resources/default.gif";
            }
            if ((image = org.openide.util.Utilities.loadImage((String)string)) != null) {
                action.putValue("SmallIcon", new ImageIcon(image));
            }
        }
    }

    private static void updateTooltip(AbstractButton abstractButton, List list) {
        String string;
        Action action = abstractButton.getAction();
        String string2 = string = action == null ? null : (String)action.getValue("Name");
        if (string == null) {
            return;
        }
        for (Object e : list) {
            if (!(e instanceof MultiKeyBinding)) continue;
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)e;
            if (!string.equals(multiKeyBinding.actionName)) continue;
            abstractButton.setToolTipText(abstractButton.getToolTipText() + " (" + NbEditorToolBar.getMnemonic(multiKeyBinding) + ")");
            break;
        }
    }

    static Lookup createActionContext(JTextComponent jTextComponent) {
        Container container;
        DataObject dataObject;
        Lookup lookup = null;
        DataObject dataObject2 = dataObject = jTextComponent != null ? NbEditorUtilities.getDataObject(jTextComponent.getDocument()) : null;
        if (dataObject != null && dataObject.isValid()) {
            lookup = dataObject.getNodeDelegate().getLookup();
        }
        Lookup lookup2 = null;
        for (container = jTextComponent; container != null; container = container.getParent()) {
            Lookup lookup3;
            if (!(container instanceof Lookup.Provider) || (lookup3 = ((Lookup.Provider)container).getLookup()) == null) continue;
            lookup2 = lookup3;
            break;
        }
        if (lookup == null) {
            return lookup2;
        }
        if (lookup2 == null) {
            return lookup;
        }
        assert (lookup != null && lookup2 != null);
        container = (Node)lookup.lookup(Node.class);
        boolean bl = lookup2.lookup(new Lookup.Template(Node.class)).allInstances().contains(container);
        if (bl) {
            return lookup2;
        }
        return new ProxyLookup(new Lookup[]{lookup, lookup2});
    }

    private void processButton(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setMargin(BUTTON_INSETS);
        if (abstractButton instanceof AbstractButton) {
            abstractButton.addMouseListener(sharedMouseListener);
        }
        abstractButton.setFocusable(false);
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        JTextComponent jTextComponent = this.getComponent();
        if (string != null && jTextComponent != null) {
            Action action;
            EditorKit editorKit;
            TextUI textUI = jTextComponent.getUI();
            Keymap keymap = jTextComponent.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(jTextComponent)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null) {
                KeyStroke[] keyStrokeArray2 = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray2 != null && keyStrokeArray2.length > 0) {
                    keyStrokeArray = keyStrokeArray2;
                } else {
                    MultiKeymap multiKeymap = ((BaseKit)editorKit).getKeymap();
                    KeyStroke[] keyStrokeArray3 = multiKeymap.getKeyStrokesForAction(action);
                    if (keyStrokeArray3 != null && keyStrokeArray3.length > 0) {
                        keyStrokeArray = keyStrokeArray3;
                    }
                }
            }
        }
        return keyStrokeArray;
    }

    private static final class NoOpAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static final class WrapperAction
    implements Action {
        private final Reference componentRef;
        private final Action delegate;

        WrapperAction(Reference reference, Action action) {
            this.componentRef = reference;
            assert (action != null);
            this.delegate = action;
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.delegate.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
            this.delegate.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.removePropertyChangeListener(propertyChangeListener);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = (JTextComponent)this.componentRef.get();
            if (jTextComponent != null) {
                actionEvent = new ActionEvent(jTextComponent, actionEvent.getID(), actionEvent.getActionCommand());
            }
            this.delegate.actionPerformed(actionEvent);
        }
    }
}

