/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputEditorKit;
import org.netbeans.core.output2.OutputTab;
import org.netbeans.core.output2.WrappedTextView;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.openide.util.NbPreferences;

class OutputPane
extends AbstractOutputPane
implements ComponentListener {
    private Segment seg = new Segment();
    private static final boolean GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    private int prevW = -1;

    OutputPane() {
    }

    protected void documentChanged() {
        super.documentChanged();
        this.findOutputTab().documentChanged();
    }

    protected void caretEnteredLine(int n) {
        this.findOutputTab().caretEnteredLine(n);
    }

    protected void lineClicked(int n, Point point) {
        if (!(this.getDocument() instanceof OutputDocument) || !this.inLeadingOrTrailingWhitespace(n, point)) {
            this.findOutputTab().lineClicked(n);
        }
    }

    private boolean linePressed(int n, Point point) {
        boolean bl = !(this.getDocument() instanceof OutputDocument) || !this.inLeadingOrTrailingWhitespace(n, point) ? this.findOutputTab().linePressed(n, point) : false;
        return bl;
    }

    protected void postPopupMenu(Point point, Component component) {
        this.findOutputTab().postPopupMenu(point, component);
    }

    public void setMouseLine(int n, Point point) {
        Document document = this.getDocument();
        if (document instanceof OutputDocument) {
            boolean bl;
            boolean bl2 = bl = n != -1 && ((OutputDocument)document).getLines().isHyperlink(n);
            if (bl && point != null && this.inLeadingOrTrailingWhitespace(n, point)) {
                bl = false;
                n = -1;
            }
            this.textView.setCursor(bl ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(2));
        }
        super.setMouseLine(n, point);
    }

    private boolean inLeadingOrTrailingWhitespace(int n, Point point) {
        if (n == -1) {
            return true;
        }
        assert (this.getDocument() instanceof OutputDocument);
        assert (point != null);
        OutputDocument outputDocument = (OutputDocument)this.getDocument();
        int n2 = outputDocument.getLineStart(n);
        int n3 = outputDocument.getLineEnd(n);
        try {
            outputDocument.getText(n2, n3 - n2, this.seg);
            char c = this.seg.first();
            while (Character.isWhitespace(c) && c != '\uffff') {
                ++n2;
                c = this.seg.next();
            }
            c = this.seg.last();
            while (Character.isWhitespace(c) && c != '\uffff') {
                --n3;
                c = this.seg.previous();
            }
            if (n3 <= n2) {
                n = -1;
            } else {
                boolean bl;
                Rectangle rectangle = this.textView.modelToView(n2);
                Rectangle rectangle2 = this.textView.modelToView(n3);
                if (point.y >= rectangle.y && point.y <= rectangle2.y && this.isWrapped()) {
                    rectangle2.x = 0;
                    rectangle2.width = this.getWidth();
                }
                boolean bl2 = bl = point.x >= rectangle.x && point.y >= rectangle.y && point.x <= rectangle2.x + rectangle2.width && point.y <= rectangle2.y + rectangle2.height;
                if (!bl) {
                    n = -1;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n == -1;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Document document = this.getDocument();
        if (document instanceof OutputDocument && ((OutputDocument)document).getLines().hasHyperlinks()) {
            super.mouseMoved(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2;
        super.mousePressed(mouseEvent);
        if (mouseEvent.getSource() == this.textView && SwingUtilities.isLeftMouseButton(mouseEvent) && (n2 = this.textView.viewToModel(mouseEvent.getPoint())) != -1 && (n = this.textView.getDocument().getDefaultRootElement().getElementIndex(n2)) >= 0 && this.linePressed(n, mouseEvent.getPoint())) {
            mouseEvent.consume();
            return;
        }
        this.findOutputTab().setToFocus((Component)mouseEvent.getSource());
        this.findOutputTab().requestActive();
    }

    private OutputTab findOutputTab() {
        return (OutputTab)SwingUtilities.getAncestorOfClass(OutputTab.class, this);
    }

    protected void setDocument(Document document) {
        if (document == null) {
            Document document2 = this.getDocument();
            if (document2 != null) {
                document2.removeDocumentListener(this);
            }
            this.textView.setDocument(new PlainDocument());
            return;
        }
        this.textView.setEditorKit(new OutputEditorKit(this.isWrapped(), this.textView));
        super.setDocument(document);
        this.updateKeyBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrapped(boolean bl) {
        if (bl != this.isWrapped() || !(this.getEditorKit() instanceof OutputEditorKit)) {
            NbPreferences.forModule(OutputPane.class).putBoolean("wrap", bl);
            final int n = this.textView.getCaret().getDot();
            Cursor cursor = this.textView.getCursor();
            try {
                this.textView.setCursor(Cursor.getPredefinedCursor(3));
                this.setEditorKit(new OutputEditorKit(bl, this.textView));
            }
            finally {
                this.textView.setCursor(cursor);
            }
            if (bl) {
                this.getViewport().addChangeListener(this);
            } else {
                this.getViewport().removeChangeListener(this);
            }
            SwingUtilities.invokeLater(new Runnable(){
                private boolean first = true;

                public void run() {
                    if (this.first) {
                        this.first = false;
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    OutputPane.this.textView.getCaret().setDot(n);
                }
            });
            if (this.getDocument() instanceof OutputDocument && ((OutputDocument)this.getDocument()).getLines().isGrowing()) {
                this.lockScroll();
            }
            if (!bl) {
                this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getModel().getMinimum());
            }
            this.validate();
        }
    }

    public boolean isWrapped() {
        if (this.getEditorKit() instanceof OutputEditorKit) {
            return this.getEditorKit() instanceof OutputEditorKit && ((OutputEditorKit)this.getEditorKit()).isWrapped();
        }
        return NbPreferences.forModule(OutputPane.class).getBoolean("wrap", false);
    }

    protected JEditorPane createTextView() {
        JEditorPane jEditorPane = GTK ? new GEP() : new JEditorPane();
        jEditorPane.addComponentListener(this);
        jEditorPane.setDisabledTextColor(jEditorPane.getBackground());
        InputMap inputMap = jEditorPane.getInputMap();
        MyInputMap myInputMap = new MyInputMap();
        myInputMap.setParent(inputMap);
        jEditorPane.setInputMap(0, myInputMap);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputDocument outputDocument = (OutputDocument)((JEditorPane)actionEvent.getSource()).getDocument();
                OutputPane.this.findOutputTab().inputSent(outputDocument.sendLine());
            }
        };
        jEditorPane.getActionMap().put("SENDLINE", abstractAction);
        abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputDocument outputDocument = (OutputDocument)((JEditorPane)actionEvent.getSource()).getDocument();
                OutputPane.this.findOutputTab().inputSent(outputDocument.sendLine());
                OutputPane.this.findOutputTab().inputEof();
            }
        };
        jEditorPane.getActionMap().put("EOF", abstractAction);
        return jEditorPane;
    }

    public void componentResized(ComponentEvent componentEvent) {
        WrappedTextView wrappedTextView;
        int n = this.textView.getWidth();
        if (this.prevW != n && this.isWrapped() && (wrappedTextView = ((OutputEditorKit)this.getEditorKit()).view()) != null) {
            wrappedTextView.setChanged();
            this.textView.repaint();
        }
        this.prevW = n;
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private static final class GEP
    extends JEditorPane {
        private GEP() {
        }

        public Color getBackground() {
            return UIManager.getColor("text");
        }
    }

    protected class MyInputMap
    extends InputMap {
        public Object get(KeyStroke keyStroke) {
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke("control shift O");
            if (keyStroke.equals(keyStroke2)) {
                return null;
            }
            keyStroke2 = KeyStroke.getKeyStroke(8, 2);
            if (keyStroke.equals(keyStroke2)) {
                return null;
            }
            keyStroke2 = KeyStroke.getKeyStroke(10, 0);
            if (keyStroke.equals(keyStroke2) && OutputPane.this.findOutputTab().isInputVisible()) {
                return "SENDLINE";
            }
            keyStroke2 = KeyStroke.getKeyStroke(68, 2);
            if (keyStroke.equals(keyStroke2)) {
                return "EOF";
            }
            Object object = super.get(keyStroke);
            return object;
        }
    }
}

