/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateUnitProviderPanel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SettingsTab
extends JPanel {
    private DetailsPanel details;
    private JScrollPane scrollerForDetails;
    private JTable table;
    private JScrollPane scrollerForTable;
    private Action removeAction;
    private Action editAction;
    private Action addAction;
    private Listener listener;
    private PluginManagerUI manager;
    private JButton addButton;
    private JButton bProxy;
    private JComboBox cbCheckPeriod;
    private JCheckBox cbGlobalInstall;
    private JSeparator jSeparatorAdvanced;
    private JSeparator jSeparatorConnection;
    private JLabel lCheckPeriod;
    private JLabel lConnection;
    private JLabel lGeneral;
    private JLabel lUpdateCenters;
    private ButtonGroup pluginsViewGroup;
    private JSplitPane spTab;

    public SettingsTab(PluginManagerUI pluginManagerUI) {
        this.manager = pluginManagerUI;
        this.initComponents();
        this.scrollerForTable = new JScrollPane();
        this.table = new Table();
        this.scrollerForTable.setViewportView(this.table);
        this.scrollerForDetails = new JScrollPane();
        this.details = new DetailsPanel();
        this.scrollerForDetails.setViewportView(this.details);
        this.spTab.setLeftComponent(this.scrollerForTable);
        this.spTab.setRightComponent(this.scrollerForDetails);
        this.table.setModel(new SettingsTableModel());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(new UpdateProviderRenderer());
        this.cbCheckPeriod.setModel(new DefaultComboBoxModel<String>(new String[]{SettingsTab.getMessage("CTL_Update_every_startup"), SettingsTab.getMessage("CTL_Update_every_day"), SettingsTab.getMessage("CTL_Update_every_week"), SettingsTab.getMessage("CTL_Update_every_2weeks"), SettingsTab.getMessage("CTL_Update_every_month"), SettingsTab.getMessage("CTL_Update_never")}));
        this.cbCheckPeriod.setSelectedIndex(this.getAutoUpdatePeriod());
        this.cbGlobalInstall.setSelected(Utilities.isGlobalInstallation());
        this.getSettingsTableModel().setSettingsTab(this);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(this.table.getTableHeader().getHeaderRect((int)0).width);
        this.editAction = new EditAction();
        this.removeAction = new RemoveAction();
        this.addAction = new AddAction();
        this.addButton.setAction(this.addAction);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_displayName");
    }

    PluginManagerUI getPluginManager() {
        return this.manager;
    }

    private void addListener() {
        if (this.listener == null) {
            this.listener = new Listener();
            this.table.getSelectionModel().addListSelectionListener(this.listener);
            this.getSettingsTableModel().addTableModelListener(this.listener);
        }
    }

    private void removeListener() {
        if (this.listener != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.listener);
            this.getSettingsTableModel().removeTableModelListener(this.listener);
            this.listener = null;
        }
    }

    public void addNotify() {
        super.addNotify();
        Utilities.startAsWorkerThread(new Runnable(){

            public void run() {
                SettingsTab.this.getSettingsTableModel().refreshModel();
            }
        });
        this.addListener();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListener();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SettingsTab.class, (String)string);
    }

    private void initComponents() {
        this.pluginsViewGroup = new ButtonGroup();
        this.lUpdateCenters = new JLabel();
        this.spTab = new JSplitPane();
        this.addButton = new JButton();
        this.lConnection = new JLabel();
        this.jSeparatorConnection = new JSeparator();
        this.lCheckPeriod = new JLabel();
        this.cbCheckPeriod = new JComboBox();
        this.bProxy = new JButton();
        this.lGeneral = new JLabel();
        this.cbGlobalInstall = new JCheckBox();
        this.jSeparatorAdvanced = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.lUpdateCenters, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lUpdateCenters.text"));
        this.spTab.setBorder(null);
        this.spTab.setDividerLocation(370);
        this.spTab.setResizeWeight(0.5);
        this.spTab.setOneTouchExpandable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.addButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.lConnection, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lConnection.text"));
        this.lCheckPeriod.setLabelFor(this.cbCheckPeriod);
        Mnemonics.setLocalizedText((JLabel)this.lCheckPeriod, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lCheckPeriod.text"));
        this.cbCheckPeriod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsTab.this.cbCheckPeriodActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bProxy, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bProxy.text"));
        this.bProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsTab.this.bProxyActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lGeneral, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lGeneral.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbGlobalInstall, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.text"));
        this.cbGlobalInstall.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        this.cbGlobalInstall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsTab.this.cbGlobalInstallActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.addButton).add((Component)this.spTab, -1, 785, Short.MAX_VALUE)).add(1, 1, 1)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.lCheckPeriod).addPreferredGap(0).add((Component)this.cbCheckPeriod, 0, 506, Short.MAX_VALUE).add(58, 58, 58).add((Component)this.bProxy)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lGeneral).addPreferredGap(0).add((Component)this.jSeparatorAdvanced, -1, 711, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lConnection).addPreferredGap(0).add((Component)this.jSeparatorConnection, -1, 565, Short.MAX_VALUE)).add((Component)this.lUpdateCenters).add((Component)this.cbGlobalInstall)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lUpdateCenters).addPreferredGap(0).add((Component)this.spTab, -1, 37, Short.MAX_VALUE).add(4, 4, 4).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).add(11, 11, 11).add((Component)this.jSeparatorConnection, -2, 10, -2)).add((Component)this.lConnection)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.bProxy).add((Component)this.lCheckPeriod).add((Component)this.cbCheckPeriod, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lGeneral, -2, 15, -2).add((Component)this.jSeparatorAdvanced, -2, 10, -2)).addPreferredGap(1).add((Component)this.cbGlobalInstall).addContainerGap()));
    }

    private void cbGlobalInstallActionPerformed(ActionEvent actionEvent) {
        if (this.cbGlobalInstall.isSelected()) {
            List<File> list = Utilities.sharedDirs();
            if (list.isEmpty()) {
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.NoSharedMessage"), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.NoSharedTitle"), 0, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
                this.cbGlobalInstall.setSelected(false);
                return;
            }
            for (File file : list) {
                if (!file.exists() || !file.isDirectory() || file.canWrite()) continue;
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.ReadOnlyMessage", (Object)file), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.ReadOnlyTitle"), 0, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
                this.cbGlobalInstall.setSelected(false);
                return;
            }
            Utilities.setGlobalInstallation(true);
        } else {
            Utilities.setGlobalInstallation(false);
        }
    }

    private void cbCheckPeriodActionPerformed(ActionEvent actionEvent) {
        this.setAutoUpdatePeriod(this.cbCheckPeriod.getSelectedIndex());
    }

    private void bProxyActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    public SettingsTableModel getSettingsTableModel() {
        return (SettingsTableModel)this.table.getModel();
    }

    private void setData(final UpdateUnitProvider updateUnitProvider, UpdateUnitProviderPanel updateUnitProviderPanel) {
        updateUnitProvider.setDisplayName(updateUnitProviderPanel.getProviderName());
        boolean bl = false;
        boolean bl2 = false;
        try {
            URL uRL = updateUnitProvider.getProviderURL();
            URL uRL2 = new URL(updateUnitProviderPanel.getProviderURL());
            if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
                updateUnitProvider.setProviderURL(uRL2);
                bl2 = true;
                bl = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        boolean bl3 = updateUnitProvider.isEnabled();
        if (bl3 != updateUnitProviderPanel.isActive()) {
            bl2 = true;
        }
        if (bl2) {
            updateUnitProvider.setEnable(updateUnitProviderPanel.isActive());
            if (bl3 && !bl) {
                this.setWaitingState(true);
                Utilities.startAsWorkerThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SettingsTab.this.getPluginManager().updateUnitsChanged();
                        }
                        finally {
                            SettingsTab.this.setWaitingState(false);
                        }
                    }
                });
            } else {
                final boolean bl4 = bl;
                this.setWaitingState(true);
                Utilities.startAsWorkerThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Utilities.presentRefreshProviders(Collections.singleton(updateUnitProvider), SettingsTab.this.getPluginManager(), bl4);
                            SettingsTab.this.getPluginManager().updateUnitsChanged();
                        }
                        finally {
                            SettingsTab.this.setWaitingState(false);
                        }
                    }
                });
            }
        }
    }

    private static DialogDescriptor getCustomizerDescriptor(UpdateUnitProviderPanel updateUnitProviderPanel) {
        JButton jButton = updateUnitProviderPanel.getOKButton();
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)updateUnitProviderPanel, updateUnitProviderPanel.getDisplayName(), true, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
        return dialogDescriptor;
    }

    int getAutoUpdatePeriod() {
        return SettingsTab.getAutoupdatePreferences().getInt("period", 2);
    }

    void setAutoUpdatePeriod(int n) {
        if (n != this.getAutoUpdatePeriod()) {
            SettingsTab.getAutoupdatePreferences().putInt("period", n);
        }
    }

    private static Preferences getAutoupdatePreferences() {
        return NbPreferences.root().node("org/netbeans/modules/autoupdate");
    }

    void setWaitingState(boolean bl) {
        this.getPluginManager().setWaitingState(bl);
        this.table.setEnabled(!bl);
    }

    private class AddAction
    extends AbstractAction {
        AddAction() {
            super(UnitTab.textForKey("SettingsTab.AddButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.AddButton.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final UpdateUnitProviderPanel updateUnitProviderPanel = new UpdateUnitProviderPanel(true, NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderName"), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderURL"), false);
            DialogDescriptor dialogDescriptor = SettingsTab.getCustomizerDescriptor(updateUnitProviderPanel);
            updateUnitProviderPanel.getOKButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SettingsTab.this.getSettingsTableModel().add(updateUnitProviderPanel.getProviderName(), updateUnitProviderPanel.getProviderName(), new URL(updateUnitProviderPanel.getProviderURL()), updateUnitProviderPanel.isActive());
                        SettingsTab.this.getSettingsTableModel().refreshModel();
                        SettingsTableModel settingsTableModel = SettingsTab.this.getSettingsTableModel();
                        for (int i = 0; i < settingsTableModel.getRowCount(); ++i) {
                            String string = settingsTableModel.getValueAt(i, 1).toString();
                            if (updateUnitProviderPanel.getProviderName() == null || !updateUnitProviderPanel.getProviderName().equals(string)) continue;
                            SettingsTab.this.table.getSelectionModel().setSelectionInterval(i, i);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            });
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        }
    }

    private class EditAction
    extends AbstractAction {
        EditAction() {
            super(UnitTab.textForKey("SettingsTab.EditButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.EditButton.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final int n = SettingsTab.this.table.getSelectedRow();
            if (n != -1) {
                final UpdateUnitProvider updateUnitProvider = SettingsTab.this.getSettingsTableModel().getUpdateUnitProvider(n);
                if (updateUnitProvider == null) {
                    return;
                }
                final UpdateUnitProviderPanel updateUnitProviderPanel = new UpdateUnitProviderPanel(updateUnitProvider.isEnabled(), updateUnitProvider.getDisplayName(), updateUnitProvider.getProviderURL().toExternalForm(), true);
                DialogDescriptor dialogDescriptor = SettingsTab.getCustomizerDescriptor(updateUnitProviderPanel);
                updateUnitProviderPanel.getOKButton().addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SettingsTab.this.setData(updateUnitProvider, updateUnitProviderPanel);
                        SettingsTab.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                });
                DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
                if (SettingsTab.this.listener != null) {
                    SettingsTab.this.listener.modelOrSelectionChanged();
                }
            }
        }
    }

    private class Listener
    implements ListSelectionListener,
    TableModelListener {
        private Listener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Listener.this.modelOrSelectionChanged();
                }
            });
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Listener.this.modelOrSelectionChanged();
                }
            });
        }

        private void modelOrSelectionChanged() {
            int n = SettingsTab.this.table.getSelectedRow();
            if (n != -1) {
                UpdateUnitProvider updateUnitProvider = ((SettingsTableModel)SettingsTab.this.table.getModel()).getUpdateUnitProvider(n);
                if (updateUnitProvider != null) {
                    String string;
                    StringBuffer stringBuffer = new StringBuffer();
                    SettingsTab.this.details.setTitle(updateUnitProvider.getDisplayName());
                    URL uRL = updateUnitProvider.getProviderURL();
                    String string2 = string = updateUnitProvider.getDescription() == null ? "" : updateUnitProvider.getDescription();
                    if (uRL != null) {
                        if (string.length() > 0) {
                            stringBuffer.append("<b>" + SettingsTab.getMessage("SettingsTab_UpdateUnitProvider_Description") + "</b><br>");
                            stringBuffer.append(string + "<br><br>");
                        }
                        stringBuffer.append("<b>" + SettingsTab.getMessage("SettingsTab_UpdateUnitProvider_URL") + " </b><a href=\"" + uRL.toExternalForm() + "\">" + uRL.toExternalForm() + "</a><br>");
                    }
                    SettingsTab.this.details.setText(stringBuffer.toString());
                    SettingsTab.this.details.setActionListener(SettingsTab.this.removeAction);
                    SettingsTab.this.details.setActionListener2(SettingsTab.this.editAction);
                }
            } else {
                SettingsTab.this.details.setTitle(null);
                SettingsTab.this.details.setText(null);
                SettingsTab.this.details.setActionListener2(null);
                SettingsTab.this.details.setActionListener(null);
                ListSelectionModel listSelectionModel = SettingsTab.this.table.getSelectionModel();
                listSelectionModel.setSelectionInterval(0, 0);
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            super(UnitTab.textForKey("SettingsTab.RemoveButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.RemoveButton.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            SettingsTableModel settingsTableModel = SettingsTab.this.getSettingsTableModel();
            for (int n : nArray = SettingsTab.this.table.getSelectedRows()) {
                UpdateUnitProvider updateUnitProvider;
                if (n == -1 || (updateUnitProvider = settingsTableModel.getUpdateUnitProvider(n)) == null) continue;
                String string = NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bRemove.message", (Object)updateUnitProvider.getDisplayName());
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string);
                confirmation.setOptionType(0);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (!NotifyDescriptor.YES_OPTION.equals(object)) continue;
                settingsTableModel.remove(n);
            }
            settingsTableModel.refreshModel();
            if (nArray.length > 0) {
                if (settingsTableModel.getRowCount() > nArray[0]) {
                    SettingsTab.this.table.getSelectionModel().setSelectionInterval(nArray[0], nArray[0]);
                } else {
                    SettingsTab.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }
    }

    private class Table
    extends JTable {
        public Table() {
            this.setShowGrid(false);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UpdateCentersTable"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_UpdateCentersTable"));
            SettingsTab.this.lUpdateCenters.setLabelFor(this);
        }

        public void addNotify() {
            super.addNotify();
            this.getParent().setBackground(this.getBackground());
        }

        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            Color color = this.getBackground();
            Color color2 = UnitTable.getDarkerColor(color);
            if (this.isRowSelected(n)) {
                component.setForeground(this.getSelectionForeground());
            } else {
                component.setForeground(this.getForeground());
            }
            if (!this.isCellSelected(n, n2)) {
                if (n % 2 == 0) {
                    component.setBackground(color2);
                } else {
                    component.setBackground(color);
                }
            }
            return component;
        }
    }

    private static class UpdateProviderRenderer
    extends DefaultTableCellRenderer {
        private UpdateProviderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel;
            JLabel jLabel2 = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof UpdateUnitProvider) {
                jLabel = (UpdateUnitProvider)object;
                UpdateUnitProvider.CATEGORY cATEGORY = jLabel.getCategory();
                if (UpdateUnitProvider.CATEGORY.BETA.equals((Object)cATEGORY)) {
                    jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-beta.png")));
                } else if (UpdateUnitProvider.CATEGORY.COMMUNITY.equals((Object)cATEGORY)) {
                    jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-community.png")));
                } else if (UpdateUnitProvider.CATEGORY.STANDARD.equals((Object)cATEGORY)) {
                    jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-standard.png")));
                }
                jLabel2.setText(jLabel.getDisplayName());
                jLabel2.setHorizontalAlignment(2);
            }
            jLabel = jLabel2;
            return jLabel;
        }
    }
}

