/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.EditorApiPackageAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorRegistry {
    private static final Logger LOG;
    public static final String FOCUS_GAINED_PROPERTY = "focusGained";
    public static final String FOCUS_LOST_PROPERTY = "focusLost";
    public static final String FOCUSED_DOCUMENT_PROPERTY = "focusedDocument";
    private static Item textComponentRefs;
    private static final PropertyChangeSupport pcs;

    private EditorRegistry() {
    }

    public static synchronized JTextComponent lastFocusedComponent() {
        return EditorRegistry.firstValidComponent();
    }

    public static synchronized JTextComponent focusedComponent() {
        JTextComponent jTextComponent = EditorRegistry.firstValidComponent();
        return jTextComponent != null && jTextComponent.isFocusOwner() ? jTextComponent : null;
    }

    public static synchronized List<? extends JTextComponent> componentList() {
        List list;
        JTextComponent jTextComponent = EditorRegistry.firstValidComponent();
        if (jTextComponent != null) {
            list = new ArrayList();
            list.add(jTextComponent);
            Item item = EditorRegistry.textComponentRefs.next;
            while (item != null) {
                jTextComponent = (JTextComponent)item.get();
                if (jTextComponent != null) {
                    list.add(jTextComponent);
                    item = item.next;
                    continue;
                }
                item = EditorRegistry.removeItem(item);
            }
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        pcs.removePropertyChangeListener(propertyChangeListener);
    }

    static synchronized void register(JTextComponent jTextComponent) {
        assert (jTextComponent != null);
        if (jTextComponent.getClientProperty(Item.class) == null) {
            Item item = new Item(jTextComponent);
            jTextComponent.putClientProperty(Item.class, item);
            jTextComponent.addFocusListener(FocusL.INSTANCE);
            if (textComponentRefs == null) {
                textComponentRefs = item;
            } else {
                Item item2 = textComponentRefs;
                while (item2.next != null) {
                    item2 = item2.next;
                }
                item2.next = item;
                item.previous = item2;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "REGISTERED new component as last item:\n" + EditorRegistry.dumpItemList());
            }
            if (jTextComponent.isFocusOwner()) {
                EditorRegistry.focusGained(jTextComponent, null);
            }
        }
    }

    static synchronized void focusGained(JTextComponent jTextComponent, Component component) {
        Item item = (Item)jTextComponent.getClientProperty(Item.class);
        assert (item != null) : "Not registered!";
        assert (item.next != null || item.previous != null || textComponentRefs == item) : "Already released!";
        EditorRegistry.moveToHead(item);
        jTextComponent.addPropertyChangeListener(PropertyDocL.INSTANCE);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "focusGained: " + EditorRegistry.dumpComponent(jTextComponent) + '\n');
        }
        EditorRegistry.firePropertyChange(FOCUS_GAINED_PROPERTY, component, jTextComponent);
    }

    static void focusLost(JTextComponent jTextComponent, Component component) {
        jTextComponent.removePropertyChangeListener(PropertyDocL.INSTANCE);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "focusLost: " + EditorRegistry.dumpComponent(jTextComponent) + '\n');
        }
        EditorRegistry.firePropertyChange(FOCUS_LOST_PROPERTY, jTextComponent, component);
    }

    static void focusedDocumentChange(JTextComponent jTextComponent, Document document, Document document2) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "focusedDocument: " + EditorRegistry.dumpComponent(jTextComponent) + "\n    OLDDoc=" + document + "\n    NEWDoc=" + document2 + '\n');
        }
        EditorRegistry.firePropertyChange(FOCUSED_DOCUMENT_PROPERTY, document, document2);
    }

    private static JTextComponent firstValidComponent() {
        JTextComponent jTextComponent = null;
        while (textComponentRefs != null && (jTextComponent = (JTextComponent)textComponentRefs.get()) == null) {
            EditorRegistry.removeItem(textComponentRefs);
        }
        return jTextComponent;
    }

    private static Item removeItem(Item item) {
        Item item2 = item.next;
        if (item.previous == null) {
            assert (textComponentRefs == item);
            textComponentRefs = item2;
        } else {
            item.previous.next = item2;
        }
        if (item2 != null) {
            item2.previous = item.previous;
        }
        item.previous = null;
        item.next = null;
        return item2;
    }

    private static void moveToHead(Item item) {
        if (LOG.isLoggable(Level.FINEST)) {
            EditorRegistry.isItemInList(item);
        }
        EditorRegistry.removeItem(item);
        item.next = textComponentRefs;
        if (textComponentRefs != null) {
            EditorRegistry.textComponentRefs.previous = item;
        }
        textComponentRefs = item;
        if (LOG.isLoggable(Level.FINEST)) {
            EditorRegistry.isItemInList(item);
            EditorRegistry.checkItemListConsistency();
        }
    }

    private static void firePropertyChange(String string, Object object, Object object2) {
        pcs.firePropertyChange(string, object, object2);
    }

    private static boolean isItemInList(Item item) {
        Item item2 = textComponentRefs;
        while (item2 != null) {
            if (item2 == item) {
                return true;
            }
            item2 = item2.next;
        }
        return false;
    }

    private static void checkItemListConsistency() {
        Item item = textComponentRefs;
        Item item2 = null;
        while (item != null) {
            assert (item.previous == item2);
            item2 = item;
            item = item.next;
        }
        if (item2 != null) assert (item2.next == null);
    }

    private static String dumpItemList() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Item item = textComponentRefs;
        while (item != null) {
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)n, (int)1);
            stringBuilder.append(EditorRegistry.dumpComponent((JTextComponent)item.get()));
            stringBuilder.append('\n');
            item = item.next;
            ++n;
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static String dumpComponent(JTextComponent jTextComponent) {
        return "c[IHC=" + System.identityHashCode(jTextComponent) + "]=" + jTextComponent;
    }

    static {
        EditorApiPackageAccessor.register(new PackageAccessor());
        LOG = Logger.getLogger(EditorRegistry.class.getName());
        pcs = new PropertyChangeSupport(EditorRegistry.class);
    }

    private static final class FocusL
    implements FocusListener {
        static final FocusL INSTANCE = new FocusL();

        private FocusL() {
        }

        public void focusGained(FocusEvent focusEvent) {
            EditorRegistry.focusGained((JTextComponent)focusEvent.getSource(), focusEvent.getOppositeComponent());
        }

        public void focusLost(FocusEvent focusEvent) {
            EditorRegistry.focusLost((JTextComponent)focusEvent.getSource(), focusEvent.getOppositeComponent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Item
    extends WeakReference<JTextComponent> {
        Item next;
        Item previous;

        Item(JTextComponent jTextComponent) {
            super(jTextComponent);
        }
    }

    private static final class PackageAccessor
    extends EditorApiPackageAccessor {
        private PackageAccessor() {
        }

        public void register(JTextComponent jTextComponent) {
            EditorRegistry.register(jTextComponent);
        }
    }

    private static final class PropertyDocL
    implements PropertyChangeListener {
        static final PropertyDocL INSTANCE = new PropertyDocL();

        private PropertyDocL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                EditorRegistry.focusedDocumentChange((JTextComponent)propertyChangeEvent.getSource(), (Document)propertyChangeEvent.getOldValue(), (Document)propertyChangeEvent.getNewValue());
            }
        }
    }
}

