/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.ResultStyleException;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class SumFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Sum", "Sum(<Set>[, <Numeric Expression>])", "Returns the sum of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}, SumFunDef.class);

    public SumFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ExpCompiler.ResultStyle[] rs = compiler.getAcceptableResultStyles();
        for (int i = 0; i < rs.length; ++i) {
            switch (rs[i]) {
                case ITERABLE: 
                case ANY: {
                    return this.compileCall(call, compiler, ExpCompiler.ResultStyle.ITERABLE);
                }
                case MUTABLE_LIST: {
                    return this.compileCall(call, compiler, ExpCompiler.ResultStyle.MUTABLE_LIST);
                }
                case LIST: {
                    return this.compileCall(call, compiler, ExpCompiler.ResultStyle.LIST);
                }
            }
        }
        throw ResultStyleException.generate(new ExpCompiler.ResultStyle[]{ExpCompiler.ResultStyle.ITERABLE, ExpCompiler.ResultStyle.LIST, ExpCompiler.ResultStyle.MUTABLE_LIST, ExpCompiler.ResultStyle.ANY}, rs);
    }

    protected Calc compileCall(ResolvedFunCall call, ExpCompiler compiler, ExpCompiler.ResultStyle resultStyle) {
        ValueCalc calc;
        Calc ncalc = compiler.compile(call.getArg(0), new ExpCompiler.ResultStyle[]{resultStyle});
        Calc calc2 = calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        if (ncalc instanceof ListCalc) {
            return this.genListCalc(call, ncalc, calc);
        }
        return this.genIterCalc(call, ncalc, calc);
    }

    protected Calc genIterCalc(ResolvedFunCall call, final Calc ncalc, final Calc calc) {
        return new AbstractDoubleCalc(call, new Calc[]{ncalc, calc}){

            public double evaluateDouble(Evaluator evaluator) {
                IterCalc iterCalc = (IterCalc)ncalc;
                Iterable iterable = SumFunDef.this.evaluateCurrentIterable(iterCalc, evaluator);
                return FunUtil.sumDouble(evaluator.push(), iterable, calc);
            }

            public Calc[] getCalcs() {
                return new Calc[]{ncalc, calc};
            }

            public boolean dependsOn(Dimension dimension) {
                return 1.anyDependsButFirst(this.getCalcs(), dimension);
            }
        };
    }

    protected Calc genListCalc(ResolvedFunCall call, final Calc ncalc, final Calc calc) {
        return new AbstractDoubleCalc(call, new Calc[]{ncalc, calc}){

            public double evaluateDouble(Evaluator evaluator) {
                ListCalc listCalc = (ListCalc)ncalc;
                List memberList = SumFunDef.this.evaluateCurrentList(listCalc, evaluator);
                return FunUtil.sumDouble(evaluator.push(), memberList, calc);
            }

            public Calc[] getCalcs() {
                return new Calc[]{ncalc, calc};
            }

            public boolean dependsOn(Dimension dimension) {
                return 2.anyDependsButFirst(this.getCalcs(), dimension);
            }
        };
    }
}

