/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.parsers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public final class DocumentInputSource
extends InputSource {
    private final Document doc;

    public DocumentInputSource(Document document) {
        this.doc = document;
    }

    public Reader getCharacterStream() {
        String string = DocumentInputSource.documentToString(this.doc);
        return new StringReader(string);
    }

    public final void setCharacterStream(Reader reader) {
    }

    public String getSystemId() {
        String string = super.getSystemId();
        if (string == null) {
            Object object = this.doc.getProperty("stream");
            if (object instanceof DataObject) {
                try {
                    DataObject dataObject = (DataObject)object;
                    FileObject fileObject = dataObject.getPrimaryFile();
                    URL uRL = fileObject.getURL();
                    string = uRL.toExternalForm();
                }
                catch (IOException iOException) {
                    ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
                    errorManager.notify((Throwable)iOException);
                }
            } else {
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
                errorManager.log("XML:DocumentInputSource:Unknown stream description:" + object);
            }
        }
        return string;
    }

    private static String documentToString(final Document document) {
        final String[] stringArray = new String[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    stringArray[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        };
        document.render(runnable);
        return stringArray[0];
    }

    public String toString() {
        return "DocumentInputSource SID:" + this.getSystemId();
    }
}

