/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

public class ContextTreeView
extends TreeView {
    static final long serialVersionUID = -8282594827988436813L;
    static final Logger LOG = Logger.getLogger(ContextTreeView.class.getName());

    public ContextTreeView() {
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return true;
        }
        Node node = nodeArray[0].getParentNode();
        for (int i = 1; i < nodeArray.length; ++i) {
            if (nodeArray[i].getParentNode() == node) continue;
            return false;
        }
        return true;
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        if (nodeArray.length > 0) {
            explorerManager.setExploredContext(nodeArray[0]);
        }
        explorerManager.setSelectedNodes(nodeArray);
    }

    protected void showPath(TreePath treePath) {
        this.tree.makeVisible(treePath);
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null) {
            rectangle.width += rectangle.x;
            rectangle.x = 0;
            this.tree.scrollRectToVisible(rectangle);
        }
        this.tree.setSelectionPath(treePath);
    }

    protected void showSelection(TreePath[] treePathArray) {
        if (treePathArray.length == 0) {
            this.tree.setSelectionPaths(new TreePath[0]);
        } else {
            this.tree.setSelectionPath(treePathArray[0].getParentPath());
        }
    }

    protected boolean useExploredContextMenu() {
        return true;
    }

    protected NodeTreeModel createModel() {
        return new NodeContextModel();
    }

    static final class NodeContextModel
    extends NodeTreeModel {
        private int[] newIndices;
        private Object[] newChildren;

        NodeContextModel() {
        }

        public Object getChild(Object object, int n) {
            int n2 = super.getChildCount(object);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Object object2 = super.getChild(object, i);
                Node node = Visualizer.findNode(object2);
                if (node.isLeaf() || n3++ != n) continue;
                return object2;
            }
            return null;
        }

        public int getChildCount(Object object) {
            int n = super.getChildCount(object);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Node node = Visualizer.findNode(super.getChild(object, i));
                if (node.isLeaf()) continue;
                ++n2;
            }
            return n2;
        }

        public int getIndexOfChild(Object object, Object object2) {
            int n = super.getChildCount(object);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Object object3 = super.getChild(object, i);
                if (object2.equals(object3)) {
                    return n2;
                }
                Node node = Visualizer.findNode(object3);
                if (node.isLeaf()) continue;
                ++n2;
            }
            return -1;
        }

        public boolean isLeaf(Object object) {
            return false;
        }

        private boolean filterEvent(Object[] objectArray, int[] nArray, Object[] objectArray2) {
            int n;
            assert (nArray != null && objectArray2 != null) : " ch: " + objectArray2 + " indices: " + nArray;
            assert (objectArray2.length == nArray.length) : "They should be the same: " + objectArray2.length + " == " + nArray.length;
            assert (this.newChildren == null) : "Children should be cleared: " + this.newChildren;
            assert (this.newIndices == null) : "indices should be cleared: " + this.newIndices;
            assert (objectArray.length > 0) : "Path has to be greater than zero " + objectArray.length;
            VisualizerNode visualizerNode = (VisualizerNode)objectArray[objectArray.length - 1];
            int[] nArray2 = new int[nArray.length];
            int n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                VisualizerNode visualizerNode2 = (VisualizerNode)objectArray2[n];
                if (visualizerNode2.isLeaf()) continue;
                nArray2[n2++] = n;
            }
            if (n2 == 0) {
                return false;
            }
            this.newIndices = new int[n2];
            this.newChildren = new Object[n2];
            for (n = 0; n < n2; ++n) {
                this.newChildren[n] = objectArray2[nArray2[n]];
                this.newIndices[n] = this.getIndexOfChild(visualizerNode, this.newChildren[n]);
            }
            return true;
        }

        private boolean removalEvent(Object[] objectArray, int[] nArray, Object[] objectArray2) {
            int n;
            assert (nArray != null && objectArray2 != null) : " ch: " + objectArray2 + " indices: " + nArray;
            assert (objectArray2.length == nArray.length) : "They should be the same: " + objectArray2.length + " == " + nArray.length;
            assert (this.newChildren == null) : "Children should be cleared: " + this.newChildren;
            assert (this.newIndices == null) : "indices should be cleared: " + this.newIndices;
            assert (objectArray.length > 0) : "Path has to be greater than zero " + objectArray.length;
            VisualizerNode visualizerNode = (VisualizerNode)objectArray[objectArray.length - 1];
            int[] nArray2 = new int[nArray.length];
            int n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                VisualizerNode visualizerNode2 = (VisualizerNode)objectArray2[n];
                if (visualizerNode2.isLeaf()) continue;
                nArray2[n2++] = n;
            }
            if (n2 == 0) {
                return false;
            }
            this.newIndices = new int[n2];
            this.newChildren = new Object[n2];
            n = this.getChildCount(visualizerNode);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                VisualizerNode visualizerNode3;
                if (nArray[n3] <= n6) {
                    visualizerNode3 = (VisualizerNode)objectArray2[n3];
                    if (!visualizerNode3.isLeaf()) {
                        this.newIndices[n7] = n4++;
                        this.newChildren[n7] = visualizerNode3;
                        ++n7;
                    }
                    ++n3;
                } else if ((visualizerNode3 = (VisualizerNode)this.getChild(visualizerNode, n5++)) != null && !visualizerNode3.isLeaf()) {
                    ++n4;
                }
                ++n6;
            }
            return true;
        }

        protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            LOG.fine("fireTreeNodesRemoved");
            if (!this.removalEvent(objectArray, nArray, objectArray2)) {
                LOG.fine("fireTreeNodesRemoved - exit");
                return;
            }
            super.fireTreeNodesRemoved(object, objectArray, this.newIndices, this.newChildren);
            this.newIndices = null;
            this.newChildren = null;
            LOG.fine("fireTreeNodesRemoved - end");
        }

        protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            LOG.fine("fireTreeNodesInserted");
            if (!this.filterEvent(objectArray, nArray, objectArray2)) {
                LOG.fine("fireTreeNodesInserted - exit");
                return;
            }
            super.fireTreeNodesInserted(object, objectArray, this.newIndices, this.newChildren);
            this.newIndices = null;
            this.newChildren = null;
            LOG.fine("fireTreeNodesInserted - end");
        }

        protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            LOG.fine("fireTreeNodesChanged");
            if (!this.filterEvent(objectArray, nArray, objectArray2)) {
                LOG.fine("fireTreeNodesChanged - exit");
                return;
            }
            super.fireTreeNodesChanged(object, objectArray, this.newIndices, this.newChildren);
            this.newIndices = null;
            this.newChildren = null;
            LOG.fine("fireTreeNodesChanged - end");
        }
    }
}

