/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.diff.builtin.DiffPresenter;
import org.netbeans.modules.diff.builtin.visualizer.DiffViewImpl;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class DefaultDiff
extends Diff
implements Serializable {
    private boolean showDiffSelector = true;

    public String getDisplayName() {
        return NbBundle.getMessage(DefaultDiff.class, (String)"DefaultDiff.displayName");
    }

    public Component createDiff(String string, String string2, Reader reader, String string3, String string4, Reader reader2, String string5) throws IOException {
        Difference[] differenceArray;
        DiffInfo diffInfo = new DiffInfo(string, string3, string2, string4, string5, this.showDiffSelector, this.showDiffSelector, reader, reader2);
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        try {
            differenceArray = diffProvider.computeDiff(diffInfo.createFirstReader(), diffInfo.createSecondReader());
            diffInfo.setInitialDiffs(differenceArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        differenceArray = new DiffPresenter(diffInfo);
        DiffTopComponent diffTopComponent = new DiffTopComponent((Component)differenceArray);
        diffInfo.setPresentingComponent(diffTopComponent);
        differenceArray.setProvider(diffProvider);
        differenceArray.setVisualizer((DiffVisualizer)Lookup.getDefault().lookup(DiffVisualizer.class));
        return diffTopComponent;
    }

    public DiffView createDiff(StreamSource streamSource, StreamSource streamSource2) throws IOException {
        if (System.getProperty("netbeans.experimental.diff55") != null) {
            return new DiffViewImpl(streamSource, streamSource2);
        }
        return new EditableDiffView(streamSource, streamSource2);
    }

    public boolean isShowDiffSelector() {
        return this.showDiffSelector;
    }

    public void setShowDiffSelector(boolean bl) {
        this.showDiffSelector = bl;
    }

    private static void cpStream(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray)) > 0) {
            writer.write(cArray, 0, n);
        }
        reader.close();
        writer.close();
    }

    private static class DiffInfo
    extends DiffPresenter.Info {
        private String buffer1;
        private String buffer2;
        private Difference[] diffs;

        public DiffInfo(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, Reader reader, Reader reader2) throws IOException {
            super(string, string2, string3, string4, string5, bl, bl2);
            StringWriter stringWriter = new StringWriter();
            StringWriter stringWriter2 = new StringWriter();
            DefaultDiff.cpStream(reader, stringWriter);
            DefaultDiff.cpStream(reader2, stringWriter2);
            this.buffer1 = stringWriter.toString();
            this.buffer2 = stringWriter2.toString();
        }

        public Reader createFirstReader() {
            return new StringReader(this.buffer1);
        }

        public Reader createSecondReader() {
            return new StringReader(this.buffer2);
        }

        void setInitialDiffs(Difference[] differenceArray) {
            this.diffs = differenceArray;
        }

        public Difference[] getInitialDifferences() {
            Difference[] differenceArray = this.diffs;
            this.diffs = null;
            return differenceArray;
        }
    }

    public static class DiffTopComponent
    extends TopComponent {
        public DiffTopComponent(Component component) {
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSN_Diff_Top_Component"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSD_Diff_Top_Component"));
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "DiffTopComponent";
        }

        public void open(Workspace workspace) {
            super.open(workspace);
            this.requestActive();
        }
    }
}

