/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.NullBand;
import com.jaspersoft.ireport.designer.outline.nodes.NullBandNode;
import com.jaspersoft.ireport.designer.undo.AddBandUndoableEdit;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddBandAction
extends NodeAction {
    private static AddBandAction instance = null;

    public static synchronized AddBandAction getInstance() {
        if (instance == null) {
            instance = new AddBandAction();
        }
        return instance;
    }

    private AddBandAction() {
    }

    public String getName() {
        return NbBundle.getMessage(AddBandAction.class, (String)"CTL_AddBandAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            JRDesignGroup g;
            if (!(activatedNodes[i] instanceof NullBandNode)) continue;
            NullBandNode nbn = (NullBandNode)activatedNodes[i];
            JasperDesign jd = (JasperDesign)nbn.getLookup().lookup(JasperDesign.class);
            NullBand band = (NullBand)nbn.getLookup().lookup(NullBand.class);
            if (jd == null || band == null) continue;
            JRDesignBand b = new JRDesignBand();
            b.setHeight(50);
            if (band.getOrigin().getBandType() == 1) {
                jd.setBackground((JRBand)b);
            } else if (band.getOrigin().getBandType() == 2) {
                jd.setTitle((JRBand)b);
            } else if (band.getOrigin().getBandType() == 3) {
                jd.setPageHeader((JRBand)b);
            } else if (band.getOrigin().getBandType() == 4) {
                jd.setColumnHeader((JRBand)b);
            } else if (band.getOrigin().getBandType() == 6) {
                jd.setDetail((JRBand)b);
            } else if (band.getOrigin().getBandType() == 8) {
                jd.setColumnFooter((JRBand)b);
            } else if (band.getOrigin().getBandType() == 9) {
                jd.setPageFooter((JRBand)b);
            } else if (band.getOrigin().getBandType() == 10) {
                jd.setLastPageFooter((JRBand)b);
            } else if (band.getOrigin().getBandType() == 11) {
                jd.setSummary((JRBand)b);
            } else if (band.getOrigin().getBandType() == 12) {
                jd.setNoData((JRBand)b);
            } else if (band.getOrigin().getBandType() == 5) {
                g = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                g.setGroupHeader((JRBand)b);
            } else if (band.getOrigin().getBandType() == 7) {
                g = (JRDesignGroup)jd.getGroupsMap().get(band.getOrigin().getGroupName());
                g.setGroupFooter((JRBand)b);
            }
            AddBandUndoableEdit edit = new AddBandUndoableEdit(b, jd);
            IReportManager.getInstance().addUndoableEdit(edit);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof NullBandNode) continue;
            return false;
        }
        return true;
    }
}

