/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.borders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import org.netbeans.api.visual.border.Border;
import org.openide.util.Utilities;

public class ElementSelectedBorder
implements Border {
    public static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final Insets INSETS = new Insets(5, 5, 5, 5);
    public static Color COLOR_1 = Color.LIGHT_GRAY;
    public static Color COLOR_2 = new Color(255, 175, 0, 200);
    private static final ImageIcon gripIcon = new ImageIcon(Utilities.loadImage((String)"com/jaspersoft/ireport/designer/borders/grip.png"));

    public Insets getInsets() {
        return INSETS;
    }

    public void paint(Graphics2D g, Rectangle bounds) {
        g.setPaint(COLOR_2);
        g.setStroke(new BasicStroke(2.0f));
        Rectangle2D.Double r = new Rectangle2D.Double((double)(bounds.x + ElementSelectedBorder.INSETS.left - 1) + 0.5, (double)(bounds.y + ElementSelectedBorder.INSETS.top - 1) + 0.5, (double)(bounds.width - ElementSelectedBorder.INSETS.left - ElementSelectedBorder.INSETS.right) - 1.0 + 2.0, (double)(bounds.height - ElementSelectedBorder.INSETS.top - ElementSelectedBorder.INSETS.bottom) - 1.0 + 2.0);
        g.draw(r);
        this.paintGrip(g, bounds.x, bounds.y);
        this.paintGrip(g, bounds.x + bounds.width - 5, bounds.y);
        this.paintGrip(g, bounds.x, bounds.y + bounds.height - 5);
        this.paintGrip(g, bounds.x + bounds.width - 5, bounds.y + bounds.height - 5);
        this.paintGrip(g, bounds.x + bounds.width / 2 - 2, bounds.y);
        this.paintGrip(g, bounds.x + bounds.width / 2 - 2, bounds.y + bounds.height - 5);
        this.paintGrip(g, bounds.x, bounds.y + bounds.height / 2 - 3);
        this.paintGrip(g, bounds.x + bounds.width - 5, bounds.y + bounds.height / 2 - 3);
    }

    public boolean isOpaque() {
        return false;
    }

    public void paintGrip(Graphics2D g, double x, double y) {
        Stroke oldStroke = g.getStroke();
        Paint oldPain = g.getPaint();
        Rectangle2D.Double r = new Rectangle2D.Double(x + 0.5, y + 0.5, 4.0, 4.0);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.WHITE, 3.0f, 3.0f, new Color(194, 209, 219));
        g.setPaint(gp);
        g.fill(r);
        g.setPaint(new Color(162, 185, 206));
        g.setStroke(new BasicStroke(1.0f));
        g.draw(r);
        g.setPaint(oldPain);
        g.setStroke(oldStroke);
    }
}

