/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import org.openide.nodes.PropertySupport;

public class FontSizeProperty
extends PropertySupport.ReadWrite {
    private final JRDesignTextElement element;
    PropertyEditor editor = null;

    public FontSizeProperty(JRDesignTextElement element) {
        super("fontSize", Integer.class, "Size", "Size");
        this.element = element;
        this.setValue("canEditAsText", true);
        this.setValue("oneline", true);
        this.setValue("suppressCustomEditor", false);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getFontSize();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val != null && !(val instanceof Integer)) {
            try {
                val = new Integer(val + "");
            }
            catch (Exception ex) {
                return;
            }
        }
        if (val == null || val instanceof Integer) {
            Integer oldValue = this.element.getOwnFontSize();
            Integer newValue = (Integer)val;
            this.element.setFontSize(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "FontSize", Integer.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.getOwnFontSize() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> classes = new ArrayList<Tag>();
            int i = 6;
            while (i < 100) {
                classes.add(new Tag(new Integer(i), "" + i));
                if (i < 16) {
                    ++i;
                    continue;
                }
                if (i < 32) {
                    i += 2;
                    continue;
                }
                if (i < 48) {
                    i += 4;
                    continue;
                }
                if (i < 72) {
                    i += 6;
                    continue;
                }
                i += 8;
            }
            this.editor = new ComboBoxPropertyEditor(true, classes);
        }
        return this.editor;
    }
}

