/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.db.core.SQLOptions;
import org.netbeans.modules.db.sql.execute.ColumnDef;
import org.netbeans.modules.db.sql.execute.FetchLimitHandler;
import org.netbeans.modules.db.sql.execute.ResultSetTableModelSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ResultSetTableModel
extends AbstractTableModel {
    private final List columnDefs;
    private final List rows;

    public static ResultSetTableModel create(DatabaseMetaData databaseMetaData, ResultSet resultSet) throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        List<ColumnDef> list = ResultSetTableModelSupport.createColumnDefs(databaseMetaData, resultSetMetaData);
        if (list == null) {
            return null;
        }
        List<List<Object>> list2 = ResultSetTableModelSupport.retrieveRows(databaseMetaData, resultSet, resultSetMetaData, new FetchLimitHandlerImpl());
        if (list2 == null) {
            return null;
        }
        return new ResultSetTableModel(list, list2);
    }

    private ResultSetTableModel(List list, List list2) {
        this.columnDefs = list;
        this.rows = list2;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columnDefs.size();
    }

    public Object getValueAt(int n, int n2) {
        List list = (List)this.rows.get(n);
        return list.get(n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return this.getColumnDef(n).getName();
    }

    public Class getColumnClass(int n) {
        return this.getColumnDef(n).getDisplayClass();
    }

    private ColumnDef getColumnDef(int n) {
        return (ColumnDef)this.columnDefs.get(n);
    }

    private static final class FetchLimitHandlerImpl
    implements FetchLimitHandler {
        private FetchLimitHandlerImpl() {
        }

        public int fetchLimitReached(int n) {
            JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(ResultSetTableModel.class, (String)"LBL_FetchYes"));
            jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultSetTableModel.class, (String)"ACSD_FetchYes"));
            JButton jButton2 = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(ResultSetTableModel.class, (String)"LBL_FetchAll"));
            jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultSetTableModel.class, (String)"ACSD_FetchAll"));
            JButton jButton3 = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)NbBundle.getMessage(ResultSetTableModel.class, (String)"LBL_FetchNo"));
            jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultSetTableModel.class, (String)"ACSD_FetchNo"));
            String string = NbBundle.getMessage(ResultSetTableModel.class, (String)"LBL_FetchNextTitle");
            String string2 = NbBundle.getMessage(ResultSetTableModel.class, (String)"LBL_FetchNextMessage", (Object[])new Object[]{new Integer(n), new Integer(SQLOptions.getDefault().getFetchStep())});
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string2, string, 1, 3, new Object[]{jButton, jButton2, jButton3}, NotifyDescriptor.CANCEL_OPTION);
            Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (object instanceof JButton) {
                if (object == jButton) {
                    return n + SQLOptions.getDefault().getFetchStep();
                }
                if (object == jButton2) {
                    return 0;
                }
                return n;
            }
            return n;
        }

        public int getFetchLimit() {
            return SQLOptions.getDefault().getFetchStep();
        }
    }
}

