/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target.scope;

import org.springframework.aop.framework.AbstractSingletonProxyFactoryBean;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.scope.Handle;
import org.springframework.aop.target.scope.HandleNotPersistentException;
import org.springframework.aop.target.scope.IncompatibleHandleException;
import org.springframework.aop.target.scope.ScopeMap;
import org.springframework.aop.target.scope.ScopedObject;
import org.springframework.aop.target.scope.ScopedTargetSource;
import org.springframework.aop.target.scope.ScopingConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;

public class ScopedProxyFactoryBean
extends AbstractSingletonProxyFactoryBean
implements InitializingBean,
BeanFactoryAware,
ScopingConfig {
    private Object proxy;
    private ScopedTargetSource scopedTargetSource = new ScopedTargetSource();

    public ScopedProxyFactoryBean() {
        this.setProxyTargetClass(true);
    }

    public void setScopeMap(ScopeMap scopeMap) {
        this.scopedTargetSource.setScopeMap(scopeMap);
    }

    public void setScopeKey(String scopeKey) {
        this.scopedTargetSource.setScopeKey(scopeKey);
    }

    public void setTargetBeanName(String targetBeanName) {
        this.scopedTargetSource.setTargetBeanName(targetBeanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.scopedTargetSource.setBeanFactory(beanFactory);
    }

    public void afterPropertiesSet() throws Exception {
        DefaultHandle handle = new DefaultHandle(this.getTargetBeanName(), this.getScopeMap().isPersistent());
        this.proxy = this.createProxyFactory(handle).getProxy();
    }

    private ProxyFactory createProxyFactory(DefaultHandle handle) {
        ProxyFactory pf = new ProxyFactory();
        pf.copyFrom(this);
        pf.setTargetSource(this.scopedTargetSource);
        if (this.scopedTargetSource.getTargetClass().isInterface()) {
            pf.addInterface(this.scopedTargetSource.getTargetClass());
            pf.setProxyTargetClass(false);
        }
        pf.addAdvice(new DelegatingIntroductionInterceptor(new DefaultScopedObject(handle)));
        return pf;
    }

    public Object reconnect(Handle handle) {
        if (handle == null) {
            throw new HandleNotPersistentException();
        }
        if (!handle.isPersistent()) {
            throw new HandleNotPersistentException(handle);
        }
        if (!(handle instanceof DefaultHandle)) {
            throw new IncompatibleHandleException(handle, "Handle is not a ScopedProxyFactoryBean handle");
        }
        DefaultHandle defHandle = (DefaultHandle)handle;
        if (!defHandle.getTargetBeanName().equals(this.getTargetBeanName())) {
            throw new IncompatibleHandleException(handle, "Handle does not point to target bean '" + this.getTargetBeanName() + "'");
        }
        ProxyFactory reconnectedProxyFactory = this.createProxyFactory(defHandle);
        ScopedTargetSource reconnectedTargetSource = new ScopedTargetSource();
        reconnectedTargetSource.copyFrom(this.scopedTargetSource);
        reconnectedProxyFactory.setTargetSource(reconnectedTargetSource);
        return reconnectedProxyFactory.getProxy();
    }

    public ScopeMap getScopeMap() {
        return this.scopedTargetSource.getScopeMap();
    }

    public String getScopeKey() {
        return this.scopedTargetSource.getScopeKey();
    }

    public String getTargetBeanName() {
        return this.scopedTargetSource.getTargetBeanName();
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.isProxyTargetClass()) {
            return this.scopedTargetSource.getBeanFactory().getType(this.scopedTargetSource.getTargetBeanName());
        }
        Advised advised = (Advised)this.proxy;
        if (advised.getProxiedInterfaces().length == 1) {
            return advised.getProxiedInterfaces()[0];
        }
        return null;
    }

    private class DefaultHandle
    implements Handle {
        private final String targetBeanName;
        private final boolean persistent;

        public DefaultHandle(String targetBeanName, boolean persistent) {
            this.targetBeanName = targetBeanName;
            this.persistent = persistent;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public String getTargetBeanName() {
            return this.targetBeanName;
        }
    }

    private class DefaultScopedObject
    implements ScopedObject {
        private DefaultHandle handle;

        public DefaultScopedObject(DefaultHandle handle) {
            this.handle = handle;
        }

        public ScopeMap getScopeMap() {
            return ScopedProxyFactoryBean.this.scopedTargetSource.getScopeMap();
        }

        public String getScopeKey() {
            return ScopedProxyFactoryBean.this.scopedTargetSource.getScopeKey();
        }

        public String getTargetBeanName() {
            return ScopedProxyFactoryBean.this.scopedTargetSource.getTargetBeanName();
        }

        public Handle getHandle() {
            return this.handle;
        }

        public void remove() {
            this.getScopeMap().remove(this.handle.getTargetBeanName());
        }
    }
}

