/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;

public class PropertyAccessExceptionsException
extends BeansException {
    private BeanWrapper beanWrapper;
    private PropertyAccessException[] propertyAccessExceptions;

    public PropertyAccessExceptionsException(BeanWrapper beanWrapper, PropertyAccessException[] propertyAccessExceptions) {
        super("");
        this.beanWrapper = beanWrapper;
        this.propertyAccessExceptions = propertyAccessExceptions;
    }

    public BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public Object getBindObject() {
        return this.beanWrapper.getWrappedInstance();
    }

    public int getExceptionCount() {
        return this.propertyAccessExceptions.length;
    }

    public PropertyAccessException[] getPropertyAccessExceptions() {
        return this.propertyAccessExceptions;
    }

    public PropertyAccessException getPropertyAccessException(String propertyName) {
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            if (!propertyName.equals(pae.getPropertyChangeEvent().getPropertyName())) continue;
            return pae;
        }
        return null;
    }

    public String toString() {
        return "PropertyAccessExceptionsException (" + this.getExceptionCount() + " errors)";
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString());
        sb.append("; nested PropertyAccessExceptions are: ");
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            sb.append("[");
            sb.append(pae.getClass().getName());
            sb.append(": ");
            sb.append(pae.getMessage());
            sb.append(']');
            if (i >= this.propertyAccessExceptions.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(this);
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            pae.printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this);
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            pae.printStackTrace(pw);
        }
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        if (exClass.isInstance(this)) {
            return true;
        }
        for (int i = 0; i < this.propertyAccessExceptions.length; ++i) {
            PropertyAccessException pae = this.propertyAccessExceptions[i];
            if (!pae.contains(exClass)) continue;
            return true;
        }
        return false;
    }
}

