/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import rex.graphics.dimensiontree.elements.LevelElement;
import rex.metadata.QueryElement;
import rex.metadata.resultelements.Axis;
import rex.metadata.resultelements.Member;
import rex.utils.S;

public class QueryDimensionElement
implements QueryElement {
    private LinkedList except;
    private LinkedList members;
    private String hierarchyUniqueName;
    private String levelExpression;
    private boolean toggled;
    private boolean valid;
    private String toggleExpression;

    public QueryDimensionElement(QueryElement qe) {
        this.hierarchyUniqueName = qe.getHierarchyUniqueName();
        this.toggled = false;
        this.valid = true;
        if (!(qe instanceof LevelElement)) {
            this.addMemberToList(qe);
        } else {
            this.levelExpression = qe.getQueryMembersExpression();
        }
    }

    public boolean hasMember(QueryElement qe) {
        if (this.members == null) {
            return false;
        }
        Iterator it = this.members.iterator();
        while (it.hasNext()) {
            if (!((QueryElement)it.next()).getQueryMembersExpression().equals(qe.getQueryMembersExpression())) continue;
            return true;
        }
        return false;
    }

    public void addMemberToList(QueryElement qe) {
        if (!this.hasMember(qe)) {
            if (this.members == null) {
                this.members = new LinkedList();
            }
            this.members.add(qe);
        }
    }

    public void addMemberToExceptList(QueryElement qe) {
        if (this.except == null) {
            this.except = new LinkedList();
        }
        this.except.add(qe);
    }

    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    public String getQueryMembersExpression() {
        String retVal;
        if (this.toggled) {
            return this.toggleExpression;
        }
        if (this.members == null) {
            retVal = this.levelExpression;
        } else {
            retVal = "";
            Iterator it = this.members.iterator();
            while (it.hasNext()) {
                retVal = retVal + ((QueryElement)it.next()).getQueryMembersExpression() + ", ";
            }
            retVal = retVal.substring(0, retVal.length() - 2);
        }
        if (this.except != null && this.except.size() > 0) {
            String ex = "";
            Iterator it = this.except.iterator();
            while (it.hasNext()) {
                ex = ex + ((QueryElement)it.next()).getQueryMembersExpression() + ", ";
            }
            retVal = "Except({" + retVal + "}, {" + ex.substring(0, ex.length() - 2) + "})";
        }
        return retVal;
    }

    public String toString() {
        return "QueryDimensionElement\n  hierarchyUniqueName=" + this.hierarchyUniqueName + "\n  getQueryMembersExpression = " + this.getQueryMembersExpression();
    }

    public void toggleDrillState(Member member) {
        if (this.toggled) {
            S.out("assert: can't toggle QueryDimensionElement twice!");
        } else {
            this.toggleExpression = "ToggleDrillState({" + this.getQueryMembersExpression() + "}" + ", {" + member.getUniqueName() + "}" + ")";
            this.toggled = true;
        }
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void updateWithResult(Axis a) {
        int i;
        int memberOrdinal = -1;
        if (!this.toggled) {
            S.out("assert: updateWithResult called with toggled=false ?");
            return;
        }
        if (this.members != null) {
            this.members.clear();
        }
        for (i = 0; i < a.getHierarchyInfoCount(); ++i) {
            if (!a.getTupleAt(0).getMemberAt(i).getUniqueName().startsWith(this.getHierarchyUniqueName())) continue;
            memberOrdinal = i;
            break;
        }
        if (memberOrdinal < 0) {
            S.out("assert: updateWithResult: couldn't find memberOrdinal");
            return;
        }
        for (i = 0; i < a.getTupleCount(); ++i) {
            this.addMemberToList(a.getTupleAt(i).getMemberAt(memberOrdinal));
        }
        this.toggled = false;
    }

    void removeMember(QueryElement memberToRemove) {
        if (!this.hasMember(memberToRemove)) {
            this.addMemberToExceptList(memberToRemove);
        } else {
            ListIterator it = this.members.listIterator();
            while (it.hasNext()) {
                if (!((QueryElement)it.next()).getQueryMembersExpression().equals(memberToRemove.getQueryMembersExpression())) continue;
                it.previous();
                it.remove();
                if (this.members.size() != 0) continue;
                this.valid = false;
            }
        }
    }

    void keepThisMemberOnly(QueryElement memberToKeep) {
        if (this.members != null) {
            this.members.clear();
        }
        if (this.except != null) {
            this.except.clear();
        }
        this.addMemberToList(memberToKeep);
    }

    public boolean isValid() {
        return this.valid;
    }

    public LinkedList getMember() {
        if (this.members != null) {
            return this.members;
        }
        return null;
    }
}

