/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BackupFacility {
    private static BackupFacility defaultInstance;

    private BackupFacility() {
    }

    public abstract Handle backup(FileObject ... var1) throws IOException;

    public final Handle backup(Collection<? extends FileObject> collection) throws IOException {
        return this.backup(collection.toArray(new FileObject[collection.size()]));
    }

    public abstract void clear();

    public static BackupFacility getDefault() {
        BackupFacility backupFacility = (BackupFacility)Lookup.getDefault().lookup(BackupFacility.class);
        return backupFacility != null ? backupFacility : BackupFacility.getDefaultInstance();
    }

    private static synchronized BackupFacility getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultImpl();
        }
        return defaultInstance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultHandle
    implements Handle {
        ArrayList<Long> handle;
        DefaultImpl instance;

        private DefaultHandle(DefaultImpl defaultImpl, ArrayList<Long> arrayList) {
            this.handle = arrayList;
            this.instance = defaultImpl;
        }

        @Override
        public void restore() throws IOException {
            for (long l : this.handle) {
                this.instance.restore(l);
            }
        }
    }

    private static class DefaultImpl
    extends BackupFacility {
        private long currentId = 0L;
        private HashMap<Long, BackupEntry> map = new HashMap();

        private DefaultImpl() {
        }

        public Handle backup(FileObject ... fileObjectArray) throws IOException {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (FileObject fileObject : fileObjectArray) {
                arrayList.add(this.backup(fileObject));
            }
            return new DefaultHandle(this, arrayList);
        }

        public long backup(FileObject fileObject) throws IOException {
            try {
                BackupEntry backupEntry = new BackupEntry();
                backupEntry.file = File.createTempFile("nbbackup", null);
                this.copy(FileUtil.toFile((FileObject)fileObject), backupEntry.file);
                backupEntry.path = fileObject.getURL().toURI();
                this.map.put(this.currentId, backupEntry);
                backupEntry.file.deleteOnExit();
                return this.currentId++;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw (IOException)new IOException(fileObject.toString()).initCause(uRISyntaxException);
            }
        }

        void restore(long l) throws IOException {
            BackupEntry backupEntry = this.map.get(l);
            if (backupEntry == null) {
                throw new IllegalArgumentException("Backup with id " + l + "does not exist");
            }
            File file = File.createTempFile("nbbackup", null);
            file.deleteOnExit();
            File file2 = new File(backupEntry.path);
            if (this.createNewFile(file2)) {
                file.createNewFile();
                this.copy(file2, file);
            }
            FileObject fileObject = FileUtil.toFileObject((File)file2);
            this.copy(backupEntry.file, fileObject);
            backupEntry.file.delete();
            if (file.exists()) {
                backupEntry.file = file;
            } else {
                this.map.remove(l);
            }
        }

        private boolean createNewFile(File file) throws IOException {
            if (file.exists()) {
                return true;
            }
            File file2 = file.getParentFile();
            if (file2 != null) {
                this.createNewFolder(file2);
            }
            file.createNewFile();
            return false;
        }

        private void createNewFolder(File file) throws IOException {
            if (!file.exists()) {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    this.createNewFolder(file2);
                }
                file.mkdir();
            }
        }

        private void copy(File file, File file2) throws IOException {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.copy(fileInputStream, fileOutputStream);
        }

        private void copy(File file, FileObject fileObject) throws IOException {
            FileInputStream fileInputStream = new FileInputStream(file);
            OutputStream outputStream = fileObject.getOutputStream();
            this.copy(fileInputStream, outputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                inputStream.close();
                outputStream.close();
            }
        }

        public void clear() {
            for (BackupEntry backupEntry : this.map.values()) {
                backupEntry.file.delete();
            }
            this.map.clear();
        }

        private class BackupEntry {
            private File file;
            private URI path;

            private BackupEntry() {
            }
        }
    }

    public static interface Handle {
        public void restore() throws IOException;
    }
}

