/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

public class LanguagesGenerateFoldPopupAction
extends NbEditorKit.GenerateFoldPopupAction {
    public static final String EXPAND_PREFIX = "Expand:";
    public static final String COLLAPSE_PREFIX = "Collapse:";

    protected void addAdditionalItems(JTextComponent jTextComponent, JMenu jMenu) {
        try {
            String string = (String)jTextComponent.getDocument().getProperty("mimeType");
            Language language = LanguagesManager.getDefault().getLanguage(string);
            HashSet hashSet = new HashSet();
            this.addFoldTypes(jTextComponent, jMenu, language, hashSet);
            Iterator<Language> iterator = language.getImportedLanguages().iterator();
            while (iterator.hasNext()) {
                this.addFoldTypes(jTextComponent, jMenu, iterator.next(), hashSet);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void addFoldTypes(JTextComponent jTextComponent, JMenu jMenu, Language language, Set set) {
        List<Feature> list = language.getFeatures("FOLD");
        for (Feature feature : list) {
            String string = language.localize((String)feature.getValue("expand_type_action_name"));
            if (string == null || set.contains(string)) continue;
            set.add(string);
            String string2 = language.localize((String)feature.getValue("collapse_type_action_name"));
            if (string2 == null) continue;
            this.addAction(jTextComponent, jMenu, EXPAND_PREFIX + string);
            this.addAction(jTextComponent, jMenu, COLLAPSE_PREFIX + string2);
            this.setAddSeparatorBeforeNextAction(true);
        }
    }
}

