/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.JROpenDocumentExporterNature;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.zip.FileBufferedOasisZipEntry;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JROpenDocumentExporter
extends JRAbstractExporter {
    protected static final String ODT_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.odt.";
    protected static final String ODS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.ods.";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String HORIZONTAL_ALIGN_LEFT = "start";
    protected static final String HORIZONTAL_ALIGN_RIGHT = "end";
    protected static final String HORIZONTAL_ALIGN_CENTER = "center";
    protected static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    protected static final String VERTICAL_ALIGN_TOP = "top";
    protected static final String VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected Writer tempBodyWriter = null;
    protected Writer tempStyleWriter = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageMaps;
    protected List imagesToProcess = null;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected int tableIndex = 0;
    protected boolean startPage;
    protected String encoding = null;
    protected boolean isWrapBreakWord = false;
    protected Map fontMap = null;
    protected LinkedList backcolorStack = new LinkedList();
    protected Color backcolor = null;
    private StyleCache styleCache = null;
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;
    protected ExporterNature nature = null;
    protected String exporterPropertiesPrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block21: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(this.exporterPropertiesPrefix);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                this.nature = this.getExporterNature(this.filter);
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToOasisZip(os);
                        break block21;
                    }
                    catch (IOException e) {
                        throw new JRException("Error trying to export to output stream : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToOasisZip(os);
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    public static JRPrintImage getImage(List jasperPrintList, String imageName) {
        return JROpenDocumentExporter.getImage(jasperPrintList, JROpenDocumentExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = (JasperPrint)jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = (JRPrintPage)report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        Object element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    protected void exportReportToOasisZip(OutputStream os) throws JRException, IOException {
        FileBufferedOasisZip oasisZip = new FileBufferedOasisZip(((JROpenDocumentExporterNature)this.nature).getOpenDocumentNature());
        FileBufferedOasisZipEntry tempBodyEntry = new FileBufferedOasisZipEntry(null);
        FileBufferedOasisZipEntry tempStyleEntry = new FileBufferedOasisZipEntry(null);
        this.tempBodyWriter = tempBodyEntry.getWriter();
        this.tempStyleWriter = tempStyleEntry.getWriter();
        this.styleCache = new StyleCache(this.tempStyleWriter, this.fontMap);
        Writer stylesWriter = oasisZip.getStylesEntry().getWriter();
        StyleBuilder styleBuilder = new StyleBuilder(this.jasperPrintList, stylesWriter);
        styleBuilder.build();
        stylesWriter.close();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)pages.get(this.pageIndex);
                    this.exportPage(page);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        ContentBuilder contentBuilder = new ContentBuilder(oasisZip.getContentEntry(), tempStyleEntry, tempBodyEntry, this.styleCache.getFontFaces(), ((JROpenDocumentExporterNature)this.nature).getOpenDocumentNature());
        contentBuilder.build();
        tempStyleEntry.dispose();
        tempBodyEntry.dispose();
        if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
            Iterator it = this.imagesToProcess.iterator();
            while (it.hasNext()) {
                JRPrintElementIndex imageIndex = (JRPrintElementIndex)it.next();
                JRPrintImage image = JROpenDocumentExporter.getImage(this.jasperPrintList, imageIndex);
                JRRenderable renderer = image.getRenderer();
                if (renderer.getType() == 1) {
                    renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
                }
                oasisZip.addEntry(new FileBufferedOasisZipEntry("Pictures/" + JROpenDocumentExporter.getImageName(imageIndex), renderer.getImageData()));
            }
        }
        oasisZip.zipEntries(os);
        oasisZip.dispose();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.startPage = true;
        JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        this.exportGrid(layout, null);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, JRPrintElementIndex frameIndex) throws IOException, JRException {
        CutsInfo xCuts = gridLayout.getXCuts();
        JRExporterGridCell[][] grid = gridLayout.getGrid();
        TableBuilder tableBuilder = frameIndex == null ? new TableBuilder(this.reportIndex, this.pageIndex, this.tempBodyWriter, this.tempStyleWriter) : new TableBuilder(frameIndex.toString(), this.tempBodyWriter, this.tempStyleWriter);
        tableBuilder.buildTableStyle();
        tableBuilder.buildTableHeader();
        for (int col = 1; col < xCuts.size(); ++col) {
            tableBuilder.buildColumnStyle(col - 1, xCuts.getCut(col) - xCuts.getCut(col - 1));
            tableBuilder.buildColumnHeader(col - 1);
            tableBuilder.buildColumnFooter();
        }
        JRPrintElement element = null;
        for (int row = 0; row < grid.length; ++row) {
            int emptyCellColSpan = 0;
            int emptyCellWidth = 0;
            int rowHeight = gridLayout.getRowHeight(row);
            tableBuilder.buildRowStyle(row, rowHeight);
            tableBuilder.buildRowHeader(row);
            for (int col = 0; col < grid[0].length; ++col) {
                JRExporterGridCell gridCell = grid[row][col];
                if (gridCell == JRExporterGridCell.OCCUPIED_CELL) {
                    if (emptyCellColSpan > 0) {
                        this.writeEmptyCell(gridCell, emptyCellColSpan, emptyCellWidth, rowHeight);
                        emptyCellColSpan = 0;
                        emptyCellWidth = 0;
                    }
                    this.writeOccupiedCells(1);
                    continue;
                }
                if (gridCell.getWrapper() != null) {
                    if (emptyCellColSpan > 0) {
                        this.writeEmptyCell(gridCell, emptyCellColSpan, emptyCellWidth, rowHeight);
                        emptyCellColSpan = 0;
                        emptyCellWidth = 0;
                    }
                    if ((element = gridCell.getWrapper().getElement()) instanceof JRPrintLine) {
                        this.exportLine(tableBuilder, (JRPrintLine)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintRectangle) {
                        this.exportRectangle(tableBuilder, (JRPrintRectangle)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintEllipse) {
                        this.exportEllipse(tableBuilder, (JRPrintEllipse)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintImage) {
                        this.exportImage(tableBuilder, (JRPrintImage)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintText) {
                        this.exportText(tableBuilder, (JRPrintText)element, gridCell);
                        continue;
                    }
                    if (!(element instanceof JRPrintFrame)) continue;
                    this.exportFrame(tableBuilder, (JRPrintFrame)element, gridCell);
                    continue;
                }
                ++emptyCellColSpan;
                emptyCellWidth += gridCell.getWidth();
            }
            if (emptyCellColSpan > 0) {
                this.writeEmptyCell(null, emptyCellColSpan, emptyCellWidth, rowHeight);
            }
            tableBuilder.buildRowFooter();
        }
        tableBuilder.buildTableFooter();
    }

    private void writeEmptyCell(JRExporterGridCell gridCell, int emptyCellColSpan, int emptyCellWidth, int rowHeight) throws IOException {
        this.tempBodyWriter.write("<table:table-cell");
        this.tempBodyWriter.write(" table:style-name=\"empty-cell\"");
        if (emptyCellColSpan > 1) {
            this.tempBodyWriter.write(" table:number-columns-spanned=\"" + emptyCellColSpan + "\"");
        }
        this.tempBodyWriter.write("/>\n");
        this.writeOccupiedCells(emptyCellColSpan - 1);
    }

    private void writeOccupiedCells(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.tempBodyWriter.write("<table:covered-table-cell/>\n");
        }
    }

    protected void exportLine(TableBuilder tableBuilder, JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        double y2;
        double x2;
        double y1;
        double x1;
        tableBuilder.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        if (line.getDirection() == 1) {
            x1 = Utility.translatePixelsToInches(0.0);
            y1 = Utility.translatePixelsToInches(0.0);
            x2 = Utility.translatePixelsToInches(line.getWidth() - 1);
            y2 = Utility.translatePixelsToInches(line.getHeight() - 1);
        } else {
            x1 = Utility.translatePixelsToInches(0.0);
            y1 = Utility.translatePixelsToInches(line.getHeight() - 1);
            x2 = Utility.translatePixelsToInches(line.getWidth() - 1);
            y2 = Utility.translatePixelsToInches(0.0);
        }
        this.tempBodyWriter.write("<text:p>");
        this.insertPageAnchor();
        this.tempBodyWriter.write("<draw:line text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(line) + "\" " + "svg:x1=\"" + x1 + "in\" " + "svg:y1=\"" + y1 + "in\" " + "svg:x2=\"" + x2 + "in\" " + "svg:y2=\"" + y2 + "in\">" + "<text:p/></draw:line>" + "</text:p>");
        tableBuilder.buildCellFooter();
    }

    protected void exportRectangle(TableBuilder tableBuilder, JRPrintRectangle rectangle, JRExporterGridCell gridCell) throws IOException {
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(rectangle), gridCell.getColSpan(), gridCell.getRowSpan());
        tableBuilder.buildCellFooter();
    }

    protected void exportEllipse(TableBuilder tableBuilder, JRPrintEllipse ellipse, JRExporterGridCell gridCell) throws IOException {
        tableBuilder.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        this.tempBodyWriter.write("<text:p>");
        this.insertPageAnchor();
        this.tempBodyWriter.write("<draw:ellipse text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(ellipse) + "\" " + "svg:width=\"" + Utility.translatePixelsToInches(ellipse.getWidth()) + "in\" " + "svg:height=\"" + Utility.translatePixelsToInches(ellipse.getHeight()) + "in\" " + "svg:x=\"0in\" " + "svg:y=\"0in\">" + "<text:p/></draw:ellipse></text:p>");
        tableBuilder.buildCellFooter();
    }

    protected void exportText(TableBuilder tableBuilder, JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(text), gridCell.getColSpan(), gridCell.getRowSpan());
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.tempBodyWriter.write("<text:p text:style-name=\"");
        this.tempBodyWriter.write(this.styleCache.getParagraphStyle(text));
        this.tempBodyWriter.write("\">");
        this.insertPageAnchor();
        if (text.getAnchorName() != null) {
            this.tempBodyWriter.write("<text:bookmark text:name=\"");
            this.tempBodyWriter.write(text.getAnchorName());
            this.tempBodyWriter.write("\"/>");
        }
        boolean startedHyperlink = this.startHyperlink(text, true);
        if (textLength > 0) {
            this.exportStyledText(styledText);
        }
        if (startedHyperlink) {
            this.endHyperlink(true);
        }
        this.tempBodyWriter.write("</text:p>\n");
        tableBuilder.buildCellFooter();
    }

    protected void exportStyledText(JRStyledText styledText) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map attributes, String text) throws IOException {
        String textSpanStyleName = this.styleCache.getTextSpanStyle(attributes, text);
        this.tempBodyWriter.write("<text:span");
        this.tempBodyWriter.write(" text:style-name=\"" + textSpanStyleName + "\"");
        this.tempBodyWriter.write(">");
        if (text != null) {
            this.tempBodyWriter.write(Utility.replaceNewLineWithLineBreak(JRStringUtil.xmlEncode(text)));
        }
        this.tempBodyWriter.write("</text:span>");
    }

    protected void exportImage(TableBuilder tableBuilder, JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), Math.round(image.getLineBox().getTopPen().getLineWidth().floatValue()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), Math.round(image.getLineBox().getLeftPen().getLineWidth().floatValue()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), Math.round(image.getLineBox().getBottomPen().getLineWidth().floatValue()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), Math.round(image.getLineBox().getRightPen().getLineWidth().floatValue()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        int width = availableImageWidth;
        int height = availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(image), gridCell.getColSpan(), gridCell.getRowSpan());
        JRRenderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0 && !image.isLazy()) {
                renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, image.getOnErrorType());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            float xalignFactor = this.getXAlignFactor(image);
            float yalignFactor = this.getYAlignFactor(image);
            switch (image.getScaleImage()) {
                case 2: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    xoffset = 0;
                    yoffset = 0;
                    break;
                }
                default: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        JRRenderable tmpRenderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, image.getOnErrorType());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension();
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (availableImageHeight > 0) {
                        double ratio = normalWidth / normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            width = availableImageWidth;
                            height = (int)((double)width / ratio);
                        } else {
                            height = availableImageHeight;
                            width = (int)(ratio * (double)height);
                        }
                    }
                    xoffset = (int)(xalignFactor * (float)(availableImageWidth - width));
                    yoffset = (int)(yalignFactor * (float)(availableImageHeight - height));
                }
            }
            this.tempBodyWriter.write("<text:p>");
            this.insertPageAnchor();
            if (image.getAnchorName() != null) {
                this.tempBodyWriter.write("<text:bookmark text:name=\"");
                this.tempBodyWriter.write(image.getAnchorName());
                this.tempBodyWriter.write("\"/>");
            }
            boolean startedHyperlink = this.startHyperlink(image, false);
            this.tempBodyWriter.write("<draw:frame text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(image) + "\" " + "svg:x=\"" + Utility.translatePixelsToInches(leftPadding + xoffset) + "in\" " + "svg:y=\"" + Utility.translatePixelsToInches(topPadding + yoffset) + "in\" " + "svg:width=\"" + Utility.translatePixelsToInches(width) + "in\" " + "svg:height=\"" + Utility.translatePixelsToInches(height) + "in\">");
            this.tempBodyWriter.write("<draw:image ");
            this.tempBodyWriter.write(" xlink:href=\"" + this.getImagePath(renderer, image.isLazy(), gridCell) + "\"");
            this.tempBodyWriter.write(" xlink:type=\"simple\"");
            this.tempBodyWriter.write(" xlink:show=\"embed\"");
            this.tempBodyWriter.write(" xlink:actuate=\"onLoad\"");
            this.tempBodyWriter.write("/>\n");
            this.tempBodyWriter.write("</draw:frame>");
            if (startedHyperlink) {
                this.endHyperlink(false);
            }
            this.tempBodyWriter.write("</text:p>");
        }
        tableBuilder.buildCellFooter();
    }

    protected String getImagePath(JRRenderable renderer, boolean isLazy, JRExporterGridCell gridCell) throws IOException {
        String imagePath = null;
        if (renderer != null) {
            if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = (String)this.rendererToImagePathMap.get(renderer.getId());
            } else {
                if (isLazy) {
                    imagePath = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                    this.imagesToProcess.add(imageIndex);
                    String imageName = JROpenDocumentExporter.getImageName(imageIndex);
                    imagePath = "Pictures/" + imageName;
                }
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
        }
        return imagePath;
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        return imageIndex;
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(TableBuilder tableBuilder, JRPrintFrame frame, JRExporterGridCell gridCell) throws IOException, JRException {
        boolean appendBackcolor;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(frame), gridCell.getColSpan(), gridCell.getRowSpan());
        boolean bl = appendBackcolor = frame.getMode() == 1 && (this.backcolor == null || frame.getBackcolor().getRGB() != this.backcolor.getRGB());
        if (appendBackcolor) {
            this.setBackcolor(frame.getBackcolor());
        }
        try {
            JRGridLayout layout = gridCell.getLayout();
            JRPrintElementIndex frameIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
            this.exportGrid(layout, frameIndex);
        }
        finally {
            if (appendBackcolor) {
                this.restoreBackcolor();
            }
        }
        tableBuilder.buildCellFooter();
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    private float getXAlignFactor(JRPrintImage image) {
        float xalignFactor = 0.0f;
        switch (image.getHorizontalAlignment()) {
            case 3: {
                xalignFactor = 1.0f;
                break;
            }
            case 2: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage image) {
        float yalignFactor = 0.0f;
        switch (image.getVerticalAlignment()) {
            case 3: {
                yalignFactor = 1.0f;
                break;
            }
            case 2: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            if (isText) {
                this.tempBodyWriter.write("<text:a xlink:href=\"");
            } else {
                this.tempBodyWriter.write("<draw:a xlink:type=\"simple\" xlink:href=\"");
            }
            this.tempBodyWriter.write(href);
            this.tempBodyWriter.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.tempBodyWriter.write(" office:target-frame-name=\"");
                this.tempBodyWriter.write(target);
                this.tempBodyWriter.write("\"");
                if (target.equals("_blank")) {
                    this.tempBodyWriter.write(" xlink:show=\"new\"");
                }
            }
            this.tempBodyWriter.write(">");
        }
        return href != null;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTarget()) {
            case 1: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkType()) {
                    case 2: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 4: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case 5: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case 6: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected JRHyperlinkProducer getCustomHandler(JRPrintHyperlink link) {
        return this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(link.getLinkType());
    }

    protected void endHyperlink(boolean isText) throws IOException {
        if (isText) {
            this.tempBodyWriter.write("</text:a>");
        } else {
            this.tempBodyWriter.write("</draw:a>");
        }
    }

    protected void insertPageAnchor() throws IOException {
        if (this.startPage) {
            this.tempBodyWriter.write("<text:bookmark text:name=\"");
            this.tempBodyWriter.write(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.pageIndex + 1));
            this.tempBodyWriter.write("\"/>\n");
            this.startPage = false;
        }
    }

    protected abstract ExporterNature getExporterNature(ExporterFilter var1);
}

