/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlinkParameter;

public class JRLinkParameterDialog
extends JDialog {
    JRDesignHyperlinkParameter tmpParameter = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ExpressionEditorArea jRTextExpressionAreaDefaultExpression;
    private JTextField jTextFieldName;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_PARAM_NAME = 1;
    public static final int COMPONENT_PARAM_EXPRESSION = 2;

    public JRLinkParameterDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public JRLinkParameterDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.jRTextExpressionAreaDefaultExpression.setText("");
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRLinkParameterDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionAreaDefaultExpression = new ExpressionEditorArea();
        this.setTitle("Add/modify parameter");
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRLinkParameterDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRLinkParameterDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRLinkParameterDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Link parameter name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel3.setText("Value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(300, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setBounds(0, 0, 320, 220);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid parameter name!", "Invalid parameter!", 2);
            return;
        }
        this.tmpParameter = new JRDesignHyperlinkParameter();
        this.tmpParameter.setName(this.jTextFieldName.getText());
        this.tmpParameter.setValueExpression((JRExpression)Misc.createExpression("java.lang.String", this.jRTextExpressionAreaDefaultExpression.getText()));
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRDesignHyperlinkParameter getParameter() {
        return this.tmpParameter;
    }

    public void setParameter(JRDesignHyperlinkParameter tmpParameter) {
        this.jTextFieldName.setText(new String(tmpParameter.getName()));
        this.jRTextExpressionAreaDefaultExpression.setText(Misc.getExpressionText(tmpParameter.getValueExpression()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setFocusedExpression(int expID) {
        try {
            switch (expID) {
                case 2: {
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaDefaultExpression);
                    break;
                }
                case 1: {
                    Misc.selectTextAndFocusArea(this.jTextFieldName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.jRTextExpressionAreaDefaultExpression.setExpressionContext(ec);
    }
}

