/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Container;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.lib.URLMapper;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public final class NbURLMapper
extends URLMapper {
    private static final Logger LOG = Logger.getLogger(NbURLMapper.class.getName());

    protected JTextComponent getTextComponent(URL uRL) {
        FileObject fileObject = org.openide.filesystems.URLMapper.findFileObject((URL)uRL);
        if (fileObject != null) {
            JEditorPane[] jEditorPaneArray;
            EditorCookie editorCookie;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.WARNING, "Can't get DataObject for " + fileObject, dataObjectNotFoundException);
            }
            if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class)) != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null) {
                return jEditorPaneArray[0];
            }
        }
        return null;
    }

    protected URL getUrl(JTextComponent jTextComponent) {
        FileObject fileObject = null;
        if (jTextComponent instanceof Lookup.Provider) {
            fileObject = (FileObject)((Lookup.Provider)jTextComponent).getLookup().lookup(FileObject.class);
        }
        if (fileObject == null) {
            for (Container container = jTextComponent.getParent(); !(container == null || container instanceof Lookup.Provider && (fileObject = (FileObject)((Lookup.Provider)container).getLookup().lookup(FileObject.class)) != null); container = container.getParent()) {
            }
        }
        if (fileObject != null) {
            try {
                return fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOG.log(Level.WARNING, "Can't get URL for " + fileObject, fileStateInvalidException);
            }
        }
        return null;
    }
}

