/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.NetworkProblemPanel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.netbeans.modules.autoupdate.ui.wizards.ValidationWarningPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallStep
implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
    private OperationPanel panel;
    private PanelBodyContainer component;
    private InstallUnitWizardModel model = null;
    private WizardDescriptor wd = null;
    private OperationSupport.Restarter restarter = null;
    private final Logger log = Logger.getLogger("org.netbeans.modules.autoupdate.ui.wizards.InstallPanel");
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static final String HEAD_DOWNLOAD = "InstallStep_Header_Download_Head";
    private static final String CONTENT_DOWNLOAD = "InstallStep_Header_Download_Content";
    private static final String HEAD_VERIFY = "InstallStep_Header_Verify_Head";
    private static final String CONTENT_VERIFY = "InstallStep_Header_Verify_Content";
    private static final String HEAD_INSTALL = "InstallStep_Header_Install_Head";
    private static final String CONTENT_INSTALL = "InstallStep_Header_Install_Content";
    private static final String HEAD_INSTALL_DONE = "InstallStep_Header_InstallDone_Head";
    private static final String CONTENT_INSTALL_DONE = "InstallStep_Header_InstallDone_Content";
    private static final String HEAD_RESTART = "InstallStep_Header_Restart_Head";
    private static final String CONTENT_RESTART = "InstallStep_Header_Restart_Content";
    private boolean wasStored = false;
    private InstallSupport.Validator validator;

    public InstallStep(InstallUnitWizardModel installUnitWizardModel) {
        this.model = installUnitWizardModel;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public PanelBodyContainer getComponent() {
        if (this.component == null) {
            this.panel = new OperationPanel();
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("run-action".equals(propertyChangeEvent.getPropertyName())) {
                        InstallStep.this.doDownloadAndVerificationAndInstall();
                    }
                }
            });
            this.component = new PanelBodyContainer(this.getBundle(HEAD_DOWNLOAD, new Object[0]), this.getBundle(CONTENT_DOWNLOAD, new Object[0]), this.panel);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
        }
        return this.component;
    }

    private void doDownloadAndVerificationAndInstall() {
        InstallSupport.Validator validator = null;
        validator = this.handleDownload();
        if (validator != null) {
            InstallSupport.Installer installer = null;
            installer = this.handleValidation(validator);
            if (installer != null) {
                OperationSupport.Restarter restarter = null;
                restarter = this.handleInstall(installer);
                if (restarter != null) {
                    this.presentInstallNeedsRestart(restarter);
                } else {
                    this.presentInstallDone();
                }
            }
        }
        this.fireChange();
    }

    private InstallSupport.Validator handleDownload() {
        this.validator = null;
        InstallSupport installSupport = this.model.getInstallSupport();
        assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        boolean bl = false;
        while (!bl) {
            bl = this.tryPerformDownload();
        }
        return this.validator;
    }

    private boolean tryPerformDownload() {
        block7: {
            this.validator = null;
            InstallSupport installSupport = this.model.getInstallSupport();
            try {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]));
                JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
                JLabel jLabel2 = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
                progressHandle.setInitialDelay(0);
                this.panel.waitAndSetProgressComponents(jLabel, jComponent, jLabel2);
                this.validator = installSupport.doDownload(progressHandle, Utilities.isGlobalInstallation());
                if (this.validator == null) {
                    return true;
                }
                if (this.model.getAdditionallyInstallSupport() != null) {
                    progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Download_DownloadingPlugins", new Object[0]));
                    ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                    this.validator = this.model.getAdditionallyInstallSupport().doDownload(progressHandle, Utilities.isGlobalInstallation());
                }
                if (this.validator == null) {
                    return true;
                }
                this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(this.getBundle("InstallStep_Done", new Object[0])));
            }
            catch (OperationException operationException) {
                assert (OperationException.ERROR_TYPE.PROXY.equals((Object)operationException.getErrorType()));
                this.log.log(Level.INFO, operationException.getMessage(), operationException);
                JButton jButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)this.getBundle("InstallStep_NetworkProblem_Continue", new Object[0]));
                NetworkProblemPanel networkProblemPanel = new NetworkProblemPanel(this.getBundle("InstallStep_NetworkProblem_Text", operationException.getLocalizedMessage()), jButton, this.model.getCancelButton(this.wd));
                Object object = networkProblemPanel.showNetworkProblemDialog();
                if (jButton.equals(object)) {
                    return false;
                }
                if (!DialogDescriptor.CLOSED_OPTION.equals(object)) break block7;
                this.model.getCancelButton(this.wd).doClick();
            }
        }
        return true;
    }

    private InstallSupport.Installer handleValidation(InstallSupport.Validator validator) {
        Object object;
        Object object2;
        this.component.setHeadAndContent(this.getBundle(HEAD_VERIFY, new Object[0]), this.getBundle(CONTENT_VERIFY, new Object[0]));
        InstallSupport installSupport = this.model.getInstallSupport();
        assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        JLabel jLabel2 = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        progressHandle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, jLabel2);
        InstallSupport.Installer installer = null;
        try {
            installer = installSupport.doValidate(validator, progressHandle);
            if (installer == null) {
                return null;
            }
            if (this.model.getAdditionallyInstallSupport() != null) {
                progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Validate_ValidatingPlugins", new Object[0]));
                ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                installer = this.model.getAdditionallyInstallSupport().doValidate(validator, progressHandle);
            }
            if (installer == null) {
                return null;
            }
        }
        catch (OperationException operationException) {
            this.log.log(Level.INFO, operationException.getMessage(), operationException);
            NetworkProblemPanel networkProblemPanel = new NetworkProblemPanel(operationException.getLocalizedMessage());
            networkProblemPanel.showNetworkProblemDialog();
            this.model.getCancelButton(this.wd).doClick();
            return null;
        }
        InstallSupport.Installer installer2 = installer;
        ArrayList<UpdateElement> arrayList = new ArrayList<UpdateElement>();
        ArrayList<UpdateElement> arrayList2 = new ArrayList<UpdateElement>();
        String string = "";
        for (UpdateElement object3 : this.model.getAllUpdateElements()) {
            object2 = this.model.getAdditionallyInstallSupport();
            if (!(installSupport.isSigned(installer2, object3) || object2 != null && object2.isSigned(installer2, object3))) {
                arrayList.add(object3);
                continue;
            }
            if (installSupport.isTrusted(installer2, object3) || object2 != null && object2.isTrusted(installer2, object3)) continue;
            arrayList2.add(object3);
            object = installSupport.getCertificate(installer2, object3);
            if (object == null || ((String)object).length() <= 0) continue;
            string = string + this.getBundle("ValidationWarningPanel_ShowCertificateFormat", object3.getDisplayName(), object);
        }
        if (arrayList2.size() > 0 || arrayList.size() > 0) {
            ValidationWarningPanel validationWarningPanel = new ValidationWarningPanel(arrayList, arrayList2);
            final JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)this.getBundle("ValidationWarningPanel_ShowCertificateButton", new Object[0]));
            object2 = string;
            jButton.addActionListener(new ActionListener((String)object2){
                final /* synthetic */ String val$certificate;
                {
                    this.val$certificate = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jButton.equals(actionEvent.getSource())) {
                        JTextArea jTextArea = new JTextArea(this.val$certificate);
                        jTextArea.setEditable(false);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)jTextArea));
                    }
                }
            });
            object = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)object, (String)this.getBundle("ValidationWarningPanel_ContinueButton", new Object[0]));
            JButton jButton2 = this.model.getCancelButton(this.wd);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)validationWarningPanel, this.getBundle("ValidationWarningPanel_Title", new Object[0]));
            dialogDescriptor.setOptions((Object[])new JButton[]{object, jButton2});
            dialogDescriptor.setClosingOptions((Object[])new JButton[]{object, jButton2});
            dialogDescriptor.setOptionType(2);
            if (!arrayList2.isEmpty() && string.length() > 0) {
                dialogDescriptor.setAdditionalOptions((Object[])new JButton[]{jButton});
            }
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (!object.equals(dialogDescriptor.getValue())) {
                if (!jButton2.equals(dialogDescriptor.getValue())) {
                    jButton2.doClick();
                }
                return null;
            }
            assert (object.equals(dialogDescriptor.getValue()));
        }
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(this.getBundle("InstallStep_Done", new Object[0])));
        return installer2;
    }

    private OperationSupport.Restarter handleInstall(InstallSupport.Installer installer) {
        this.component.setHeadAndContent(this.getBundle(HEAD_INSTALL, new Object[0]), this.getBundle(CONTENT_INSTALL, new Object[0]));
        InstallSupport installSupport = this.model.getInstallSupport();
        assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
        this.model.modifyOptionsForDisabledCancel(this.wd);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        JLabel jLabel2 = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        progressHandle.setInitialDelay(0);
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, jLabel2);
        OperationSupport.Restarter restarter = null;
        try {
            restarter = installSupport.doInstall(installer, progressHandle);
            if (this.model.getAdditionallyInstallSupport() != null) {
                progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("InstallStep_Install_InstallingPlugins", new Object[0]));
                if (restarter == null) {
                    ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                    restarter = this.model.getAdditionallyInstallSupport().doInstall(installer, progressHandle);
                }
            }
        }
        catch (OperationException operationException) {
            this.log.log(Level.INFO, operationException.getMessage(), operationException);
        }
        this.panel.waitAndSetProgressComponents(jLabel, jComponent, new JLabel(this.getBundle("InstallStep_Done", new Object[0])));
        return restarter;
    }

    private void presentInstallDone() {
        this.component.setHeadAndContent(this.getBundle(HEAD_INSTALL_DONE, new Object[0]), this.getBundle(CONTENT_INSTALL_DONE, new Object[0]));
        this.model.modifyOptionsForDoClose(this.wd);
        this.panel.setBody(this.getBundle("InstallStep_InstallDone_Text", new Object[0]), InstallUnitWizardModel.getVisibleUpdateElements(this.model.getAllUpdateElements(), false, this.model.getOperation()));
    }

    private void presentInstallNeedsRestart(OperationSupport.Restarter restarter) {
        this.component.setHeadAndContent(this.getBundle(HEAD_RESTART, new Object[0]), this.getBundle(CONTENT_RESTART, new Object[0]));
        this.model.modifyOptionsForDoClose(this.wd, true);
        this.restarter = restarter;
        this.panel.setRestartButtonsVisible(true);
        this.panel.setBody(this.getBundle("InstallStep_InstallDone_Text", new Object[0]), InstallUnitWizardModel.getVisibleUpdateElements(this.model.getAllUpdateElements(), false, this.model.getOperation()));
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wd = wizardDescriptor;
        this.wasStored = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        assert (!WizardDescriptor.PREVIOUS_OPTION.equals(wizardDescriptor.getValue())) : "Cannot invoke Back in this case.";
        if (this.wasStored) {
            return;
        }
        this.wasStored = true;
        if (WizardDescriptor.CANCEL_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wizardDescriptor.getValue())) {
            try {
                this.model.doCleanup(true);
                return;
            }
            catch (OperationException operationException) {
                Logger.getLogger(InstallStep.class.getName()).log(Level.INFO, operationException.getMessage(), operationException);
            }
            return;
        }
        if (this.restarter != null) {
            InstallSupport installSupport = this.model.getInstallSupport();
            assert (installSupport != null) : "OperationSupport cannot be null because OperationContainer contains elements: " + this.model.getBaseContainer().listAll() + " and invalid elements " + this.model.getBaseContainer().listInvalid();
            if (this.panel.restartNow()) {
                try {
                    installSupport.doRestart(this.restarter, null);
                    return;
                }
                catch (OperationException operationException) {
                    this.log.log(Level.INFO, operationException.getMessage(), operationException);
                }
                return;
            }
            installSupport.doRestartLater(this.restarter);
            if (this.model.getAdditionallyInstallSupport() != null) {
                this.model.getAdditionallyInstallSupport().doRestartLater(this.restarter);
            }
            try {
                this.model.doCleanup(false);
                return;
            }
            catch (OperationException operationException) {
                this.log.log(Level.INFO, operationException.getMessage(), operationException);
            }
            return;
        }
        try {
            this.model.doCleanup(!WizardDescriptor.FINISH_OPTION.equals(wizardDescriptor.getValue()));
            return;
        }
        catch (OperationException operationException) {
            this.log.log(Level.INFO, operationException.getMessage(), operationException);
        }
    }

    public boolean isValid() {
        return true;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        InstallStep installStep = this;
        synchronized (installStep) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(InstallStep.class, (String)string, (Object[])objectArray);
    }
}

