/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.Action;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public abstract class IOProvider {
    public static IOProvider getDefault() {
        IOProvider iOProvider = (IOProvider)Lookup.getDefault().lookup(IOProvider.class);
        if (iOProvider == null) {
            iOProvider = new Trivial();
        }
        return iOProvider;
    }

    protected IOProvider() {
    }

    public abstract InputOutput getIO(String var1, boolean var2);

    public InputOutput getIO(String string, Action[] actionArray) {
        return this.getIO(string, true);
    }

    public abstract OutputWriter getStdOut();

    private static final class Trivial
    extends IOProvider {
        public InputOutput getIO(String string, boolean bl) {
            return new TrivialIO(string);
        }

        public OutputWriter getStdOut() {
            return new TrivialOW(System.out, "stdout");
        }

        private final class TrivialIO
        implements InputOutput {
            private final String name;
            private Reader in;

            public TrivialIO(String string) {
                this.name = string;
            }

            public Reader getIn() {
                if (this.in == null) {
                    this.in = new BufferedReader(new InputStreamReader(System.in));
                }
                return this.in;
            }

            public OutputWriter getOut() {
                return new TrivialOW(System.out, this.name);
            }

            public OutputWriter getErr() {
                return new TrivialOW(System.err, this.name);
            }

            public Reader flushReader() {
                return this.getIn();
            }

            public boolean isClosed() {
                return false;
            }

            public boolean isErrSeparated() {
                return false;
            }

            public boolean isFocusTaken() {
                return false;
            }

            public void closeInputOutput() {
            }

            public void select() {
            }

            public void setErrSeparated(boolean bl) {
            }

            public void setErrVisible(boolean bl) {
            }

            public void setFocusTaken(boolean bl) {
            }

            public void setInputVisible(boolean bl) {
            }

            public void setOutputVisible(boolean bl) {
            }
        }

        private static final class TrivialOW
        extends OutputWriter {
            private static int count = 0;
            private final String name;
            private final PrintStream stream;

            public TrivialOW(PrintStream printStream, String string) {
                super(new StringWriter());
                this.stream = printStream;
                this.name = string != null ? string : "anon-" + ++count;
            }

            private void prefix(boolean bl) {
                if (bl) {
                    this.stream.print("[" + this.name + "]* ");
                } else {
                    this.stream.print("[" + this.name + "]  ");
                }
            }

            public void println(String string, OutputListener outputListener) throws IOException {
                this.prefix(outputListener != null);
                this.stream.println(string);
            }

            public void reset() throws IOException {
            }

            public void println(float f) {
                this.prefix(false);
                this.stream.println(f);
            }

            public void println(double d) {
                this.prefix(false);
                this.stream.println(d);
            }

            public void println() {
                this.prefix(false);
                this.stream.println();
            }

            public void println(Object object) {
                this.prefix(false);
                this.stream.println(object);
            }

            public void println(int n) {
                this.prefix(false);
                this.stream.println(n);
            }

            public void println(char c) {
                this.prefix(false);
                this.stream.println(c);
            }

            public void println(long l) {
                this.prefix(false);
                this.stream.println(l);
            }

            public void println(char[] cArray) {
                this.prefix(false);
                this.stream.println(cArray);
            }

            public void println(boolean bl) {
                this.prefix(false);
                this.stream.println(bl);
            }

            public void println(String string) {
                this.prefix(false);
                this.stream.println(string);
            }
        }
    }
}

