/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettingsType
extends Enum<SettingsType> {
    public static final /* enum */ SettingsType FONTSCOLORS = new SettingsType("FontsColors", true, FontColorSettings.class, "text/x-nbeditor-fontcolorsettings", null);
    public static final /* enum */ SettingsType KEYBINDINGS = new SettingsType("Keybindings", true, KeyBindingSettings.class, "text/x-nbeditor-keybindingsettings", "keybindings.xml");
    public static final /* enum */ SettingsType CODETEMPLATES = new SettingsType("CodeTemplates", false, CodeTemplateSettings.class, "text/x-nbeditor-codetemplatesettings", "abbreviations.xml");
    private static final Logger LOG;
    private final String settingsTypeId;
    private final boolean usesProfiles;
    private final Class apiClass;
    private final String mimeType;
    private Locator locator;
    private final String legacyFileName;
    private static final /* synthetic */ SettingsType[] $VALUES;

    public static final SettingsType[] values() {
        return (SettingsType[])$VALUES.clone();
    }

    public static SettingsType valueOf(String string) {
        return Enum.valueOf(SettingsType.class, string);
    }

    public static SettingsType get(Class clazz) {
        assert (clazz != null) : "The parameter apiClass can't be null";
        for (SettingsType settingsType : SettingsType.values()) {
            if (!settingsType.apiClass.equals(clazz)) continue;
            return settingsType;
        }
        return null;
    }

    private SettingsType(String string2, boolean bl, Class clazz, String string3, String string4) {
        this.settingsTypeId = string2;
        this.usesProfiles = bl;
        this.apiClass = clazz;
        this.mimeType = string3;
        this.legacyFileName = string4;
    }

    public String getId() {
        return this.settingsTypeId;
    }

    public boolean isUsingProfiles() {
        return this.usesProfiles;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Locator getLocator() {
        if (this.locator == null) {
            switch (this) {
                case FONTSCOLORS: {
                    this.locator = new FontsColorsLocator();
                    break;
                }
                case KEYBINDINGS: {
                    this.locator = new KeybindingsLocator();
                    break;
                }
                default: {
                    this.locator = new DefaultLocator(this);
                }
            }
        }
        return this.locator;
    }

    public String getLegacyFileName() {
        return this.legacyFileName;
    }

    static {
        $VALUES = new SettingsType[]{FONTSCOLORS, KEYBINDINGS, CODETEMPLATES};
        LOG = Logger.getLogger(SettingsType.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultLocator
    implements Locator {
        protected static final String MODULE_FILES_FOLDER = "Defaults";
        protected static final String DEFAULT_PROFILE_NAME = "NetBeans";
        private static final String WRITABLE_FILE_PREFIX = "org-netbeans-modules-editor-settings-Custom";
        private static final String WRITABLE_FILE_SUFFIX = ".xml";
        private static final String FA_TARGET_OS = "nbeditor-settings-targetOS";
        private final SettingsType settingType;
        private final String writableFilePrefix;
        private final String modulesWritableFilePrefix;

        public DefaultLocator(SettingsType settingsType) {
            assert (settingsType != null) : "The parameter settingType can't be null";
            this.settingType = settingsType;
            this.writableFilePrefix = WRITABLE_FILE_PREFIX + settingsType.getId();
            this.modulesWritableFilePrefix = "Defaults/" + this.writableFilePrefix;
        }

        @Override
        public final void scan(FileObject fileObject, String string, String string2, boolean bl, boolean bl2, boolean bl3, Map<String, List<Object[]>> map) {
            assert (map != null) : "The parameter results can't be null";
            FileObject fileObject2 = null;
            FileObject fileObject3 = null;
            if (fileObject != null) {
                fileObject2 = this.getMimeFolder(fileObject, string);
                fileObject3 = this.getLegacyMimeFolder(fileObject, string);
            }
            if (bl2) {
                if (fileObject3 != null && fileObject3.isFolder()) {
                    this.addModulesLegacyFiles(fileObject3, string2, bl, map);
                }
                if (fileObject2 != null && fileObject2.isFolder()) {
                    this.addModulesFiles(fileObject2, string2, bl, map);
                }
            }
            if (bl3) {
                if (fileObject3 != null && fileObject3.isFolder()) {
                    this.addUsersLegacyFiles(fileObject3, string2, bl, map);
                }
                if (fileObject2 != null && fileObject2.isFolder()) {
                    this.addUsersFiles(fileObject2, string2, bl, map);
                }
            }
        }

        @Override
        public final String getWritableFileName(String string, String string2, String string3, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(127);
            if (string == null || string.length() == 0) {
                stringBuilder.append(this.settingType.getId()).append('/');
            } else {
                stringBuilder.append(string).append('/').append(this.settingType.getId()).append('/');
            }
            if (this.settingType.isUsingProfiles()) {
                assert (string2 != null) : "The profileId parameter must not be null";
                stringBuilder.append(string2).append('/');
            }
            if (bl) {
                stringBuilder.append(this.modulesWritableFilePrefix);
            } else {
                stringBuilder.append(this.writableFilePrefix);
            }
            if (string3 != null && string3.length() != 0) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(WRITABLE_FILE_SUFFIX);
            return stringBuilder.toString();
        }

        protected FileObject getLegacyMimeFolder(FileObject fileObject, String string) {
            return string == null ? fileObject : fileObject.getFileObject(string);
        }

        protected void addModulesLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            if (this.settingType.getLegacyFileName() != null) {
                this.addLegacyFiles(fileObject, string, "Defaults/" + this.settingType.getLegacyFileName(), map, true);
            }
        }

        protected void addUsersLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            if (this.settingType.getLegacyFileName() != null) {
                this.addLegacyFiles(fileObject, string, this.settingType.getLegacyFileName(), map, true);
            }
        }

        private FileObject getMimeFolder(FileObject fileObject, String string) {
            return string == null ? fileObject : fileObject.getFileObject(string);
        }

        private void addModulesFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            if (string == null) {
                FileObject fileObject2 = fileObject.getFileObject(this.settingType.getId());
                if (fileObject2 != null && fileObject2.isFolder()) {
                    if (this.settingType.isUsingProfiles()) {
                        FileObject[] fileObjectArray;
                        for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
                            if (!fileObject3.isFolder()) continue;
                            String string2 = fileObject3.getNameExt();
                            FileObject fileObject4 = fileObject3.getFileObject(MODULE_FILES_FOLDER);
                            if (fileObject4 == null || !fileObject4.isFolder()) continue;
                            this.addFiles(fileObject4, bl, map, string2, fileObject3, true);
                        }
                    } else {
                        FileObject fileObject5 = fileObject2.getFileObject(MODULE_FILES_FOLDER);
                        if (fileObject5 != null && fileObject5.isFolder()) {
                            this.addFiles(fileObject5, bl, map, null, null, true);
                        }
                    }
                }
            } else {
                FileObject fileObject6 = fileObject.getFileObject(this.settingType.getId() + "/" + string + "/" + MODULE_FILES_FOLDER);
                if (fileObject6 != null && fileObject6.isFolder()) {
                    this.addFiles(fileObject6, bl, map, string, fileObject6.getParent(), true);
                }
            }
        }

        private void addUsersFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            if (string == null) {
                FileObject fileObject2 = fileObject.getFileObject(this.settingType.getId());
                if (fileObject2 != null && fileObject2.isFolder()) {
                    if (this.settingType.isUsingProfiles()) {
                        FileObject[] fileObjectArray;
                        for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
                            if (!fileObject3.isFolder()) continue;
                            String string2 = fileObject3.getNameExt();
                            this.addFiles(fileObject3, bl, map, string2, fileObject3, false);
                        }
                    } else {
                        this.addFiles(fileObject2, bl, map, null, null, false);
                    }
                }
            } else {
                FileObject fileObject4 = fileObject.getFileObject(this.settingType.getId() + "/" + string);
                if (fileObject4 != null && fileObject4.isFolder()) {
                    this.addFiles(fileObject4, bl, map, string, fileObject4, false);
                }
            }
        }

        private final void addFiles(FileObject fileObject, boolean bl, Map<String, List<Object[]>> map, String string, FileObject fileObject2, boolean bl2) {
            Object object;
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
            FileObject[] fileObjectArray = DefaultLocator.getOrderedChildren(fileObject);
            for (FileObject fileObject3 : fileObjectArray) {
                if (!fileObject3.isData()) continue;
                if (fileObject3.getMIMEType().equals(this.settingType.getMimeType())) {
                    List<Object[]> list;
                    Object object2;
                    block15: {
                        object2 = fileObject3.getAttribute(FA_TARGET_OS);
                        if (object2 != null) {
                            try {
                                if (!this.isApplicableForThisTargetOs(object2)) {
                                    LOG.fine("Ignoring OS specific file: '" + fileObject3.getPath() + "', it's targetted for '" + object2 + "'");
                                }
                                break block15;
                            }
                            catch (Exception exception) {
                                LOG.log(Level.WARNING, "Ignoring editor settings file with invalid OS type mask '" + object2 + "' file: '" + fileObject3.getPath() + "'");
                            }
                            continue;
                        }
                    }
                    if ((list = map.get(string)) == null) {
                        list = new ArrayList<Object[]>();
                        map.put(string, list);
                    }
                    Object[] objectArray = new Object[]{fileObject2, fileObject3, bl2};
                    if (bl2) {
                        if (fileObject3.getNameExt().startsWith(this.writableFilePrefix)) {
                            arrayList.add(objectArray);
                        } else if (object2 != null) {
                            arrayList2.add(objectArray);
                        } else {
                            list.add(objectArray);
                        }
                    } else {
                        list.add(objectArray);
                    }
                    if (bl) continue;
                    break;
                }
                LOG.fine("Ignoring file: '" + fileObject3.getPath() + "' of type " + fileObject3.getMIMEType());
            }
            if (!arrayList2.isEmpty()) {
                object = map.get(string);
                object.addAll(arrayList2);
            }
            if (!arrayList.isEmpty()) {
                object = map.get(string);
                object.addAll(arrayList);
            }
        }

        private boolean isApplicableForThisTargetOs(Object object) throws NoSuchFieldException, IllegalAccessException {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                Field field = Utilities.class.getDeclaredField((String)object);
                int n = field.getInt(null);
                int n2 = Utilities.getOperatingSystem();
                return (n2 & n) != 0;
            }
            return false;
        }

        protected static FileObject[] getOrderedChildren(FileObject fileObject) {
            Object object2;
            HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>();
            for (Object object2 : fileObject.getChildren()) {
                String string = object2.getNameExt();
                hashMap.put(string, (FileObject)object2);
            }
            HashMap hashMap2 = new HashMap();
            Object object3 = fileObject.getAttributes();
            while (object3.hasMoreElements()) {
                String string;
                String string2 = (String)object3.nextElement();
                object2 = fileObject.getAttribute(string2);
                int n = string2.indexOf(47);
                if (n == -1 || !(object2 instanceof Boolean)) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (!((Boolean)object2).booleanValue()) {
                    string = string3;
                    string3 = string4;
                    string4 = string;
                }
                string = (FileObject)hashMap.get(string3);
                FileObject fileObject2 = (FileObject)hashMap.get(string4);
                if (string == null || fileObject2 == null) continue;
                HashSet<FileObject> hashSet = (HashSet<FileObject>)hashMap2.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<FileObject>();
                    hashMap2.put(string, hashSet);
                }
                hashSet.add(fileObject2);
            }
            try {
                object3 = Utilities.topologicalSort(hashMap.values(), (Map)hashMap2);
            }
            catch (TopologicalSortException topologicalSortException) {
                LOG.log(Level.WARNING, "Can't sort folder children.", topologicalSortException);
                object2 = topologicalSortException.partialSort();
                object3 = object2;
            }
            return object3.toArray(new FileObject[object3.size()]);
        }

        private void addLegacyFiles(FileObject fileObject, String string, String string2, Map<String, List<Object[]>> map, boolean bl) {
            if (string == null) {
                String string3;
                FileObject fileObject2;
                if (this.settingType.isUsingProfiles()) {
                    for (FileObject fileObject3 : fileObject2 = fileObject.getChildren()) {
                        if (!fileObject3.isFolder() || fileObject3.getNameExt().equals(MODULE_FILES_FOLDER)) continue;
                        String string4 = fileObject3.getNameExt();
                        FileObject fileObject4 = fileObject3.getFileObject(string2);
                        if (fileObject4 == null) continue;
                        this.addFile(fileObject4, map, string4, fileObject3, true);
                    }
                    string3 = DEFAULT_PROFILE_NAME;
                } else {
                    string3 = null;
                }
                fileObject2 = fileObject.getFileObject(string2);
                if (fileObject2 != null) {
                    this.addFile(fileObject2, map, string3, null, true);
                }
            } else if (string.equals(DEFAULT_PROFILE_NAME)) {
                FileObject fileObject5 = fileObject.getFileObject(string2);
                if (fileObject5 != null) {
                    this.addFile(fileObject5, map, string, null, bl);
                }
            } else {
                FileObject fileObject6;
                FileObject fileObject7 = fileObject.getFileObject(string);
                if (fileObject7 != null && fileObject7.isFolder() && (fileObject6 = fileObject7.getFileObject(string2)) != null) {
                    this.addFile(fileObject6, map, string, fileObject7, bl);
                }
            }
        }

        private void addFile(FileObject fileObject, Map<String, List<Object[]>> map, String string, FileObject fileObject2, boolean bl) {
            List<Object[]> list = map.get(string);
            if (list == null) {
                list = new ArrayList<Object[]>();
                map.put(string, list);
            }
            list.add(new Object[]{fileObject2, fileObject, bl});
            if (LOG.isLoggable(Level.INFO)) {
                Utils.logOnce(LOG, Level.INFO, this.settingType.getId() + " settings " + "should reside in '" + this.settingType.getId() + "' subfolder, " + "see #90403 for details. Offending file '" + fileObject.getPath() + "'", null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FontsColorsLocator
    extends DefaultLocator {
        private static final String[] M_LEGACY_FILE_NAMES = new String[]{"Defaults/defaultColoring.xml", "Defaults/coloring.xml", "Defaults/editorColoring.xml"};
        private static final String[] U_LEGACY_FILE_NAMES = new String[]{"defaultColoring.xml", "coloring.xml", "editorColoring.xml"};

        public FontsColorsLocator() {
            super(FONTSCOLORS);
        }

        @Override
        protected void addModulesLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            this.addFiles(fileObject, string, bl, M_LEGACY_FILE_NAMES, map, true);
        }

        @Override
        protected void addUsersLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            this.addFiles(fileObject, string, bl, U_LEGACY_FILE_NAMES, map, false);
        }

        private void addFiles(FileObject fileObject, String string, boolean bl, String[] stringArray, Map<String, List<Object[]>> map, boolean bl2) {
            if (string == null) {
                FileObject[] fileObjectArray;
                for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                    if (!fileObject2.isFolder()) continue;
                    String string2 = fileObject2.getNameExt();
                    this.addFiles(fileObject2, stringArray, bl, map, string2, fileObject2, bl2);
                }
            } else {
                FileObject fileObject3 = fileObject.getFileObject(string);
                if (fileObject3 != null && fileObject3.isFolder()) {
                    this.addFiles(fileObject3, stringArray, bl, map, string, fileObject3, bl2);
                }
            }
        }

        private void addFiles(FileObject fileObject, String[] stringArray, boolean bl, Map<String, List<Object[]>> map, String string, FileObject fileObject2, boolean bl2) {
            for (String string2 : stringArray) {
                FileObject fileObject3 = fileObject.getFileObject(string2);
                if (fileObject3 == null) continue;
                List<Object[]> list = map.get(string);
                if (list == null) {
                    list = new ArrayList<Object[]>();
                    map.put(string, list);
                }
                list.add(new Object[]{fileObject2, fileObject3, bl2});
                if (LOG.isLoggable(Level.INFO)) {
                    Utils.logOnce(LOG, Level.INFO, FONTSCOLORS.getId() + " settings " + "should reside in '" + FONTSCOLORS.getId() + "' subfolder, " + "see #90403 for details. Offending file '" + fileObject3.getPath() + "'", null);
                }
                if (!bl) break;
            }
        }
    }

    private static final class KeybindingsLocator
    extends DefaultLocator {
        public KeybindingsLocator() {
            super(KEYBINDINGS);
        }

        protected FileObject getLegacyMimeFolder(FileObject fileObject, String string) {
            if (string == null || string.length() == 0) {
                return fileObject.getFileObject("text/base");
            }
            return ((DefaultLocator)this).getMimeFolder(fileObject, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Locator {
        public void scan(FileObject var1, String var2, String var3, boolean var4, boolean var5, boolean var6, Map<String, List<Object[]>> var7);

        public String getWritableFileName(String var1, String var2, String var3, boolean var4);
    }
}

