/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogCache;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogParser;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateCatalogProvider
implements UpdateProvider {
    private URL updateCenter;
    private String codeName;
    private String displayName;
    private AutoupdateCatalogCache cache = AutoupdateCatalogCache.getDefault();
    private Logger log = Logger.getLogger("org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalog");
    private String description = null;
    private UpdateUnitProvider.CATEGORY category = null;

    public AutoupdateCatalogProvider(String string, String string2, URL uRL) {
        this(string, string2, uRL, UpdateUnitProvider.CATEGORY.COMMUNITY);
    }

    public AutoupdateCatalogProvider(String string, String string2, URL uRL, UpdateUnitProvider.CATEGORY cATEGORY) {
        this.codeName = string;
        this.displayName = string2;
        this.updateCenter = uRL;
        this.category = cATEGORY != null ? cATEGORY : UpdateUnitProvider.CATEGORY.COMMUNITY;
    }

    @Override
    public String getName() {
        assert (this.codeName != null) : "UpdatesProvider must have a name.";
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.codeName : this.displayName;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            URL uRL = this.cache.getCatalogURL(this.codeName);
            if (uRL == null) {
                return null;
            }
            this.description = AutoupdateCatalogParser.getNotification(uRL, this.getUpdateCenterURL());
        }
        return this.description;
    }

    @Override
    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        URL uRL = this.cache.getCatalogURL(this.codeName);
        if (uRL == null) {
            this.log.log(Level.INFO, "No content in cache for " + this.codeName + " provider. Returns EMPTY_MAP");
            return Collections.emptyMap();
        }
        return AutoupdateCatalogParser.getUpdateItems(uRL, this.getUpdateCenterURL());
    }

    @Override
    public boolean refresh(boolean bl) throws IOException {
        boolean bl2 = false;
        this.log.log(Level.FINER, "Try write(force? " + bl + ") to cache Update Provider " + this.codeName + " from " + this.getUpdateCenterURL());
        if (bl) {
            bl2 = this.cache.writeCatalogToCache(this.codeName, this.getUpdateCenterURL()) != null;
            this.description = null;
        } else {
            bl2 = true;
        }
        return bl2;
    }

    public URL getUpdateCenterURL() {
        assert (this.updateCenter != null) : "XMLCatalogUpdatesProvider " + this.codeName + " must have a URL to Update Center";
        return this.updateCenter;
    }

    public void setUpdateCenterURL(URL uRL) {
        assert (uRL != null);
        this.updateCenter = uRL;
    }

    public String toString() {
        return this.displayName + "[" + this.codeName + "] to " + this.updateCenter;
    }

    @Override
    public UpdateUnitProvider.CATEGORY getCategory() {
        return this.category;
    }
}

