/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.formatting.actions;

import com.jaspersoft.ireport.designer.formatting.actions.AbstractFormattingToolAction;
import java.awt.Rectangle;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;

public class AlignVAxisAction
extends AbstractFormattingToolAction {
    public AlignVAxisAction() {
        this.putValue("Name", this.getName());
    }

    protected String iconResource() {
        return "com/jaspersoft/ireport/designer/resources/formatting/center_v.png";
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        JasperDesign jd = (JasperDesign)nodes[0].getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        List<JRDesignElement> elements = this.getSelectedElements(nodes);
        boolean aggregate = false;
        JRDesignElement masterElement = elements.get(0);
        int axis = masterElement.getX() + masterElement.getWidth() / 2;
        for (JRDesignElement element : elements) {
            Rectangle oldBounds = this.getElementBounds(element);
            element.setX(axis - element.getWidth() / 2);
            aggregate = this.addTransformationUndo(element, oldBounds, aggregate);
        }
    }

    public String getName() {
        return "Align Vertical Axes";
    }

    public boolean requiresMultipleObjects() {
        return true;
    }
}

