/*
 * Decompiled with CFR 0.152.
 */
package rex.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;

public class LocaleOptionPane
extends JMenu {
    private ButtonGroup group = new ButtonGroup();
    private Locale currentLocale;
    private Document document;

    public LocaleOptionPane() {
        super("Set Locale");
        this.generateLocaleMenu();
    }

    public void generateLocaleMenu() {
        String defaultLocale = this.setDefaultMenu();
        List list = LocaleOptionPane.getListOfAvailLanguages();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            final Locale temp = (Locale)it.next();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(temp.getDisplayLanguage() + " " + temp.getDisplayCountry());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent h) {
                    LocaleOptionPane.this.setNewLocale(temp);
                }
            });
            this.group.add(item);
            this.add(item);
            if (!defaultLocale.trim().equalsIgnoreCase((temp.getDisplayLanguage() + " " + temp.getDisplayCountry()).trim())) continue;
            item.setSelected(true);
            this.setNewLocale(temp);
        }
    }

    public String setDefaultMenu() {
        String lastLocaleLanguage = "";
        String lastLocaleCountry = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                this.document = builder.parse(new File("mdxeditor.defaults.xml"));
            }
            catch (Exception ioe) {
                // empty catch block
            }
            NodeList nl = this.document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeName().equalsIgnoreCase("LOCALE_LANGUAGE")) {
                    lastLocaleLanguage = new String(DOM.getTextFromDOMElement(nl.item(i)));
                    continue;
                }
                if (!nl.item(i).getNodeName().equalsIgnoreCase("LOCALE_COUNTRY")) continue;
                lastLocaleCountry = new String(DOM.getTextFromDOMElement(nl.item(i)));
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return "";
        }
        return lastLocaleLanguage + " " + lastLocaleCountry;
    }

    public static Set getResoucesInPackage(String packageName) throws IOException {
        String localPackageName = packageName.endsWith("/") ? packageName : packageName + '/';
        Enumeration<URL> dirEnum = ClassLoader.getSystemResources(localPackageName);
        HashSet<String> names = new HashSet<String>();
        while (dirEnum.hasMoreElements()) {
            URL resUrl = dirEnum.nextElement();
            if (resUrl.getProtocol().equals("file")) {
                try {
                    File dir = new File(new URI(resUrl.toString()).getPath());
                    File[] files = dir.listFiles();
                    if (files == null) continue;
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory() || !file.getName().startsWith("Rex")) continue;
                        names.add(localPackageName + file.getName());
                    }
                    continue;
                }
                catch (Exception ex) {
                    continue;
                }
            }
            if (!resUrl.getProtocol().equals("jar")) continue;
            JarURLConnection jconn = (JarURLConnection)resUrl.openConnection();
            JarFile jfile = jconn.getJarFile();
            Enumeration<JarEntry> entryEnum = jfile.entries();
            while (entryEnum.hasMoreElements()) {
                String parentDirName;
                JarEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                if (entryName.equals(localPackageName) || !(parentDirName = entryName.substring(0, entryName.lastIndexOf(47) + 1)).equals(localPackageName)) continue;
                names.add(entryName);
            }
        }
        return names;
    }

    public static List getListOfAvailLanguages() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        try {
            Set names = LocaleOptionPane.getResoucesInPackage("rex/locale/");
            Iterator it = names.iterator();
            while (it.hasNext()) {
                StringTokenizer tokenizer;
                String n = (String)it.next();
                String lang = n.substring(n.lastIndexOf(47) + 1);
                if (lang.indexOf(".properties") < 0 || (tokenizer = new StringTokenizer(lang = lang.substring(0, lang.indexOf(".properties")), "_")).countTokens() <= 1) continue;
                String language = "";
                String country = "";
                String variant = "";
                String[] parts = new String[tokenizer.countTokens()];
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    switch (i) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            language = token;
                            break;
                        }
                        case 2: {
                            country = token;
                            break;
                        }
                        case 3: {
                            variant = token;
                            break;
                        }
                    }
                    ++i;
                }
                Locale model = new Locale(language, country, variant);
                supportedLocales.add(model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return supportedLocales;
    }

    private void setNewLocale(Locale strLanguage) {
        I18n.setCurrentLocale(strLanguage);
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale current) {
        this.currentLocale = current;
        String currentName = current.getDisplayLanguage();
        currentName = currentName + " " + current.getDisplayCountry();
        Enumeration<AbstractButton> localeElements = this.group.getElements();
        while (localeElements.hasMoreElements()) {
            JRadioButtonMenuItem tempItem = (JRadioButtonMenuItem)localeElements.nextElement();
            if (!currentName.trim().equalsIgnoreCase(tempItem.getText().trim())) continue;
            tempItem.setSelected(true);
            break;
        }
        this.saveLocale(this.currentLocale);
    }

    public void saveLocale(Locale locale) {
        Node n = DOM.getFirstChildNodeWithName(this.document.getDocumentElement(), "LOCALE_LANGUAGE");
        try {
            n.removeChild(n.getChildNodes().item(0));
            n.appendChild(this.document.createTextNode(locale.getDisplayLanguage().length() > 0 ? locale.getDisplayLanguage() : " "));
        }
        catch (Exception exc) {
            n.appendChild(this.document.createTextNode(locale.getDisplayLanguage().length() > 0 ? locale.getDisplayLanguage() : " "));
        }
        n = DOM.getFirstChildNodeWithName(this.document.getDocumentElement(), "LOCALE_COUNTRY");
        try {
            n.removeChild(n.getChildNodes().item(0));
            n.appendChild(this.document.createTextNode(locale.getDisplayCountry().length() > 0 ? locale.getDisplayCountry() : " "));
        }
        catch (Exception exc) {
            n.appendChild(this.document.createTextNode(locale.getDisplayCountry().length() > 0 ? locale.getDisplayCountry() : " "));
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(new BufferedWriter(new FileWriter(new File("mdxeditor.defaults.xml"))));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            S.out("Unable to save defaults:");
        }
    }
}

