/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.olap;

import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.OLAPQueryExecuter;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.OlapTreeCellRenderer;
import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.WalkableWrapper;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Result;
import net.sf.jasperreports.engine.design.JRDesignField;

public class OlapBrowser
extends JPanel
implements FieldsProviderEditor {
    private JTable jTableFields = null;
    private ReportQueryDialog reportQueryDialog = null;
    String r_level = "";
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldExpression;
    private JTextField jTextFieldName;
    private JTree jTree1;
    int lastExecution = 0;

    public OlapBrowser() {
        this.initComponents();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.jTree1.setModel(new DefaultTreeModel(root));
        this.jTree1.setCellRenderer(new OlapTreeCellRenderer());
        this.jComboBoxType.addItem(new Tag("java.lang.String", I18n.getString("OlapBrowser.ComboBox.Text")));
        this.jComboBoxType.addItem(new Tag("java.lang.Number", I18n.getString("OlapBrowser.ComboBox.Numeric")));
        this.jComboBoxType.addItem(new Tag("java.util.Date", I18n.getString("Global.List.Date")));
        this.jComboBoxType.addItem(new Tag("java.util.Date", I18n.getString("OlapBrowser.ComboBox.Boolean")));
        this.jComboBoxType.setSelectedIndex(0);
        ((DefaultTreeSelectionModel)this.jTree1.getSelectionModel()).setSelectionMode(1);
    }

    public void setOlapQuery(Query query) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.jTree1.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        root.removeAllChildren();
        if (query == null) {
            this.jTree1.updateUI();
            return;
        }
        QueryAxis[] axes = query.getAxes();
        Hierarchy[][] queryHierarchies = new Hierarchy[axes.length][];
        int[][] fieldsMaxDepths = new int[axes.length][];
        int[][] maxDepths = new int[axes.length][];
        int hCount = 0;
        for (int i = 0; i < axes.length; ++i) {
            queryHierarchies[i] = query.getMdxHierarchiesOnAxis(AxisOrdinal.forLogicalOrdinal((int)i));
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new WalkableWrapper(axes[i], root));
            if (queryHierarchies[i].length == 1 && queryHierarchies[i][0].getDimension().isMeasures()) {
                this.addChildren(childNode, axes[i].getChildren());
            } else {
                this.addChildren(childNode, queryHierarchies[i]);
            }
            root.add(childNode);
            hCount += queryHierarchies[i].length;
            fieldsMaxDepths[i] = new int[queryHierarchies[i].length];
            maxDepths[i] = new int[queryHierarchies[i].length];
        }
        this.jTree1.updateUI();
    }

    public void setOlapResult2(Result result) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.jTree1.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        root.removeAllChildren();
        if (result == null) {
            this.jTree1.updateUI();
            return;
        }
        QueryAxis[] axis = result.getQuery().getAxes();
        Axis[] raxis = result.getAxes();
        for (int i = 0; i < axis.length; ++i) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new WalkableWrapper(axis[i], root));
            this.addChildren(childNode, axis[i].getChildren());
            root.add(childNode);
        }
        this.jTree1.updateUI();
    }

    public void setOlapResultDataXXX(Result result) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.jTree1.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        root.removeAllChildren();
        if (result == null) {
            this.jTree1.updateUI();
            return;
        }
        QueryAxis[] axis = result.getQuery().getAxes();
        Axis[] raxis = result.getAxes();
        for (int i = 0; i < axis.length; ++i) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new WalkableWrapper(axis[i], root));
            Object[] positions = raxis[i].getPositions().toArray();
            this.addChildren(childNode, positions);
            root.add(childNode);
        }
        this.jTree1.updateUI();
    }

    public void addChildren(DefaultMutableTreeNode node, Object[] children) {
        if (children == null) {
            return;
        }
        this.r_level = this.r_level + "__";
        for (int i = 0; i < children.length; ++i) {
            DefaultMutableTreeNode childNode;
            if (children[i] instanceof MemberExpr) {
                childNode = new DefaultMutableTreeNode(new WalkableWrapper(((MemberExpr)children[i]).getMember(), node));
                node.add(childNode);
                continue;
            }
            if (children[i] instanceof ResolvedFunCall) {
                this.addChildren(node, ((ResolvedFunCall)children[i]).getChildren());
                continue;
            }
            if (children[i] instanceof QueryPart) {
                this.addChildren(node, ((QueryPart)children[i]).getChildren());
                continue;
            }
            if (children[i] instanceof QueryPart) {
                this.addChildren(node, ((QueryPart)children[i]).getChildren());
                continue;
            }
            if (children[i] instanceof Hierarchy) {
                childNode = new DefaultMutableTreeNode(new WalkableWrapper(children[i], node));
                this.addChildren(childNode, ((Hierarchy)children[i]).getLevels());
                node.add(childNode);
                continue;
            }
            if (!(children[i] instanceof Level)) continue;
            childNode = new DefaultMutableTreeNode(new WalkableWrapper(children[i], node));
            node.add(childNode);
        }
        this.r_level = this.r_level.substring(0, this.r_level.length() - 2);
    }

    public JTable getJTableFields() {
        return this.jTableFields;
    }

    public void setJTableFields(JTable jTableFields) {
        this.jTableFields = jTableFields;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jLabel4 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextFieldExpression = new JTextField();
        this.jPanel2 = new JPanel();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.setMinimumSize(new Dimension(250, 85));
        this.setPreferredSize(new Dimension(405, 384));
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(400, 322));
        this.jTree1.setRootVisible(false);
        this.jTree1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                OlapBrowser.this.jTree1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel4.setForeground(new Color(0, 51, 255));
        this.jLabel4.setText(I18n.getString("OlapBrowser.Label.Info"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(I18n.getString("OlapBrowser.Label.FieldName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel3.setText(I18n.getString("OlapBrowser.Label.Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jComboBoxType.setMinimumSize(new Dimension(30, 19));
        this.jComboBoxType.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(4, 2, 0, 4);
        this.jPanel1.add((Component)this.jComboBoxType, gridBagConstraints);
        this.jLabel2.setText(I18n.getString("OlapBrowser.Label.Expr"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jTextFieldExpression, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButton2.setText(I18n.getString("Global.Button.Clear"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OlapBrowser.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 4);
        this.jPanel2.add((Component)this.jButton2, gridBagConstraints);
        this.jButton1.setText(I18n.getString("Global.Button.AddField"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OlapBrowser.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 2, 4);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jTextFieldName.setText("");
        this.jComboBoxType.setSelectedIndex(0);
        this.jTextFieldExpression.setText("");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("OlapBrowser.Message.Error"), I18n.getString("OlapBrowser.Message.Error2"), 0);
            return;
        }
        if (this.jTextFieldExpression.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("OlapBrowser.Message.Error3"), I18n.getString("OlapBrowser.Message.Error2"), 0);
            return;
        }
        JRDesignField field = new JRDesignField();
        field.setName(this.jTextFieldName.getText().trim());
        field.setValueClassName("" + ((Tag)this.jComboBoxType.getSelectedItem()).getValue());
        field.setDescription(this.jTextFieldExpression.getText());
        if (this.fieldAlreadyExists(field)) {
            JOptionPane.showMessageDialog(this, I18n.getString("OlapBrowser.Message.Warning"), I18n.getString("OlapBrowser.Message.Error2"), 0);
            return;
        }
        Vector<Object> row = new Vector<Object>();
        row.addElement(field);
        row.addElement(field.getValueClassName());
        row.addElement(field.getDescription());
        DefaultTableModel dtm = (DefaultTableModel)this.getJTableFields().getModel();
        dtm.addRow(row);
        this.getJTableFields().getSelectionModel().addSelectionInterval(this.getJTableFields().getRowCount() - 1, this.getJTableFields().getRowCount() - 1);
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        WalkableWrapper ww;
        String exp;
        TreePath tp;
        if (evt.getClickCount() == 2 && evt.getButton() == 1 && (tp = this.jTree1.getSelectionPath()) != null && (exp = (ww = (WalkableWrapper)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject()).getExpression()) != null) {
            if (ww.isMeasure()) {
                this.jTextFieldName.setText(ww + "");
                this.jTextFieldExpression.setText(exp);
            } else {
                String newexp = this.jTextFieldExpression.getText();
                int ss = this.jTextFieldExpression.getSelectionStart() >= 0 ? this.jTextFieldExpression.getSelectionStart() : this.jTextFieldExpression.getCaretPosition();
                int se = this.jTextFieldExpression.getSelectionEnd() >= 0 ? this.jTextFieldExpression.getSelectionEnd() : this.jTextFieldExpression.getCaretPosition();
                newexp = newexp.substring(0, ss) + exp + newexp.substring(se);
                this.jTextFieldExpression.setText(newexp);
                this.jTextFieldExpression.requestFocusInWindow();
            }
        }
    }

    private boolean fieldAlreadyExists(JRDesignField field) {
        boolean found = false;
        for (int j = 0; j < this.getJTableFields().getRowCount(); ++j) {
            Object ff = this.getJTableFields().getValueAt(j, 0);
            if (!(ff instanceof JRDesignField) || !((JRDesignField)ff).getName().equals(field.getName())) continue;
            found = true;
            break;
        }
        return found;
    }

    public void queryChanged(String newQuery) {
        ++this.lastExecution;
        int thisExecution = this.lastExecution++;
        String error_msg = "";
        int in = this.lastExecution;
        this.getReportQueryDialog().getJLabelStatusSQL().setText(I18n.getString("OlapBrowser.Message.SQLStatus"));
        try {
            Thread thread = Thread.currentThread();
            IReportManager.getInstance();
            thread.setContextClassLoader(IReportManager.getReportClassLoader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (in < this.lastExecution) {
            return;
        }
        OLAPQueryExecuter olapQE = new OLAPQueryExecuter(newQuery, this.getReportQueryDialog().getDataset().getParametersList());
        String lastError = "";
        try {
            final Query query = olapQE.createOlapQuery();
            if (in < this.lastExecution) {
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    OlapBrowser.this.setOlapQuery(query);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setOlapQuery(null);
            lastError = I18n.getString("OlapBrowser.Message.Exception") + ex.getMessage() + ")";
        }
        this.getReportQueryDialog().getJLabelStatusSQL().setText(I18n.getString("OlapBrowser.Message.Ready"));
    }

    public ReportQueryDialog getReportQueryDialog() {
        return this.reportQueryDialog;
    }

    public void setReportQueryDialog(ReportQueryDialog reportQueryDialog) {
        this.reportQueryDialog = reportQueryDialog;
    }
}

