/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.wizards.TemplateWizardPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class TemplateVisualPanel
extends JPanel {
    private TemplateWizardPanel panel = null;
    private ButtonGroup buttonGroup1;
    private JLabel jLabelPreview;
    private JList jList1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;

    public TemplateVisualPanel(TemplateWizardPanel panel) {
        this.panel = panel;
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new FieldListCellRenderer());
        this.updateTemplates();
    }

    public String getName() {
        return I18n.getString("TemplateVisualPanel.Name.Layout");
    }

    private void updateTemplates() {
        this.loadTemplates(this.getReportType());
    }

    private void loadTemplates(String type) {
        this.jLabelPreview.setIcon(null);
        ((DefaultListModel)this.jList1.getModel()).clear();
        FileObject templatesFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("ireport/templates/" + type);
        if (templatesFileObject == null) {
            return;
        }
        DataFolder templatesDataFolder = DataFolder.findFolder((FileObject)templatesFileObject);
        if (templatesDataFolder == null) {
            return;
        }
        Enumeration enObj = templatesDataFolder.children();
        while (enObj.hasMoreElements()) {
            DataObject dataObject = (DataObject)enObj.nextElement();
            if (dataObject.getPrimaryFile().getExt() != null && dataObject.getPrimaryFile().getExt().length() != 0) continue;
            ((DefaultListModel)this.jList1.getModel()).addElement(dataObject);
        }
        String pathsString = IReportManager.getPreferences().get("TEMPLATE_PATH", "");
        if (pathsString.length() > 0) {
            String[] paths = pathsString.split("\\n");
            for (int i = 0; i < paths.length; ++i) {
                File f = new File(paths[i]);
                this.loadTemplatesFromFile(f, type);
            }
        }
        if (((DefaultListModel)this.jList1.getModel()).getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
    }

    public void loadTemplatesFromFile(File file, String type) {
        FileObject fo;
        String ext2;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.loadTemplatesFromDirectory(file, type);
            return;
        }
        String ext = type.equals("columnar") ? "c.jrxml" : "t.jrxml";
        String string = ext2 = type.equals("columnar") ? "c.xml" : "t.xml";
        if ((file.getName().toLowerCase().endsWith(ext) || file.getName().toLowerCase().endsWith(ext2)) && (fo = FileUtil.toFileObject((File)file)) != null) {
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (dobj != null) {
                ((DefaultListModel)this.jList1.getModel()).addElement(dobj);
            }
        }
    }

    public void loadTemplatesFromDirectory(File folder, String type) {
        if (folder != null && folder.exists()) {
            File[] files = folder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.loadTemplatesFromFile(files[i], type);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabelPreview = new JLabel();
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)"Columnar Layout");
        this.jRadioButton1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TemplateVisualPanel.this.jRadioButton1StateChanged(evt);
            }
        });
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplateVisualPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(50, 4, 0, 4);
        this.add((Component)this.jRadioButton1, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)"Tabular Layout");
        this.jRadioButton2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TemplateVisualPanel.this.jRadioButton2StateChanged(evt);
            }
        });
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplateVisualPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.jRadioButton2, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 120));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TemplateVisualPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelPreview.setHorizontalAlignment(2);
        this.jLabelPreview.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 4, 4);
        this.add((Component)this.jLabelPreview, gridBagConstraints);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        block4: {
            DataObject dataObject;
            block5: {
                this.jLabelPreview.setIcon(null);
                if (this.jList1.getSelectedIndex() < 0) break block4;
                dataObject = (DataObject)this.jList1.getSelectedValue();
                if (!dataObject.getPrimaryFile().existsExt("preview")) break block5;
                FileObject previewFileObject = dataObject.getFolder().getPrimaryFile().getFileObject(dataObject.getName(), "preview");
                if (previewFileObject == null) break block4;
                try {
                    ImageIcon img = new ImageIcon(previewFileObject.getURL());
                    this.jLabelPreview.setIcon(img);
                    this.jLabelPreview.updateUI();
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break block4;
            }
            File f = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            String fileName = f.getName();
            if (fileName.lastIndexOf(".") > 0) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                ArrayList<String> extensions = new ArrayList<String>();
                extensions.add(".gif");
                extensions.add(".GIF");
                extensions.add(".jpg");
                extensions.add(".JPG");
                extensions.add(".png");
                extensions.add(".PNG");
                for (String ext : extensions) {
                    File imageFile = new File(f.getParent(), fileName + ext);
                    if (!imageFile.exists()) continue;
                    ImageIcon img = new ImageIcon(imageFile + "");
                    this.jLabelPreview.setIcon(img);
                    this.jLabelPreview.updateUI();
                    break;
                }
            }
        }
    }

    private void jRadioButton1StateChanged(ChangeEvent evt) {
    }

    private void jRadioButton2StateChanged(ChangeEvent evt) {
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.updateTemplates();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.updateTemplates();
    }

    public String getReportType() {
        return this.jRadioButton1.isSelected() ? I18n.getString("TemplateVisualPanel.RadioButton.columnar") : I18n.getString("TemplateVisualPanel.RadioButton.tabular");
    }

    public FileObject getReportTemplate() {
        DataObject dataObject = (DataObject)this.jList1.getSelectedValue();
        return dataObject.getPrimaryFile();
    }

    static class FieldListCellRenderer
    extends DefaultListCellRenderer {
        FieldListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DataObject) {
                value = ((DataObject)value).getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

