/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.utils.Java2DUtils;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JRDesignChartWidget
extends JRDesignElementWidget {
    private Image chartImage = null;
    private Image staticChartImage = null;

    public JRDesignChartWidget(ReportObjectScene scene, JRDesignChart element) {
        super(scene, (JRDesignElement)element);
        ((JRBaseChartPlot)element.getPlot()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void paintWidgetImplementation() {
        Image image = this.getChartImage();
        if (image != null) {
            Graphics2D gr = this.getScene().getGraphics();
            Rectangle r = this.getPreferredBounds();
            AffineTransform af = gr.getTransform();
            AffineTransform new_af = (AffineTransform)af.clone();
            AffineTransform translate = AffineTransform.getTranslateInstance(this.getBorder().getInsets().left + r.x, this.getBorder().getInsets().top + r.y);
            new_af.concatenate(translate);
            gr.setTransform(new_af);
            JasperDesign jd = ((ReportObjectScene)this.getScene()).getJasperDesign();
            JRDesignChart e = (JRDesignChart)this.getElement();
            Java2DUtils.setClip(gr, this.getClientArea());
            gr.drawImage(image, 0, 0, e.getWidth(), e.getHeight(), 0, 0, image.getWidth(null), image.getHeight(null), null);
            Java2DUtils.resetClip(gr);
            gr.setTransform(af);
        } else {
            super.paintWidget();
        }
    }

    public Image getChartImage() {
        if (this.chartImage == null) {
            this.chartImage = this.recreateChartImage();
        }
        return this.chartImage;
    }

    public void setChartImage(Image image) {
        this.chartImage = image;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    private Image recreateChartImage() {
        JRDesignChart chart = (JRDesignChart)this.getElement();
        String imgUri = null;
        switch (chart.getChartType()) {
            case 1: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/area_big.png";
                break;
            }
            case 3: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/bar_big.png";
                break;
            }
            case 2: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/bar3d_big.png";
                break;
            }
            case 4: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/bubble_big.png";
                break;
            }
            case 5: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/candlestick_big.png";
                break;
            }
            case 6: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/highlow_big.png";
                break;
            }
            case 7: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/line_big.png";
                break;
            }
            case 17: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/meter_big.png";
                break;
            }
            case 19: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/multiaxis_big.png";
                break;
            }
            case 9: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/pie_big.png";
                break;
            }
            case 8: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/pie3d_big.png";
                break;
            }
            case 10: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/scatter_big.png";
                break;
            }
            case 20: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/stackedarea_big.png";
                break;
            }
            case 12: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/stackedbar_big.png";
                break;
            }
            case 11: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/stackedbar3d_big.png";
                break;
            }
            case 18: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/thermometer_big.png";
                break;
            }
            case 16: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/timeseries_big.png";
                break;
            }
            case 13: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/xyarea_big.png";
                break;
            }
            case 14: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/xybar_big.png";
                break;
            }
            case 15: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/xyline_big.png";
                break;
            }
            case 21: {
                imgUri = "/com/jaspersoft/ireport/designer/charts/icons/gantt_big.png";
            }
        }
        if (this.staticChartImage == null && imgUri != null) {
            this.staticChartImage = Misc.loadImageFromResources(imgUri);
        }
        this.chartImage = this.staticChartImage;
        return this.chartImage;
    }
}

