/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.borders.ElementSelectedBorder;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SelectionWidget
extends Widget {
    protected static final ElementSelectedBorder SELECTED_BORDER = new ElementSelectedBorder();
    protected JRDesignElementWidget realWidget = null;

    public JRDesignElementWidget getRealWidget() {
        return this.realWidget;
    }

    public SelectionWidget(AbstractReportObjectScene scene, JRDesignElementWidget w) {
        super((Scene)scene);
        this.realWidget = w;
        this.setBorder(SELECTED_BORDER);
        this.updateBounds();
    }

    public void updateBounds() {
        Insets insets = this.getBorder().getInsets();
        Rectangle r = this.realWidget.getPreferredBounds();
        r.x -= insets.left;
        r.y -= insets.top;
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        this.setPreferredBounds(r);
        Point p = this.realWidget.getPreferredLocation();
        this.setPreferredLocation(p);
    }

    protected Cursor getCursorAt(Point localLocation) {
        Rectangle bounds = this.getBounds();
        Insets insets = this.getBorder().getInsets();
        if (new Rectangle(bounds.x, bounds.y, insets.left, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(6);
        }
        if (new Rectangle(bounds.x + bounds.width / 2 - insets.top / 2, bounds.y, insets.top, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(8);
        }
        if (new Rectangle(bounds.x + bounds.width - insets.right, bounds.y, insets.right, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(7);
        }
        if (new Rectangle(bounds.x, bounds.y + bounds.height - insets.bottom, insets.left, insets.bottom).contains(localLocation)) {
            return Cursor.getPredefinedCursor(4);
        }
        if (new Rectangle(bounds.x + bounds.width / 2 - insets.bottom / 2, bounds.y + bounds.height - insets.bottom, insets.bottom, insets.bottom).contains(localLocation)) {
            return Cursor.getPredefinedCursor(9);
        }
        if (new Rectangle(bounds.x + bounds.width - insets.right, bounds.y + bounds.height - insets.bottom, insets.left, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(5);
        }
        if (new Rectangle(bounds.x, bounds.y + bounds.height / 2 - insets.left / 2, insets.left, insets.left).contains(localLocation)) {
            return Cursor.getPredefinedCursor(10);
        }
        if (new Rectangle(bounds.x + bounds.width - insets.right, bounds.y + bounds.height / 2 - insets.right / 2, insets.right, insets.right).contains(localLocation)) {
            return Cursor.getPredefinedCursor(11);
        }
        return super.getCursorAt(localLocation);
    }
}

