/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class ConnectUsingDriverAction
extends DatabaseAction {
    static final long serialVersionUID = 8245005834483564671L;

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        String string;
        String string2;
        Node node = nodeArray[0];
        DriverNodeInfo driverNodeInfo = (DriverNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        JDBCDriver jDBCDriver = driverNodeInfo.getJDBCDriver();
        if (jDBCDriver != null) {
            string2 = jDBCDriver.getName();
            string = jDBCDriver.getClassName();
        } else {
            string2 = driverNodeInfo.getName();
            string = driverNodeInfo.getURL();
        }
        new NewConnectionDialogDisplayer().showDialog(string2, string);
    }

    public static final class NewConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        ConnectionNodeInfo cni;
        boolean advancedPanel = false;
        boolean okPressed = false;

        public void showDialog(String string, String string2) {
            this.showDialog(string, string2, null, null, null);
        }

        public DatabaseConnection showDialog(JDBCDriver jDBCDriver, String string, String string2, String string3) {
            String string4 = jDBCDriver != null ? jDBCDriver.getName() : null;
            String string5 = jDBCDriver != null ? jDBCDriver.getClassName() : null;
            return this.showDialog(string4, string5, string, string2, string3);
        }

        public DatabaseConnection showDialog(String string, String string2, String string3, String string4, String string5) {
            JDBCDriver[] jDBCDriverArray;
            String string6 = null;
            if (null != string3 && null != string2) {
                jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string2);
                string6 = string2;
            } else {
                jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers();
            }
            String string7 = null;
            String string8 = null;
            if (string == null || string2 == null) {
                for (int i = 0; i < jDBCDriverArray.length; ++i) {
                    if (!JDBCDriverSupport.isAvailable(jDBCDriverArray[i])) continue;
                    if (string7 == null) {
                        string7 = jDBCDriverArray[i].getName();
                        string8 = jDBCDriverArray[i].getClassName();
                    }
                    if (!"org.apache.derby.jdbc.ClientDriver".equals(jDBCDriverArray[i].getClassName())) continue;
                    string7 = jDBCDriverArray[i].getName();
                    string8 = jDBCDriverArray[i].getClassName();
                    break;
                }
            } else {
                string7 = string;
                string8 = string2;
            }
            final DatabaseConnection databaseConnection = new DatabaseConnection();
            databaseConnection.setDriverName(string7);
            databaseConnection.setDriver(string8);
            if (string4 != null) {
                databaseConnection.setUser(string4);
            }
            if (string5 != null) {
                databaseConnection.setPassword(string5);
            }
            if (null != string3) {
                databaseConnection.setDatabase(string3);
            }
            final NewConnectionPanel newConnectionPanel = new NewConnectionPanel(this, string6, databaseConnection);
            final SchemaPanel schemaPanel = new SchemaPanel(this, databaseConnection);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("argumentChanged")) {
                        schemaPanel.setSchemas(new Vector(), "");
                        schemaPanel.resetProgress();
                        try {
                            Connection connection = databaseConnection.getConnection();
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
            };
            newConnectionPanel.addPropertyChangeListener(propertyChangeListener);
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("connecting")) {
                        NewConnectionDialogDisplayer.this.fireConnectionStarted();
                    }
                    if (propertyChangeEvent.getPropertyName().equals("failed")) {
                        NewConnectionDialogDisplayer.this.fireConnectionFailed();
                    }
                    if (propertyChangeEvent.getPropertyName().equals("connected")) {
                        if (!NewConnectionDialogDisplayer.this.retrieveSchemas(schemaPanel, databaseConnection, databaseConnection.getUser())) {
                            NewConnectionDialogDisplayer.this.fireConnectionFinished();
                            NewConnectionDialogDisplayer.this.dlg.setSelectedComponent(schemaPanel);
                            return;
                        }
                        databaseConnection.setSchema(schemaPanel.getSchema());
                        NewConnectionDialogDisplayer.this.fireConnectionFinished();
                        if (NewConnectionDialogDisplayer.this.advancedPanel && !NewConnectionDialogDisplayer.this.okPressed) {
                            return;
                        }
                        try {
                            ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(databaseConnection);
                        }
                        catch (DatabaseException databaseException) {
                            Logger.getLogger("global").log(Level.INFO, null, databaseException);
                            DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), databaseException.getMessage());
                            try {
                                databaseConnection.getConnection().close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            return;
                        }
                        if (NewConnectionDialogDisplayer.this.dlg != null) {
                            NewConnectionDialogDisplayer.this.dlg.close();
                        }
                    } else {
                        NewConnectionDialogDisplayer.this.okPressed = false;
                    }
                }
            };
            ExceptionListener exceptionListener = new ExceptionListener(){

                public void exceptionOccurred(Exception exception) {
                    if (exception instanceof DDLException) {
                        Logger.getLogger("global").log(Level.INFO, null, exception.getCause());
                    } else {
                        Logger.getLogger("global").log(Level.INFO, null, exception);
                    }
                    String string = null;
                    if (exception instanceof ClassNotFoundException) {
                        string = MessageFormat.format(DatabaseAction.bundle().getString("EXC_ClassNotFound"), exception.getMessage());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(DbUtilities.formatError(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), exception.getMessage()));
                        if (exception instanceof DDLException && exception.getCause() instanceof SQLException) {
                            for (SQLException sQLException = ((SQLException)exception.getCause()).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                                stringBuffer.append("\n\n" + sQLException.getMessage());
                            }
                        }
                        string = stringBuffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                }
            };
            databaseConnection.addPropertyChangeListener(propertyChangeListener2);
            databaseConnection.addExceptionListener(exceptionListener);
            ActionListener actionListener = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                        NewConnectionDialogDisplayer.this.okPressed = true;
                        newConnectionPanel.setConnectionInfo();
                        try {
                            if (databaseConnection.getConnection() == null || databaseConnection.getConnection().isClosed()) {
                                databaseConnection.connect();
                            } else {
                                databaseConnection.setSchema(schemaPanel.getSchema());
                                ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(databaseConnection);
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            databaseConnection.connect();
                        }
                        catch (DatabaseException databaseException) {
                            Logger.getLogger("global").log(Level.INFO, null, databaseException);
                            DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), databaseException.getMessage());
                            try {
                                databaseConnection.getConnection().close();
                                databaseConnection.setConnection(null);
                            }
                            catch (SQLException sQLException) {
                                databaseConnection.setConnection(null);
                            }
                        }
                        return;
                    }
                }
            };
            ChangeListener changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(schemaPanel)) {
                        NewConnectionDialogDisplayer.this.advancedPanel = true;
                        newConnectionPanel.setConnectionInfo();
                    } else {
                        NewConnectionDialogDisplayer.this.advancedPanel = false;
                    }
                }
            };
            this.dlg = new ConnectionDialog(this, newConnectionPanel, schemaPanel, newConnectionPanel.getTitle(), new HelpCtx("new_db_save_password"), actionListener, changeListener);
            this.dlg.setVisible(true);
            return ConnectionList.getDefault().getConnection(databaseConnection);
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.fireConnectionStep(DatabaseAction.bundle().getString("ConnectionProgress_Schemas"));
            Vector<String> vector = new Vector<String>();
            try {
                ResultSet resultSet = databaseConnection.getConnection().getMetaData().getSchemas();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1).trim());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string2 = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableObtainSchemas"), sQLException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
            return schemaPanel.setSchemas(vector, string);
        }
    }
}

