/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.macros.MacrosPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class MacrosModel {
    private ShortcutsFinder keymapModel;
    private Map<String, String> macroNameToText;
    private DefaultTableModel tableModel;
    private boolean changed = false;
    private static MacrosModel sharedModel = null;
    private static Reference<Lookup> lastLookupRef = null;

    public static synchronized MacrosModel getModel(Lookup lookup) {
        Lookup lookup2;
        if (lookup == null) {
            return sharedModel;
        }
        Lookup lookup3 = lookup2 = lastLookupRef == null ? null : lastLookupRef.get();
        if (lookup2 == null || lookup2 != lookup) {
            sharedModel = null;
        }
        if (sharedModel == null) {
            sharedModel = new MacrosModel(lookup);
            lastLookupRef = new WeakReference<Lookup>(lookup);
        }
        return sharedModel;
    }

    public void reset() {
        this.init();
    }

    MacrosModel(Lookup lookup) {
        this.keymapModel = (ShortcutsFinder)lookup.lookup(ShortcutsFinder.class);
        this.init();
    }

    private void init() {
        Object object22;
        this.macroNameToText = new HashMap<String, String>();
        Set set = EditorSettings.getDefault().getMimeTypes();
        for (Object object22 : set) {
            BaseOptions object3 = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)object22)).lookup(BaseOptions.class);
            if (object3 == null) continue;
            this.macroNameToText.putAll(object3.getMacroMap());
        }
        this.macroNameToText.remove(null);
        Vector vector = new Vector();
        for (String string : this.macroNameToText.keySet()) {
            String[] stringArray;
            String string2 = "";
            ShortcutAction shortcutAction = this.keymapModel.findActionForId("macro-" + string);
            if (shortcutAction == null) {
                shortcutAction = this.keymapModel.findActionForId(string);
            }
            if (shortcutAction != null && (stringArray = this.keymapModel.getShortcuts(shortcutAction)).length > 0) {
                string2 = stringArray[0];
            }
            stringArray = new Vector();
            stringArray.add(string);
            stringArray.add(string2);
            vector.add(stringArray);
        }
        Collections.sort(vector, new MComparator());
        object22 = new Vector<String>(2);
        ((Vector)object22).add(MacrosModel.loc("Macro_Name_Title"));
        ((Vector)object22).add(MacrosModel.loc("Macro_Code_Title"));
        this.tableModel = new DefaultTableModel(vector, (Vector)object22){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.tableModel.getColumnName(2);
    }

    DefaultTableModel getShortcutsTableModel() {
        return this.tableModel;
    }

    boolean isChanged() {
        return this.changed;
    }

    Collection getMacroNames() {
        return Collections.unmodifiableCollection(this.macroNameToText.keySet());
    }

    String getMacroText(String string) {
        return this.macroNameToText.get(string);
    }

    void addMacro(String string, String string2) {
        this.tableModel.insertRow(0, new Object[]{string, string2});
        this.macroNameToText.put(string, string2);
    }

    void removeMacro(int n) {
        String string = (String)this.tableModel.getValueAt(n, 0);
        this.macroNameToText.remove(string);
        this.tableModel.removeRow(n);
        this.keymapModel.refreshActions();
        ShortcutAction shortcutAction = this.keymapModel.findActionForId("macro-" + string);
        if (shortcutAction != null) {
            this.keymapModel.setShortcuts(shortcutAction, Collections.emptySet());
        }
        this.changed = true;
    }

    void setMacroText(String string, String string2) {
        if (this.macroNameToText.containsKey(string) && string2.equals(this.macroNameToText.get(string))) {
            return;
        }
        this.macroNameToText.put(string, string2);
        this.changed = true;
    }

    void setShortcut(int n, String string) {
        this.tableModel.setValueAt(string, n, 1);
        this.saveMacros();
        this.keymapModel.refreshActions();
        ShortcutAction shortcutAction = this.keymapModel.findActionForId("macro-" + this.tableModel.getValueAt(n, 0));
        this.keymapModel.setShortcuts(shortcutAction, Collections.singleton(string));
        this.changed = true;
    }

    void applyChanges() {
        this.saveMacros();
        this.keymapModel.apply();
        this.changed = false;
    }

    void cancel() {
        this.init();
        this.changed = false;
    }

    private static String loc(String string) {
        return NbBundle.getMessage(MacrosPanel.class, (String)string);
    }

    private void saveMacros() {
        Set set = EditorSettings.getDefault().getMimeTypes();
        for (String string : set) {
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(BaseOptions.class);
            if (baseOptions == null) continue;
            baseOptions.setMacroMap(new HashMap<String, String>(this.macroNameToText));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MComparator
    implements Comparator<Vector<String>> {
        private MComparator() {
        }

        @Override
        public int compare(Vector<String> vector, Vector<String> vector2) {
            String string = vector.get(0);
            String string2 = vector2.get(0);
            return string.compareTo(string2);
        }
    }
}

