/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataLoader;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = 4795737295255253334L;
    static final Logger LOG = Logger.getLogger(PropertiesDataObject.class.getName());
    private transient BundleStructure bundleStructure;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();
    private transient String pasteSuffix;
    private Lookup lookup;

    public PropertiesDataObject(FileObject fileObject, PropertiesDataLoader propertiesDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)propertiesDataLoader);
        this.initialize();
    }

    PropertiesEncoding getEncoding() {
        return ((PropertiesDataLoader)this.getLoader()).getEncoding();
    }

    private Lookup getSuperLookup() {
        return super.getLookup();
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new ProxyLookup(new Lookup[]{Lookups.singleton((Object)((Object)this.getEncoding())), Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

                public Lookup getLookup() {
                    return PropertiesDataObject.this.getSuperLookup();
                }
            })});
        }
        return this.lookup;
    }

    private void initialize() {
        this.bundleStructure = null;
        Class[] classArray = new Class[]{PropertiesOpen.class, PropertiesEditorSupport.class};
        this.getCookieSet().add(classArray, (CookieSet.Factory)this);
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return (T)((Object)this.getOpenSupport());
        }
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return (T)((PropertiesFileEntry)this.getPrimaryEntry()).getPropertiesEditor();
        }
        return null;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DataObject handleCopy(DataFolder dataFolder) throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleCopy(" + FileUtil.getFileDisplayName((FileObject)dataFolder.getPrimaryFile()) + ')');
        }
        try {
            this.pasteSuffix = this.createPasteSuffix(dataFolder);
            DataObject dataObject = super.handleCopy(dataFolder);
            return dataObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        SaveCookie saveCookie;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleMove(" + FileUtil.getFileDisplayName((FileObject)dataFolder.getPrimaryFile()) + ')');
        }
        if ((saveCookie = (SaveCookie)this.getCookie(SaveCookie.class)) != null) {
            saveCookie.save();
        }
        try {
            this.pasteSuffix = this.createPasteSuffix(dataFolder);
            FileObject fileObject = super.handleMove(dataFolder);
            return fileObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    String getPasteSuffix() {
        return this.pasteSuffix;
    }

    void removeSecondaryEntry2(MultiDataObject.Entry entry) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("removeSecondaryEntry2(Entry " + FileUtil.getFileDisplayName((FileObject)entry.getFile()) + ')');
        }
        this.removeSecondaryEntry(entry);
    }

    private String createPasteSuffix(DataFolder dataFolder) {
        String string = this.getPrimaryFile().getName();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (true) {
            String string2 = n == 0 ? string : string + n;
            boolean bl = false;
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (!(dataObjectArray[i] instanceof PropertiesDataObject) || !string2.equals(dataObjectArray[i].getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (n == 0) {
                    return "";
                }
                return "" + n;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesOpen getOpenSupport() {
        Object object = this.OPEN_SUPPORT_LOCK;
        synchronized (object) {
            if (this.openSupport == null) {
                this.openSupport = new PropertiesOpen(this);
            }
            return this.openSupport;
        }
    }

    void updateModificationStatus() {
        LOG.finer("updateModificationStatus()");
        boolean bl = false;
        if (((PresentableFileEntry)this.getPrimaryEntry()).isModified()) {
            bl = true;
        } else {
            Iterator iterator = this.secondaryEntries().iterator();
            while (iterator.hasNext()) {
                if (!((PresentableFileEntry)((Object)iterator.next())).isModified()) continue;
                bl = true;
                break;
            }
        }
        super.setModified(bl);
    }

    protected Node createNodeDelegate() {
        PropertiesChildren propertiesChildren = new PropertiesChildren();
        PropertiesDataNode propertiesDataNode = new PropertiesDataNode((DataObject)this, (Children)propertiesChildren);
        return propertiesDataNode;
    }

    public BundleStructure getBundleStructure() {
        if (this.bundleStructure == null) {
            this.bundleStructure = new BundleStructure(this);
        }
        return this.bundleStructure;
    }

    public static Comparator<String> getSecondaryFilesComparator() {
        return new KeyComparator();
    }

    void fireNameChange() {
        LOG.finer("fireNameChange()");
        this.firePropertyChange("name", null, null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesChildren
    extends Children.Keys<String> {
        private PropertyChangeListener propertyListener = null;

        PropertiesChildren() {
        }

        protected void mySetKeys() {
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string == string2) {
                        return 0;
                    }
                    if (string == null) {
                        return -1;
                    }
                    if (string2 == null) {
                        return 1;
                    }
                    return string.compareTo(string2);
                }
            });
            treeSet.add(PropertiesDataObject.this.getPrimaryEntry().getFile().getName());
            for (MultiDataObject.Entry entry : PropertiesDataObject.this.secondaryEntries()) {
                treeSet.add(entry.getFile().getName());
            }
            this.setKeys(treeSet);
        }

        protected void addNotify() {
            this.mySetKeys();
            if (this.propertyListener == null) {
                this.propertyListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("files".equals(propertyChangeEvent.getPropertyName())) {
                            PropertiesChildren.this.mySetKeys();
                        }
                    }
                };
                PropertiesDataObject.this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyListener, (Object)((Object)PropertiesDataObject.this)));
            }
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(String string) {
            if (string == null) {
                return null;
            }
            PropertiesFileEntry propertiesFileEntry2 = (PropertiesFileEntry)PropertiesDataObject.this.getPrimaryEntry();
            if (string.equals(propertiesFileEntry2.getFile().getName())) {
                return new Node[]{propertiesFileEntry2.getNodeDelegate()};
            }
            for (PropertiesFileEntry propertiesFileEntry2 : PropertiesDataObject.this.secondaryEntries()) {
                if (!string.equals(propertiesFileEntry2.getFile().getName())) continue;
                return new Node[]{propertiesFileEntry2.getNodeDelegate()};
            }
            return null;
        }
    }
}

