/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.DimensionCurrentMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class OpeningClosingPeriodFunDef
extends FunDefBase {
    private final boolean opening;
    static final Resolver OpeningPeriodResolver = new MultiResolver("OpeningPeriod", "OpeningPeriod([<Level>[, <Member>]])", "Returns the first descendant of a member at a level.", new String[]{"fm", "fml", "fmlm"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new OpeningClosingPeriodFunDef(dummyFunDef, true);
        }
    };
    static final Resolver ClosingPeriodResolver = new MultiResolver("ClosingPeriod", "ClosingPeriod([<Level>[, <Member>]])", "Returns the last descendant of a member at a level.", new String[]{"fm", "fml", "fmlm", "fmm"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new OpeningClosingPeriodFunDef(dummyFunDef, false);
        }
    };

    public OpeningClosingPeriodFunDef(FunDef dummyFunDef, boolean opening) {
        super(dummyFunDef);
        this.opening = opening;
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            Hierarchy hierarchy = validator.getQuery().getCube().getTimeDimension().getHierarchy();
            return MemberType.forHierarchy(hierarchy);
        }
        return super.getResultType(validator, args);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        LevelCalc levelCalc;
        MemberCalc memberCalc;
        Exp[] args = call.getArgs();
        switch (args.length) {
            case 0: {
                memberCalc = new DimensionCurrentMemberCalc(compiler.getEvaluator().getCube().getTimeDimension());
                levelCalc = null;
                break;
            }
            case 1: {
                levelCalc = compiler.compileLevel(call.getArg(0));
                memberCalc = new DimensionCurrentMemberCalc(compiler.getEvaluator().getCube().getTimeDimension());
                break;
            }
            default: {
                levelCalc = compiler.compileLevel(call.getArg(0));
                memberCalc = compiler.compileMember(call.getArg(1));
            }
        }
        Dimension memberDimension = memberCalc.getType().getDimension();
        if (levelCalc == null) {
            Dimension levelDimension = memberDimension;
        } else {
            Dimension levelDimension = levelCalc.getType().getDimension();
            if (!memberDimension.equals(levelDimension)) {
                throw MondrianResource.instance().FunctionMbrAndLevelHierarchyMismatch.ex(this.opening ? "OpeningPeriod" : "ClosingPeriod", levelDimension.getUniqueName(), memberDimension.getUniqueName());
            }
        }
        return new AbstractMemberCalc(call, new Calc[]{levelCalc, memberCalc}){

            public Member evaluateMember(Evaluator evaluator) {
                Level level;
                Member member = memberCalc.evaluateMember(evaluator);
                if (levelCalc == null) {
                    int targetDepth = member.getLevel().getDepth() + 1;
                    Level[] levels = member.getHierarchy().getLevels();
                    if (levels.length <= targetDepth) {
                        return member.getHierarchy().getNullMember();
                    }
                    level = levels[targetDepth];
                } else {
                    level = levelCalc.evaluateLevel(evaluator);
                }
                if (level.getDepth() < member.getLevel().getDepth()) {
                    return member.getHierarchy().getNullMember();
                }
                if (level == member.getLevel()) {
                    return member;
                }
                return OpeningClosingPeriodFunDef.getDescendant(evaluator.getSchemaReader(), member, level, OpeningClosingPeriodFunDef.this.opening);
            }
        };
    }

    static Member getDescendant(SchemaReader schemaReader, Member member, Level targetLevel, boolean returnFirstDescendant) {
        Member[] children;
        int targetLevelDepth = targetLevel.getDepth();
        OpeningClosingPeriodFunDef.assertPrecondition(member.getLevel().getDepth() < targetLevelDepth, "member.getLevel().getDepth() < targetLevel.getDepth()");
        do {
            if ((children = schemaReader.getMemberChildren(member)).length != 0) continue;
            return targetLevel.getHierarchy().getNullMember();
        } while ((member = children[returnFirstDescendant ? 0 : children.length - 1]).getLevel().getDepth() != targetLevelDepth);
        if (member.isHidden()) {
            return member.getHierarchy().getNullMember();
        }
        return member;
    }
}

