/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ParameterCompilable;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Parameter;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapSchema;

public class RolapSchemaParameter
implements Parameter,
ParameterCompilable {
    private final RolapSchema schema;
    private final String name;
    private String description;
    private String defaultExpString;
    private Type type;
    private final boolean modifiable;
    private Object value;
    private Object cachedDefaultValue;

    RolapSchemaParameter(RolapSchema schema, String name, String defaultExpString, String description, Type type, boolean modifiable) {
        assert (defaultExpString != null);
        assert (name != null);
        assert (schema != null);
        assert (type != null);
        this.schema = schema;
        this.name = name;
        this.defaultExpString = defaultExpString;
        this.description = description;
        this.type = type;
        this.modifiable = modifiable;
        schema.parameterList.add(this);
    }

    RolapSchema getSchema() {
        return this.schema;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public Parameter.Scope getScope() {
        return Parameter.Scope.Schema;
    }

    public Type getType() {
        return this.type;
    }

    public Exp getDefaultExp() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (!this.modifiable) {
            throw MondrianResource.instance().ParameterIsNotModifiable.ex(this.getName(), this.getScope().name());
        }
        this.value = value;
    }

    public Calc compile(ExpCompiler compiler) {
        Exp defaultExp = compiler.getValidator().getQuery().getConnection().parseExpression(this.defaultExpString);
        defaultExp = compiler.getValidator().validate(defaultExp, true);
        final Calc defaultCalc = defaultExp.accept(compiler);
        return new GenericCalc(defaultExp){

            public Calc[] getCalcs() {
                return new Calc[]{defaultCalc};
            }

            public Object evaluate(Evaluator evaluator) {
                if (RolapSchemaParameter.this.value != null) {
                    return RolapSchemaParameter.this.value;
                }
                if (RolapSchemaParameter.this.cachedDefaultValue == null) {
                    RolapSchemaParameter.this.cachedDefaultValue = defaultCalc.evaluate(evaluator);
                }
                return RolapSchemaParameter.this.cachedDefaultValue;
            }
        };
    }
}

