/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.sql.SqlQuery;

class SegmentArrayQuerySpec
extends AbstractQuerySpec {
    private final Segment[] segments;

    SegmentArrayQuerySpec(Segment[] segments) {
        super(segments[0].aggregation.getStar());
        this.segments = segments;
        assert (this.isValid(true));
    }

    private boolean isValid(boolean fail) {
        assert (this.segments.length > 0);
        for (Segment segment : this.segments) {
            if (segment.aggregation != this.segments[0].aggregation) {
                assert (!fail);
                return false;
            }
            int n = segment.axes.length;
            if (n != this.segments[0].axes.length) {
                assert (!fail);
                return false;
            }
            for (int j = 0; j < segment.axes.length; ++j) {
                if (segment.axes[j].getPredicate() == this.segments[0].axes[j].getPredicate()) continue;
                assert (!fail);
                return false;
            }
        }
        return true;
    }

    public int getMeasureCount() {
        return this.segments.length;
    }

    public RolapStar.Measure getMeasure(int i) {
        return this.segments[i].measure;
    }

    public String getMeasureAlias(int i) {
        return "m" + Integer.toString(i);
    }

    public RolapStar.Column[] getColumns() {
        return this.segments[0].aggregation.getColumns();
    }

    public String getColumnAlias(int i) {
        return "c" + Integer.toString(i);
    }

    public StarColumnPredicate getColumnPredicate(int i) {
        return this.segments[0].axes[i].getPredicate();
    }

    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        int k = this.getDistinctMeasureCount();
        SqlQuery.Dialect dialect = sqlQuery.getDialect();
        if (!dialect.allowsCountDistinct() && k > 0 || !dialect.allowsMultipleCountDistinct() && k > 1) {
            this.distinctGenerateSql(sqlQuery);
        } else {
            this.nonDistinctGenerateSql(sqlQuery, false, false);
        }
        return sqlQuery.toString();
    }

    protected int getDistinctMeasureCount() {
        int k = 0;
        int count = this.getMeasureCount();
        for (int i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            if (!measure.getAggregator().isDistinct()) continue;
            ++k;
        }
        return k;
    }

    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String exprInner = measure.generateExprString(sqlQuery);
        String exprOuter = measure.getAggregator().getExpression(exprInner);
        sqlQuery.addSelect(exprOuter, this.getMeasureAlias(i));
    }

    protected boolean isAggregate() {
        return true;
    }

    protected void distinctGenerateSql(SqlQuery outerSqlQuery) {
        int i;
        SqlQuery.Dialect dialect = outerSqlQuery.getDialect();
        SqlQuery innerSqlQuery = this.newSqlQuery();
        innerSqlQuery.setDistinct(true);
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(innerSqlQuery, false, true);
            String expr = column.generateExprString(innerSqlQuery);
            StarColumnPredicate predicate = this.getColumnPredicate(i);
            String where = RolapStar.Column.createInExpr(expr, predicate, column.getDatatype(), innerSqlQuery.getDialect());
            if (!where.equals("true")) {
                innerSqlQuery.addWhere(where);
            }
            String alias = "d" + i;
            innerSqlQuery.addSelect(expr, alias);
            String quotedAlias = dialect.quoteIdentifier(alias);
            outerSqlQuery.addSelect(quotedAlias);
            outerSqlQuery.addGroupBy(quotedAlias);
        }
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
            measure.getTable().addToFrom(innerSqlQuery, false, true);
            String alias = this.getMeasureAlias(i);
            String expr = measure.generateExprString(outerSqlQuery);
            innerSqlQuery.addSelect(expr, alias);
            outerSqlQuery.addSelect(measure.getAggregator().getNonDistinctAggregator().getExpression(dialect.quoteIdentifier(alias)));
        }
        outerSqlQuery.addFrom(innerSqlQuery, "dummyname", true);
    }
}

