/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder.syntax;

import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax._ReservedWords;

public class SQLFormatter
implements _ReservedWords {
    public static final char BREAK = '\n';
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char SPACE = ' ';
    private static final String INDENT = "     ";

    private static String concatCommaDelimited(Object[] tokens, boolean wrap) {
        if (tokens.length == 0) {
            return "<empty>";
        }
        String delimiter = String.valueOf(',') + (wrap ? String.valueOf('\n') : String.valueOf(' '));
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            if (wrap) {
                buffer.append(INDENT);
            }
            buffer.append(tokens[i] + delimiter);
        }
        return buffer.substring(0, buffer.length() - delimiter.length());
    }

    public static String concat(QueryTokens._Expression[] tokens, boolean wrap) {
        return SQLFormatter.concatCommaDelimited(tokens, wrap);
    }

    public static String concat(QueryTokens.Group[] tokens, boolean wrap) {
        return SQLFormatter.concatCommaDelimited(tokens, wrap);
    }

    public static String concat(QueryTokens.Sort[] tokens, boolean wrap) {
        return SQLFormatter.concatCommaDelimited(tokens, wrap);
    }

    public static String concat(QueryTokens.Condition[] tokens, boolean wrap) {
        if (tokens.length == 0) {
            return "<empty>";
        }
        String delimiter = wrap ? String.valueOf('\n') : String.valueOf(' ');
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            if (wrap) {
                String indentation = INDENT;
                if (tokens[i].toString().startsWith("AND ")) {
                    indentation = " ";
                } else if (tokens[i].toString().startsWith("OR ")) {
                    indentation = "  ";
                }
                buffer.append(indentation);
            }
            buffer.append(tokens[i] + delimiter);
        }
        return buffer.substring(0, buffer.length() - delimiter.length());
    }

    public static String concat(QueryTokens._TableReference[] tokens, boolean wrap) {
        int i;
        if (tokens.length == 0) {
            return "<empty>";
        }
        String delimiter = wrap ? String.valueOf('\n') + INDENT : String.valueOf(' ');
        StringBuffer buffer = new StringBuffer();
        SQLFormatter.sort(tokens);
        for (i = 0; i < tokens.length; ++i) {
            boolean bRight;
            if (!(tokens[i] instanceof QueryTokens.Join)) continue;
            QueryTokens.Join token = (QueryTokens.Join)tokens[i];
            QueryTokens.Column cL = token.getPrimary();
            QueryTokens.Column cR = token.getForeign();
            boolean bLeft = buffer.toString().indexOf(cL.getTable().toString() + ' ') == 0 || buffer.toString().indexOf(' ' + cL.getTable().toString() + ' ') > 0;
            boolean bl = bRight = buffer.toString().indexOf(cR.getTable().toString() + ' ') == 0 || buffer.toString().indexOf(' ' + cR.getTable().toString() + ' ') > 0;
            if (!bLeft && !bRight) {
                if (buffer.length() > 0) {
                    buffer.insert(buffer.toString().lastIndexOf(delimiter), ',');
                } else if (wrap) {
                    buffer.append(INDENT);
                }
                buffer.append(token.toString() + delimiter);
                continue;
            }
            if (bLeft && bRight) {
                buffer.append("AND " + token.getCondition().toString() + delimiter);
                continue;
            }
            if (!bLeft) {
                if (token.getType() == 1) {
                    token.setType(2);
                } else if (token.getType() == 2) {
                    token.setType(1);
                }
                token.getCondition().setLeft(cR);
                token.getCondition().setRight(cL);
                cR = cL;
            }
            buffer.append(token.getTypeName() + ' ' + cR.getTable().toString() + ' ' + "ON" + ' ' + token.getCondition() + delimiter);
        }
        for (i = 0; i < tokens.length; ++i) {
            if (!(tokens[i] instanceof QueryTokens.Table)) continue;
            if (buffer.length() > 0) {
                buffer.insert(buffer.toString().lastIndexOf(delimiter), ',');
            } else if (wrap) {
                buffer.append(INDENT);
            }
            buffer.append(tokens[i] + delimiter);
        }
        return buffer.length() > 0 ? buffer.substring(0, buffer.length() - delimiter.length()) : "<empty>";
    }

    private static void sort(QueryTokens._TableReference[] tokens) {
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (!(tokens[i] instanceof QueryTokens.Join)) continue;
            QueryTokens.Join joinI = (QueryTokens.Join)tokens[i];
            int k = i;
            for (int j = i + 1; j < tokens.length; ++j) {
                if (!(tokens[j] instanceof QueryTokens.Join)) continue;
                QueryTokens.Join joinJ = (QueryTokens.Join)tokens[j];
                if (joinI.getPrimary().getTable().getReference().equals(joinJ.getPrimary().getTable().getReference()) && joinI.getForeign().getTable().getReference().equals(joinJ.getForeign().getTable().getReference()) || joinI.getPrimary().getTable().getReference().equals(joinJ.getForeign().getTable().getReference()) && joinI.getForeign().getTable().getReference().equals(joinJ.getPrimary().getTable().getReference())) {
                    SQLFormatter.moveUp(tokens, j, i + 1);
                    ++k;
                    continue;
                }
                if (!joinI.getPrimary().getTable().getReference().equals(joinJ.getPrimary().getTable().getReference()) && !joinI.getForeign().getTable().getReference().equals(joinJ.getForeign().getTable().getReference()) && !joinI.getPrimary().getTable().getReference().equals(joinJ.getForeign().getTable().getReference()) && !joinI.getForeign().getTable().getReference().equals(joinJ.getPrimary().getTable().getReference())) continue;
                SQLFormatter.moveUp(tokens, j, ++k);
            }
        }
    }

    private static void moveUp(Object[] tokens, int idxOld, int idxNew) {
        Object token = tokens[idxOld];
        for (int i = idxOld - 1; i >= idxNew; --i) {
            tokens[i + 1] = tokens[i];
        }
        tokens[idxNew] = token;
    }

    public static String ensureQuotes(String identifier, boolean asNeeded) {
        return SQLFormatter.ensureQuotes(identifier, QueryBuilder.identifierQuoteString, asNeeded);
    }

    public static String ensureQuotes(String identifier, String quoteString, boolean asNeeded) {
        int i;
        if (quoteString.equals(String.valueOf(' '))) {
            return identifier;
        }
        if (identifier.startsWith(quoteString)) {
            identifier = identifier.substring(quoteString.length());
        }
        if (identifier.endsWith(quoteString)) {
            identifier = identifier.substring(0, identifier.length() - quoteString.length());
        }
        while ((i = identifier.indexOf(quoteString)) != -1) {
            String left = identifier.substring(0, i);
            String right = identifier.substring(i + 1);
            identifier = left + right;
        }
        StringBuffer quoted = new StringBuffer(identifier);
        if (asNeeded) {
            int iQuote = 0;
            int iSpace = 0;
            while ((iSpace = quoted.toString().indexOf(32, iQuote)) != -1) {
                int iDot = quoted.toString().indexOf(46, iQuote);
                if (iDot == -1) {
                    quoted.insert(iQuote, quoteString);
                    quoted.append(quoteString);
                    break;
                }
                if (iSpace < iDot) {
                    quoted.insert(iQuote, quoteString);
                    quoted.insert(++iDot, quoteString);
                    iQuote = iDot + 2;
                    continue;
                }
                iQuote = iDot + 1;
            }
        } else {
            quoted.insert(0, quoteString);
            quoted.append(quoteString);
            if (identifier.indexOf(46) != -1) {
                int point = identifier.indexOf(46);
                quoted.insert(point + 1, quoteString);
                quoted.insert(point + 3, quoteString);
            }
        }
        return quoted.toString();
    }

    public static String toJdbcValue(Object value, int sqltype) {
        if (value == null) {
            return "null";
        }
        switch (sqltype) {
            case 1: 
            case 12: {
                return "'" + value.toString() + "'";
            }
            case 91: {
                return "{d '" + value.toString() + "'}";
            }
            case 92: {
                return "{t '" + value.toString() + "'}";
            }
            case 93: {
                return "{ts '" + value.toString() + "'}";
            }
        }
        return value.toString();
    }
}

