/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.springframework.beans.factory.InitializingBean;

public abstract class DelegatingConnectionFactory
implements ConnectionFactory,
InitializingBean {
    private ConnectionFactory targetConnectionFactory;

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void afterPropertiesSet() {
        if (this.getTargetConnectionFactory() == null) {
            throw new IllegalArgumentException("targetConnectionFactory is required");
        }
    }

    public Connection getConnection() throws ResourceException {
        return this.getTargetConnectionFactory().getConnection();
    }

    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        return this.getTargetConnectionFactory().getConnection(connectionSpec);
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        return this.getTargetConnectionFactory().getRecordFactory();
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return this.getTargetConnectionFactory().getMetaData();
    }

    public void setReference(Reference reference) {
        throw new UnsupportedOperationException("setReference");
    }

    public Reference getReference() throws NamingException {
        throw new UnsupportedOperationException("getReference");
    }
}

