/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.AbstractStyleNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.DeleteStyleUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class StyleNode
extends AbstractStyleNode {
    public StyleNode(JasperDesign jd, JRDesignStyle style, Lookup doLkp) {
        super(jd, style, doLkp);
    }

    public JRDesignStyle getDesignStyle() {
        return (JRDesignStyle)this.getStyle();
    }

    protected Sheet createSheet() {
        int i;
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        Node.Property[] props = set.getProperties();
        for (i = 0; i < props.length; ++i) {
            set.remove(props[i].getName());
        }
        set.put((Node.Property)new NameProperty(this.getDesignStyle(), this.jd));
        set.put((Node.Property)new DefaultStyleProperty(this.getDesignStyle(), this.jd));
        set.put((Node.Property)new ParentStyleProperty(this.getDesignStyle(), this.jd));
        for (i = 0; i < props.length; ++i) {
            set.put(props[i]);
        }
        return sheet;
    }

    public boolean canRename() {
        return true;
    }

    public void destroy() throws IOException {
        int index = this.jd.getStylesList().indexOf(this.getStyle());
        this.jd.removeStyle((JRStyle)this.getStyle());
        DeleteStyleUndoableEdit undo = new DeleteStyleUndoableEdit(this.getDesignStyle(), this.jd, index);
        IReportManager.getInstance().addUndoableEdit(undo);
        super.destroy();
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException(I18n.getString("StyleNode.Exception.NameNotValid"));
        }
        List currentStyles = null;
        currentStyles = this.jd.getStylesList();
        for (JRDesignStyle p : currentStyles) {
            if (p == this.getStyle() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException(I18n.getString("StyleNode.Exception.NameInUse"));
        }
        String oldName = this.getStyle().getName();
        this.getDesignStyle().setName(s);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType((Node)this, 9);
    }

    public static final class ParentStyleProperty
    extends PropertySupport
    implements PropertyChangeListener {
        JRDesignStyle style = null;
        JasperDesign jd = null;
        private ComboBoxPropertyEditor editor;

        public ParentStyleProperty(JRDesignStyle style, JasperDesign jd) {
            super("parentStyle", String.class, I18n.getString("StyleNode.Property.Style"), I18n.getString("StyleNode.Property.Message"), true, true);
            this.jd = jd;
            this.style = style;
            this.setValue("canEditAsText", Boolean.TRUE);
            this.setValue("oneline", Boolean.TRUE);
            this.setValue("suppressCustomEditor", Boolean.FALSE);
            jd.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jd.getEventSupport()));
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(true, this.getListOfTags());
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.getStyle().getStyle() != null) {
                return this.getStyle().getStyle();
            }
            if (this.getStyle().getStyleNameReference() != null) {
                return this.getStyle().getStyleNameReference();
            }
            return "";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String newValue = "" + val;
            JRStyle newStyle = null;
            if (val instanceof JRStyle) {
                newValue = ((JRStyle)val).getName();
                newStyle = (JRStyle)val;
            } else if (val == null || newValue.length() == 0) {
                newValue = null;
            }
            String oldValue = this.getStyle().getStyleNameReference();
            JRStyle oldStyle = this.getStyle().getStyle();
            this.getStyle().setParentStyleNameReference(newValue);
            this.getStyle().setParentStyle(newStyle);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getStyle(), "ParentStyleNameReference", String.class, oldValue, newValue);
            ObjectPropertyUndoableEdit urob_style = new ObjectPropertyUndoableEdit(this.getStyle(), "ParentStyle", JRStyle.class, oldStyle, newStyle);
            urob.concatenate(urob_style);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.editor == null) {
                return;
            }
            if (evt.getPropertyName() == null) {
                return;
            }
            if (evt.getPropertyName().equals("styles") || evt.getPropertyName().equals("name")) {
                this.editor.setTagValues(this.getListOfTags());
            }
        }

        private ArrayList getListOfTags() {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(null, ""));
            List styles = this.getJasperDesign().getStylesList();
            for (int i = 0; i < styles.size(); ++i) {
                JRDesignStyle st = (JRDesignStyle)styles.get(i);
                l.add(new Tag(st, st.getName()));
                st.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)st.getEventSupport()));
            }
            return l;
        }
    }

    public static final class DefaultStyleProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JasperDesign jd = null;

        public DefaultStyleProperty(JRDesignStyle style, JasperDesign jd) {
            super("default", Boolean.class, "Default Style", I18n.getString("StyleNode.Property.DefaultStyle"));
            this.jd = jd;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this.getStyle().isDefault());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && val instanceof Boolean) {
                Boolean oldValue = this.getStyle().isDefault();
                Boolean newValue = (Boolean)val;
                ObjectPropertyUndoableEdit urob2 = null;
                if (newValue.booleanValue()) {
                    List list = this.getJasperDesign().getStylesList();
                    for (JRDesignStyle st : list) {
                        if (!st.isDefault()) continue;
                        st.setDefault(false);
                        urob2 = new ObjectPropertyUndoableEdit(st, "Default", Boolean.TYPE, Boolean.TRUE, Boolean.FALSE);
                        break;
                    }
                }
                this.getStyle().setDefault(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getStyle(), "Default", Boolean.TYPE, oldValue, newValue);
                if (urob2 != null) {
                    urob.concatenate(urob2);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return !this.getStyle().isDefault();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue(Boolean.FALSE);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JasperDesign jd = null;

        public NameProperty(JRDesignStyle style, JasperDesign jd) {
            super("name", String.class, I18n.getString("StyleNode.Property.Name"), I18n.getString("StyleNode.Property.NameStyle"));
            this.style = style;
            this.jd = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getStyle().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameNotValid"));
                throw iae;
            }
            String s = val + "";
            List currentStyles = null;
            currentStyles = this.getJasperDesign().getStylesList();
            for (JRDesignStyle st : currentStyles) {
                if (st == this.getStyle() || !st.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameInUse"));
                throw iae;
            }
            String oldName = this.getStyle().getName();
            this.getStyle().setName(s);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, this.getStyle().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

