/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.resourcebundle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import org.jdesktop.layout.GroupLayout;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ResourceBundleTopComponent
extends TopComponent
implements LookupListener,
ExplorerManager.Provider,
PropertyChangeListener,
FileChangeListener {
    private static ResourceBundleTopComponent instance;
    protected transient TreeView view;
    private final InstanceContent ic;
    private final Lookup lookup;
    private transient boolean valid = true;
    private final ExplorerManager manager = new ExplorerManager();
    private static final String PREFERRED_ID = "ResourceBundleTopComponent";
    private final Lookup.Result<DataObject> result;
    private DataObject dataObject = null;

    private ResourceBundleTopComponent() {
        this.initComponents();
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{this.lookup, ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map)}));
        this.setLayout(new BorderLayout());
        this.view = new BeanTreeView();
        this.add((Component)this.view, "Center");
        this.setName(NbBundle.getMessage(ResourceBundleTopComponent.class, (String)"CTL_ResourceBundleTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ResourceBundleTopComponent.class, (String)"HINT_ResourceBundleTopComponent"));
        this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataObject.class));
        this.result.addLookupListener((LookupListener)this);
        this.result.allItems();
        this.resultChanged(null);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ResourceBundleTopComponent getDefault() {
        if (instance == null) {
            instance = new ResourceBundleTopComponent();
        }
        return instance;
    }

    public static synchronized ResourceBundleTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ResourceBundleTopComponent.class.getName()).warning("Cannot find ResourceBundleTopComponent component. It will not be located properly in the window system.");
            return ResourceBundleTopComponent.getDefault();
        }
        if (win instanceof ResourceBundleTopComponent) {
            return (ResourceBundleTopComponent)win;
        }
        Logger.getLogger(ResourceBundleTopComponent.class.getName()).warning("There seem to be multiple components with the 'ResourceBundleTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ResourceBundleTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public void resultChanged(LookupEvent arg0) {
        if (!this.result.allInstances().isEmpty()) {
            DataObject dobj = (DataObject)this.result.allInstances().iterator().next();
            if (dobj == this.dataObject) {
                return;
            }
            if (this.getDataObject() != null) {
                this.getDataObject().removePropertyChangeListener((PropertyChangeListener)this);
                this.getDataObject().getPrimaryFile().getParent().removeFileChangeListener((FileChangeListener)this);
            }
            this.setDataObject(dobj);
            if (this.getDataObject() != null) {
                try {
                    DataObject.find((FileObject)this.getDataObject().getPrimaryFile().getParent());
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            DataObject nDO = this.getDataObject();
            this.getDataObject().addPropertyChangeListener((PropertyChangeListener)this);
            this.getExplorerManager().setRootContext(nDO.getNodeDelegate());
            this.view.setRootVisible(true);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null) {
            System.out.println("Data changed: " + evt.getPropertyName());
            System.out.flush();
        }
    }

    public void fileFolderCreated(FileEvent arg0) {
    }

    public void fileDataCreated(FileEvent evt) {
        if (this.getDataObject() != null) {
            System.out.println("Locale added...?" + this.getDataObject().getNodeDelegate().getChildren());
            System.out.flush();
        }
    }

    public void fileChanged(FileEvent arg0) {
    }

    public void fileDeleted(FileEvent evt) {
        System.out.println("Locale deleted...?");
        System.out.flush();
        if (this.getDataObject() != null) {
            // empty if block
        }
    }

    public void fileRenamed(FileRenameEvent arg0) {
    }

    public void fileAttributeChanged(FileAttributeEvent arg0) {
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ResourceBundleTopComponent.getDefault();
        }
    }
}

