/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.sheet.properties.DoubleProperty;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;

public final class Pie3DDepthFactorProperty
extends DoubleProperty {
    private final JRDesignPie3DPlot plot;

    public Pie3DDepthFactorProperty(JRDesignPie3DPlot plot) {
        super(plot);
        this.plot = plot;
    }

    public String getName() {
        return "depthFactor";
    }

    public String getDisplayName() {
        return I18n.getString("Depth_Factor");
    }

    public String getShortDescription() {
        return I18n.getString("Depth_Factor.");
    }

    public Double getDouble() {
        return this.plot.getDepthFactor();
    }

    public Double getOwnDouble() {
        return this.plot.getDepthFactor();
    }

    public Double getDefaultDouble() {
        return 0.2;
    }

    public void setDouble(Double depth) {
        this.plot.setDepthFactor(depth);
    }

    public void validateDouble(Double depth) {
        if (depth < 0.0) {
            throw this.annotateException(I18n.getString("The_depth_factor_must_be_a_positive_value."));
        }
    }
}

