/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.tools.PropertyHint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class PropertyHintListCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel jLabelDescription;
    private JLabel jLabelProperty;
    private JSeparator jSeparator1;

    public void setSelected(boolean b) {
        this.setBackground(b ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("ToolTip.background"));
        this.jLabelDescription.setForeground(b ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("ToolTip.foreground"));
        this.jLabelProperty.setForeground(b ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("ToolTip.foreground"));
    }

    public void setPropertyName(String s) {
        if (s == null) {
            s = "";
        }
        if (!s.startsWith("<html><b>")) {
            s = "<html><b>" + s;
        }
        this.jLabelProperty.setText(s);
    }

    public void setPropertyDescription(String s) {
        if (s == null) {
            s = "";
        }
        if (!s.startsWith("<html>")) {
            s = "<html>" + s;
        }
        this.jLabelDescription.setText(s);
    }

    public PropertyHintListCellRenderer() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabelProperty = new JLabel();
        this.jLabelDescription = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.jLabelProperty.setText("<html><b>Property");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabelProperty, gridBagConstraints);
        this.jLabelDescription.setText("jLabel1");
        this.jLabelDescription.setVerticalAlignment(1);
        this.jLabelDescription.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(1, 1));
        this.jSeparator1.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setSelected(isSelected);
        if (value instanceof PropertyHint) {
            PropertyHint ph = (PropertyHint)value;
            this.setPropertyName(ph.getPropertyName());
            this.setPropertyDescription(ph.getPropertyDescription());
        } else {
            this.setPropertyName("" + value);
            this.setPropertyDescription("");
        }
        if (cellHasFocus) {
            this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
        } else {
            this.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        }
        return this;
    }
}

