/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.AddGroupUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.ReportGroupWizardPanel1;
import com.jaspersoft.ireport.designer.wizards.ReportGroupWizardPanel2;
import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import javax.swing.JComponent;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public final class ReportGroupWizardAction
extends CallableSystemAction {
    private WizardDescriptor.Panel[] panels;

    public void performAction() {
        boolean cancelled;
        JasperDesign jd = IReportManager.getInstance().getActiveReport();
        if (jd == null) {
            return;
        }
        this.panels = null;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels(jd));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle("New group wizard");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            String groupName = (String)wizardDescriptor.getProperty("name");
            String exp = (String)wizardDescriptor.getProperty("expression");
            if (groupName != null) {
                try {
                    JRDesignBand b;
                    JRDesignGroup grp = new JRDesignGroup();
                    grp.setName(groupName);
                    grp.setExpression((JRExpression)Misc.createExpression(null, exp));
                    if (wizardDescriptor.getProperty("header") != null && wizardDescriptor.getProperty("header").equals("true")) {
                        b = new JRDesignBand();
                        b.setHeight(50);
                        grp.setGroupHeader((JRBand)b);
                    }
                    if (wizardDescriptor.getProperty("footer") != null && wizardDescriptor.getProperty("footer").equals("true")) {
                        b = new JRDesignBand();
                        b.setHeight(50);
                        grp.setGroupFooter((JRBand)b);
                    }
                    jd.addGroup(grp);
                    AddGroupUndoableEdit edit = new AddGroupUndoableEdit(grp, jd.getMainDesignDataset());
                    IReportManager.getInstance().addUndoableEdit(edit);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private WizardDescriptor.Panel[] getPanels(JasperDesign jd) {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new ReportGroupWizardPanel1(jd), new ReportGroupWizardPanel2(jd)};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public String getName() {
        return "Add Report Group";
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

